;;;
;;; Copyright (c) 1982 Regents of the University of California
;;; Copyright (c) 1987 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 

(in-package 'sling :use '(ff))

;;;
;;; Load in the appropriate libsq routines
;;;

(defvar *libsq-loaded* nil)
  
(when (null *libsq-loaded*)
  (remove-entry-point "__ubound")
  (remove-entry-point "__malloc_at_addr")
  (remove-entry-point "___mallinfo")
  (remove-entry-point "__root")
  (remove-entry-point "__lbound")
  (remove-entry-point "_pclose")
  (remove-entry-point "_realloc")
  (remove-entry-point "_valloc")
  (remove-entry-point "_calloc")
  (remove-entry-point "_malloc")
  (remove-entry-point "_memalign")
  (remove-entry-point "_free")
  (remove-entry-point "__ypsleeptime")
  (remove-entry-point "_yp_bind")
  (remove-entry-point "_yp_unbind")
  (remove-entry-point "_yp_get_default_domain")
  (remove-entry-point "__yp_dobind")
  (remove-entry-point "__ypserv_timeout")
  (remove-entry-point "_cfree")
  ;; load the libsq library via a slight hack
  (unless (null
	   (load ""
		 :foreign-files
		 '("libsq.o"
		   "/usr/ingres6/ingres/lib/libingres.a")
		 ))
	  (setq *libsq-loaded* t)))


;;;
;;; Set to t if you want strict argument checking
;;;

(defvar *libsq-argument-check** t)

;;;
;;; system level database commands
;;;
(defun system-level-db-command (command dbname &optional flags)
  (excl:run-shell-command
   (concatenate 'simple-string 
		(string command) " " (string flags) " " (string dbname))))

;;;
;;; full path name
;;;
(defun full-path-name (name)
  (if (eql #\/ (char name 0))
      name
    (concatenate 'simple-string 
		 (namestring (excl:current-directory)) name)))
;;;
;;; Imported libsq functions
;;;

(defforeign 'ii-sqInit
  :entry-point "_IIsqInit"
  :arg-checking *libsq-argument-check**
  :arguments '(t)
  :return-type :void)

(defforeign 'ii-writio
  :entry-point "_IIwritio"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum fixnum fixnum fixnum simple-string)
  :return-type :void)

(defforeign 'ii-syncup
  :entry-point "_IIsyncup"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum)
  :return-type :void)

;;; Special, since it takes a variable number of arguments
;;;
(defforeign 'ii-sqConnect
  :entry-point "_myIIsqConnect"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string simple-string)
  :return-type :void)

(defforeign 'ii-sqDisconnect
  :entry-point "_IIsqDisconnect"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :void)

(defforeign 'ii-xact
  :entry-point "_IIxact"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum)
  :return-type :void)

(defforeign 'ii-putdomio
  :entry-point "_IIputdomio"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum fixnum fixnum t)
  :return-type :fixnum)

(defforeign 'ii-getdomio
  :entry-point "_IIgetdomio"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum fixnum fixnum t)
  :return-type :fixnum)

(defforeign 'ii-sqMods
  :entry-point "_IIsqMods"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum)
  :return-type :void)

(defforeign 'ii-retinit
  :entry-point "_IIretinit"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-nextget
  :entry-point "_IInextget"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :fixnum)

(defforeign 'ii-sqFlush
  :entry-point "_IIsqFlush"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-flush
  :entry-point "_IIflush"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-break
  :entry-point "_IIbreak"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :void)

(defforeign 'ii-errtest
  :entry-point "_IIerrtest"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :fixnum)
(defforeign 'ii-getdomio
  :entry-point "_IIgetdomio"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum fixnum fixnum t)
  :return-type :void)

;;; Special addition for getting around typing differences.
;;;
(defforeign 'ii-reti
  :entry-point "_myIIreti"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :integer)
(defforeign 'ii-retf
  :entry-point "_myIIretf"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :single-float)
(defforeign 'ii-rets
  :entry-point "_myIIrets"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string)
  :return-type :integer)

(defforeign 'ii-csOpen
  :entry-point "_IIcsOpen"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum)
  :return-type :void)
(defforeign 'ii-csClose
  :entry-point "_IIcsClose"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum)
  :return-type :void)
(defforeign 'ii-csQuery
  :entry-point "_IIcsQuery"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum)
  :return-type :void)
(defforeign 'ii-csRetrieve
  :entry-point "_IIcsRetrieve"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum)
  :return-type :fixnum)
(defforeign 'ii-csERetrieve
  :entry-point "_IIcsERetrieve"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :void)
(defforeign 'ii-csDelete
  :entry-point "_IIcsDelete"
  :arg-checking *libsq-argument-check**
  :arguments '(t simple-string fixnum fixnum)
  :return-type :void)
(defforeign 'ii-csERplace
  :entry-point "_IIcsERplace"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum)
  :return-type :void)
(defforeign 'ii-csDaGet
  :entry-point "_IIcsDaGet"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum t)
  :return-type :void)
(defforeign 'ii-sqDaIn
  :entry-point "_IIsqDaIn"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum t)
  :return-type :void)
(defforeign 'ii-csGetio
  :entry-point "_IIcsGetio"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum fixnum fixnum fixnum t)
  :return-type :void)
;; for getting around typing diffs again
(defforeign 'ii-csGeti
  :entry-point "_mycsGeti"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :integer)
(defforeign 'ii-csGetf
  :entry-point "_mycsGetf"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :single-float)
(defforeign 'ii-csGets
  :entry-point "_mycsGets"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string)
  :return-type :integer)

(defforeign 'ii-sqExImmed
  :entry-point "_IIsqExImmed"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string)
  :return-type :void)
(defforeign 'ii-sqPrepare
  :entry-point "_IIsqPrepare"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum simple-string fixnum fixnum t)
  :return-type :void)
(defforeign 'ii-sqExStmt
  :entry-point "_IIsqExStmt"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum)
  :return-type :void)
(defforeign 'ii-sqDescribe
  :entry-point "_IIsqDescribe"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum simple-string t fixnum)
  :return-type :void)
(defforeign 'ii-eqiqi
  :entry-point "_myeqiqioi"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string)
  :return-type :integer)
(defforeign 'ii-eqiqf
  :entry-point "_myeqiqiod"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string)
  :return-type :single-float)
(defforeign 'ii-eqiqs
  :entry-point "_myeqiqios"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string simple-string)
  :return-type :integer)

(defforeign 'ii-LQpriProcInit
  :entry-point "_IILQpriProcInit"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum simple-string)
  :return-type :void)
(defforeign 'ii-LQprvProcValio
  :entry-point "_IILQprvProcValio"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum fixnum fixnum fixnum fixnum t)
  :return-type :void)
(defforeign 'ii-LQprvI
  :entry-point "_myIILQprvI"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string fixnum)
  :return-type :void)
(defforeign 'ii-LQprvF
  :entry-point "_myIILQprvF"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string single-float)
  :return-type :void)
(defforeign 'ii-LQprvS
  :entry-point "_myIILQprvS"
  :arg-checking *libsq-argument-check**
  :arguments '(simple-string simple-string)
  :return-type :void)
(defforeign 'ii-LQprsProcStatus
  :entry-point "_IILQprsProcStatus"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :fixnum)
(defforeign 'ii-putctrl
  :entry-point "_IIputctrl"
  :arg-checking *libsq-argument-check**
  :arguments '(fixnum)
  :return-type :void)

;;;
;;; SQL Communications Area (sqlca) structure
;;;

;; sqlca structure
(defcstruct (sqlca :malloc) ; in C space, not in LISP space
  (sqlcaid 8	:char)		; char sqlcaid[8]
  (sqlcabc		:long)
  (sqlcode		:long)
  (sqlerrm		(sqlerrml	:short)	; struct {...} sqlerrm
				(sqlerrmc 70	:char))		; char sqlerrmc[70]
  (sqlerrp 8	:char)		; char sqlerrp[8]
  (sqlerrd 6	:long)		; long sqlerrd[6]
  (sqlwarn		(sqlwarn0	:char)	; struct {...} sqlwarn
				(sqlwarn1	:char)
				(sqlwarn2	:char)
				(sqlwarn3	:char)
				(sqlwarn4	:char)
				(sqlwarn5	:char)
				(sqlwarn6	:char)
				(sqlwarn7	:char))
  (sqlext  8	:char))		; char sqlext[8]

;;;
;;; returns sqlca's location for db-whenever and ii-sqInit
;;;
(defforeign 'sqlca-loc
  :entry-point "_sqlcaLoc"
  :arg-checking *libsq-argument-check**
  :arguments nil
  :return-type :fixnum)

;;;
;;; SQL Descriptor Area (sqlda) for Dynamic SQL
;;;

(defcstruct sqlname-struct
  (sqlname1		:short)
  (sqlnamec 34	:char))

(defcstruct sqlvar-struct
  (sqltype		:short)
  (sqllen		:short)
  (sqldata	*	:char)
  (sqlind	*	:short)
  (sqlname 		sqlname-struct))

;; number of sqlvar elements in the sqlda: one for each result column
(defconstant sqlda-num-vars 128)

(eval `(defcstruct sqlda
				   (sqldaid	8	:char)
				   (sqldabc		:long)
				   (sqln		:short)
				   (sqld		:short)
				   (sqlvar ,sqlda-num-vars sqlvar-struct)))

(defvar sqlda (make-sqlda))
