/*
 * Copyright (c) 1987 Regents of the University of California
 * Copyright (c) 1982 Regents of the University of California
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the University of
 * California not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  The University of California makes no representations
 * about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 * 
 */

#include <strings.h>
#include <stdio.h>

#include "/usr/ingres6/ingres/files/eqsqlca.h"
extern IISQLCA sqlca;   /* SQL Communications Area */

void
myIIsqConnect(dbname, flags)
    char *dbname;
    char *flags;
{
    /* Determine if ingres really allows multiple arguments in one string */
    if (!strlen(flags)) {
	IIsqConnect(0, dbname, NULL);
    } else {
	IIsqConnect(0, dbname, flags, NULL);
    }

/*    (void) IIseterr() */ /* should use this if don't want lisp to die */
}

/*
 * Pass a pointer to the sqlca back to lisp so it can be accessed 
 * (for db-whenever)
 */
IISQLCA *
sqlcaLoc()
{
    return (&sqlca);
}

/*
 * Use this to get back an int, since could be a bignum, not a fixnum.
 */
long
myIIreti()
{
    long num;
	short ind;

    IIgetdomio(&ind, 1, 30, 4, &num);
    return (num);
}

/*
 * Use this, just so that don't have to play with magic at the lisp level.
 */
double
myIIretf()
{
    double	num;
	short	ind;
    IIgetdomio(&ind, 1, 31, 8, &num);
    return (num);
}

/*
 * The max char string is 255 chars and the max text string is 2000.
 * The given string buffer should be at least 2001 bytes long.
 */
int
myIIrets(s)
    char *s;
{
	short ind;

    bzero(s, 2001);
    IIgetdomio(&ind, 1, 32, 0, s);
    return (strlen(s));
}


/*
 * Use this to get back an int, since could be a bignum, not a fixnum.
 * Cursor version.
 */
long
mycsGeti()
{
    long num;

    IIcsGetio(NULL, 1, 30, 4, &num);
    return (num);
}

/*
 * Use this, just so that don't have to play with magic at the lisp level.
 * Cursor version.
 */
double
mycsGetf()
{
    double	num;
    IIcsGetio(NULL, 1, 31, 8, &num);
    return (num);
}

/*
 * The max char string is 255 chars and the max text string is 2000.
 * The given string buffer should be at least 2001 bytes long.
 * Cursor version.
 */
int
mycsGets(s)
    char *s;
{
    bzero(s, 2001);
    IIcsGetio(NULL, 1, 32, 0, s);
    return (strlen(s));
}

/*
 * Use this to get back an int, since could be a bignum, not a fixnum.
 */
long
myeqiqioi(o)
char *o;
{
    long num;

    IIeqiqio(NULL, 1, 30, 4, &num, o);
    return (num);
}

/*
 * Use this, just so that don't have to play with magic at the lisp level.
 */
double
myeqiqiod(o)
char *o;
{
    double	num;
    IIeqiqio(NULL, 1, 31, 8, &num, o);
    return (num);
}

/*
 * The max char string is 255 chars and the max text string is 2000.
 * The given string buffer should be at least 2001 bytes long.
 */
int
myeqiqios(s, o)
    char *s, *o;
{
    bzero(s, 2001);
    IIeqiqio(NULL, 1, 32, 0, s, o);
    return (strlen(s));
}

/*
 * Send a integer argument to a database procedure.
 */
myIILQprvI(name, num)
char *name;
long num;
{
    IILQprvProcValio(name, 0, NULL, 1, 30, 4, &num);
}

/*
 * Send a float argument to a database procedure.
 */
myIILQprvF(name, num)
char *name;
float	num;
{
    IILQprvProcValio(name, 0, NULL, 1, 31, 8, &num);
}

/*
 * Send a string argument to a database procedure.
 */
myIILQprvS(name, s)
char *name;
char *s;
{
    IILQprvProcValio(name, 0, NULL, 1, 32, 0, s);
}

/*
 * This is a dummy function to cause the loader to grab all
 * the right functions into the lisp environment.
 */
static void
libq()
{
    IIsqInit();
    IIwritio();
    IIsyncup();
    IIsqConnect();
    IIsqDisconnect();
    IIxact();
    IIputdomio();
    IIgetdomio();
    IIsqMods();
    IIretinit();
    IInextget();
    IIsqFlush();
    IIflush();
    IIbreak();
    IIerrtest();

	IIcsOpen();
	IIcsQuery();
	IIcsRetrieve();
	IIcsGetio();
	IIcsERetrieve();
	IIcsClose();
	IIcsDelete();
	IIcsERplace();
	IIcsDaGet();
	IIsqDaIn();

	IIsqExImmed();
	IIsqPrepare();
	IIsqExStmt();
	IIsqDescribe();

	IILQpriProcInit();
	IILQprvProcValio();
	IILQprsProcStatus();
	IIputctrl();
}
