;;;
;;; PDS (Picasso defsystem) Utility
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/module.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 19:02:15 $
;;;

(in-package 'pds :use '(lisp))

;;;
;;; Module structure definition
;;;
(defstruct (module (:print-function print-module))
  (name "")			;; Filename (no extensions) of module
  (system nil)			;; System containing module
  (pathname nil)		;; Cached pathname
  (source-pathname nil)		;; Cached pathname
  (binary-pathname nil)		;; Cached pathname
  (sub-directory "")		;; Subdir off system root dir
  (load-before-compile nil)	;; Setfs, macros and class defs
  (recompile-on nil)		;; macro defs
  (load-after nil)		;; class, setf defs
  (load-date 0)			;; Date of load, universal time format
  (loaded nil)			;; Ever loaded?
  (load-in-process nil)		;; Are we in the middle of loading this?
  (compile-in-process nil))	;; Are we in the middle of compiling this?

;;;
;;; Module print function
;;;
(defun print-module (module stream level)
  (declare (ignore level))
  (format stream "#<Module ~A/~A>" (module-sub-directory module)
	  (module-name module)))

;;;
;;; Find module
;;;
(defun find-module-named (name system)
  "find all the modules with the specified name in the specified system"
  (let* ((pos (position #\/ name :from-end t))
	 (subdir (if pos (subseq name 0 pos) ""))
	 (mod-name (if pos (subseq name (1+ pos)) name))
	 (module-list (system-module-list system)))
	(dolist (m module-list)
		(if (and (string= subdir (module-sub-directory m))
			 (string= mod-name (module-name m)))
		    (return-from find-module-named m))))
  (warn "Module named ~s not found in system ~s~%" name system))

;;;
;;; show a module
;;;
(defun show-module (module)
  "show a module definition in detail"
  (output "module: ~s~%" (module-name module))
  (output "sub-directory: ~s~%" (module-sub-directory module))
  (output "pathname: ~s~%" (module-pathname module))
  (output "system: ~s~%" (module-system module))
  (output "load-date: ~s~%" (module-load-date module))
  (output "loaded: ~s~%" (module-loaded module))
  (output "recompile-on: ~s~%"
	  (mapcar #'module-name (module-recompile-on module)))
  (output "load-before-compile: ~s ~%" 
	  (mapcar #'(lambda (x)
			    (if (listp x) (mapcar #'module-name x)
				(module-name x)))
		  (module-load-before-compile module))))
