;;; -*-Mode: LISP; Package: DEFSYSTEM; Base: 10; Syntax: Common-lisp -*-
;;;
;;; PDS (Picasso defsystem) Utility
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/macros.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/22 16:52:01 $
;;;

(in-package 'pds :use '(lisp))

;;;
;;; macro defn's
;;;
(defmacro output (&rest body)
  `(progn (format *terminal-io* ,@body) (force-output *terminal-io*)))

(defmacro strcat (&rest strs)
  `(concatenate 'string ,@strs))

;;;
;;; Undefsystem macro
;;;
(defmacro undefsystem (system-name)
  "undefine the system with the specified name"
  `(setq *all-systems*
	 (remove-if #'(lambda (x) (eql (car x) ',system-name))
		    *all-systems*)))

;;;
;;; Defsystem macro
;;;
(defmacro defsystem (name options &body module-list)
  `(let* ((sconstruct (append '(:name ,name) ',options))
	  (asystem (apply #'make-system sconstruct)))
	 (when (assoc ',name *all-systems*)
	       (setq *all-systems*
		     (remove-if #'(lambda (x) (equal (car x) ',name))
				*all-systems*)))
	 ;; add system to *all-systems* list
	 (push (cons ',name asystem) *all-systems*)
	 (let ((smodule-list (system-module-list asystem)))
	      (dolist (module ',module-list)
		      (let* ((mconstruct (if (symbolp module)
					     (list ':name module)
					     (cons ':name module)))
			     (amodule (apply #'make-module mconstruct)))
			    (setf (module-system amodule) asystem)
			    (push amodule smodule-list)))
	      ;; reverse the module list
	      (setf (system-module-list asystem) (reverse smodule-list)))
	 ;; Resolve the module names provided
	 (let ((temp nil))
	      (dolist (mod (system-module-list asystem))
		      (dolist (lbc (module-load-before-compile mod))
			      (pushnew (find-module-named lbc asystem) temp))
		      (setf (module-load-before-compile mod) temp)
		      (setq temp nil)
		      (dolist (lbc (module-load-after mod))
			      (pushnew (find-module-named lbc asystem) temp))
		      (setf (module-load-after mod) temp)
		      (setq temp nil)
		      (dolist (lbc (module-recompile-on mod))
			      (pushnew (find-module-named lbc asystem) temp))
		      (setf (module-recompile-on mod) temp)))
	 ;; return system
	 asystem))

(defmacro doc-or-decl-p (form)
  "Return t if argument is a declaration or a doc-string."
  `(or (stringp ,form) (and (consp ,form) (eq (car ,form) 'declare))))

(defmacro skip-method-qualifiers (body)
  "Skip over method qualifier in a defmethod form."
  `(do ()
       ((or (null ,body) (not (keywordp (car ,body)))))
       (setq ,body (cdr ,body))))

(defmacro skip-decl-doc (body)
  "Skip over the declarations and doc-strings in a body of code."
  `(do ()
       ((or (null ,body) (not (doc-or-decl-p (car ,body)))))
       (setq ,body (cdr ,body))))

;;;
;;; Macros to register definition of macros, classes and setf-methods
;;; in the right hash tables.
;;;
(defmacro register-macro-definition (mod macro-name)
  `(setf (gethash ,macro-name *macro-file-map*) ,mod))

(defmacro register-class-definition (mod class-name)
  `(setf (gethash ,class-name *class-file-map*) ,mod))

(defmacro register-setf-definition (mod setf-name)
  `(pushnew ,mod (gethash ,setf-name *setf-file-map*)))

;;;
;;; Macros to register usage of macros, classes and setf-methods
;;; in the right hash tables.
;;;
(defmacro register-macro-usage (mod macros)
  `(setf (gethash ,mod *file-macro-usage-map*)
	 (union ,macros (gethash ,mod *file-macro-usage-map*))))
(defmacro register-class-usage (mod classes)
  `(setf (gethash ,mod *file-class-usage-map*)
	 (union ,classes (gethash ,mod *file-class-usage-map*))))
(defmacro register-setf-usage (mod setfs)
  `(setf (gethash ,mod *file-setf-usage-map*)
	 (union ,setfs (gethash ,mod *file-setf-usage-map*))))

(defmacro circular (mod)
  `(progn
    (show-setfs-used-in ,mod)
    (show-classes-used-in ,mod)
    (show-macros-used-in ,mod)
    (error "Circular dependency compiling file ~s~%" (module-name ,mod))))

