;;; -*-Mode: LISP; Package: DEFSYSTEM; Base: 10; Syntax: Common-lisp -*-
;;;
;;; PDS (Picasso defsystem) Utility
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/io.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/22 16:51:59 $
;;;

(in-package 'pds :use '(lisp))

(defvar *mod-hash-table* nil)

(defmacro strcat (&rest args)
  `(concatenate 'string ,@args))

(defun mod-desc (m)
  (strcat (module-sub-directory m) "/" (module-name m)))

(defun save-mod-name (m f)
  (if (consp m)
      (progn
       (format f "(")
       (mapc #'(lambda (x) (save-mod-name x f)) m)
       (format f ") "))
      (format f "~s " (mod-desc m))))

(defun parse-mod-name (desc sys)
  (if (stringp desc)
      (gethash desc *mod-hash-table*)
      (mapcar #'(lambda (x) (parse-mod-name x sys)) desc)))

(defun save-module-to-file (m f)
  (format f "~% (")
  (dolist (v (module-load-before-compile m))
	  (save-mod-name v f))
  (format f ")~% (")
  (dolist (v (module-load-after m))
	  (save-mod-name v f))
  (format f ")~% (")
  (dolist (v (module-recompile-on m))
	  (save-mod-name v f))
  (format f ")~%"))

(defun load-module-from-file (sys m f &aux l)
  ;; Get module-load-before-compile list...
  (setq l nil)
  (dolist (desc (read f nil nil t))
	  (push (parse-mod-name desc sys) l))
  (setf (module-load-before-compile m) (nreverse l))

  ;; Get module-load-after list...
  (setq l nil)
  (dolist (desc (read f nil nil t))
	  (push (parse-mod-name desc sys) l))
  (setf (module-load-after m) (nreverse l))

  ;; Get module-recompile-on list...
  (setq l nil)
  (dolist (desc (read f nil nil t))
	  (push (parse-mod-name desc sys) l))
  (setf (module-recompile-on m) (nreverse l)))


(defun save-parsed-system (system filename)
  (if (symbolp system)
      (setq system (find-system-named system)))
  (let ((out-file (open filename :direction :output)))
       (format out-file "~s~%" (system-name system))
       (dolist (mod (system-module-list system))
	       (save-mod-name mod out-file)
	       (save-module-to-file mod out-file))
       (close out-file)))

(defun load-parsed-system (filename &aux sys mod)
   (let ((in-file (open filename :direction :input)))
       (setq sys (find-system-named (read in-file nil nil t)))
       (setf *mod-hash-table*
	     (make-hash-table :test #'equal
			      :size (length (system-module-list sys))))
       (dolist (m (system-module-list sys))
	       (setf (gethash (mod-desc m) *mod-hash-table*) m))
       (do* ((mod-name (read in-file nil nil t) (read in-file nil nil t)))
	    ((null mod-name))
	    (setq mod (parse-mod-name mod-name sys))
	    (if mod
		(load-module-from-file sys mod in-file)
		(format t
			"Warning: module %s in %s, but not in sysdef file~%"
			mod-name filename)))
       (close in-file)))
       

