;;; -*-Mode: LISP; Package: DEFSYSTEM; Base: 10; Syntax: Common-lisp -*-
;;;
;;; PDS (Picasso defsystem) Utility
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/globals.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/22 16:51:59 $
;;;

(in-package 'pds :use '(lisp))

;;;
;;; PDS version
;;;
(defvar *pds-version* "$Revision: 1.1 $")

;;;
;;; Add :pds to features list
;;;
(setf *features* (union *features* '( :pds )))

;;;
;;; Common LISP suffixes
;;;
(defvar *suffixes*
  #+Symbolics                         '("lisp"  . "bin")
  #+(and dec common vax (not ultrix)) '("LSP"   . "FAS")
  #+(and dec common vax ultrix)       '("lsp"   . "fas")
  #+KCL                               '("lsp"   . "o")
  #+Xerox                             '("lisp"  . "dfasl")
  #+(and Lucid MC68000)               '("lisp"  . "lbin")
  #+(and Lucid VAX VMS)               '("lisp"  . "vbin")
  #+excl                              '("cl"    . "fasl")
  #+system::cmu                       '("slisp" . "sfasl")
  #+PRIME                             '("lisp"  . "pbin")
  #+HP                                '("l"     . "b")
  #+TI                                '("lisp"  . "xfasl"))

;;;
;;; Global variables
;;;
(defvar *all-systems* nil "All defined systems")
(defvar *just-testing* nil "Are we testing the load-system or compile-system")
(defvar *debug* nil)
(defvar *indent* 0)

;;; *class-file-map*:   A Hash table that maps from class names (symbols) to
;;;                     files in which they're defined.
;;;
;;; *macro-file-map*:   A Hash table that maps from macro names (symbols) to
;;;                     files in which they're defined.
;;;
;;; *file-macro-usage-map*:     An a-list, the key of which is a file
;;;                     name and the datum of which is a list of macros used
;;;                     in that file.
;;;
;;; *file-class-usage-map*:     An a-list, the key of which is a file
;;;                     name and the datum of which is a list of class used
;;;                     in that file.
(defvar *class-file-map* nil)
(defvar *setf-file-map* nil)
(defvar *macro-file-map* nil)
(defvar *file-macro-usage-map* nil)
(defvar *file-setf-usage-map* nil)
(defvar *file-class-usage-map* nil)

