;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

;;;
;;; This method definition appears at the end of the file high.lisp
;;; where is is possible to have it.
;;; 
;(defmethod mki ((class-name symbol) &rest initargs)
;  (apply #'mki (find-class class-name) initargs))

(defmethod mki ((class standard-class) &rest initargs)
  (setq initargs (default-initargs class initargs))
 ;(check-initargs class initargs)
  (let ((instance (apply #'allocate-instance class initargs)))
    (apply #'initialize-instance instance initargs)
    instance))

(defmethod default-initargs ((class standard-class) initargs)
  (let ((internal (default-initargs-internal class initargs)))
    (iterate ((loc (*list-tails (cdr internal) :by #'cddr)))
      (setf (car loc) (funcall (car loc))))
    (append initargs internal)))

(defun default-initargs-internal (class initargs)
  (let ((defaults (copy-list (class-all-default-initargs class))))
    (doplist (key val) initargs
      (setq defaults (delete (assq key defaults) defaults)))
    (labels ((rcollect (tail)
	       (if (null tail)
		   nil
		   (list* (caar tail)
			  (cadar tail)
			  (rcollect (cdr tail))))))
      (rcollect defaults))))

(defmethod initialize-instance ((object object) &rest initargs)
  (let* ((class (class-of object))
	 (slotds (class-slots class)))
    (dolist (slotd slotds)
      (let ((slot-name (slotd-name slotd))
	    (slot-initargs (slotd-initargs slotd)))
	(labels ((walk-backwards (tail)
		   (if (null tail)
		       nil
		       (progn
			 (walk-backwards (cddr tail))
			 (let ((key (pop tail))
			       (val (pop tail)))
			   (when (memq key slot-initargs)
			     (setf (slot-value object slot-name) val)))))))
	  (walk-backwards initargs)	  
	  (unless (slot-boundp object slot-name)
	    (let ((initfunction (slotd-initfunction slotd)))
	      (when initfunction 
		(setf (slot-value object slot-name)
		      (funcall initfunction ))))))))))

#|

(defun optimize-make-instance (form)
  (flet ((reduce-constant (constant)
	   (if (and (listp constant)
		    (eq (car constant) 'quote))
	       (cadr constant)
	       constant)))	       
    (if (not (constantp (cadr form)))		;Is the class a constant
	form
	(let ((class (reduce-constant (cadr form)))
	      (constant-keys t)
	      (constant-vals t))
	  (let ((tail (cddr form)))
	    (loop (when (null tail) (return nil))
		  (unless (constantp (pop tail)) (setq constant-keys nil))
		  (unless (constantp (pop tail)) (setq constant-vals nil)))

	    (cond ((null constant-keys) form)
		  ((null constant-vals)
		   (let ((keys (gathering ((k (collecting)))
                                 (iterate ((key (*list-elements (cddr form)
								:by #'cddr)))
                                   (gather (reduce-constant key) k))))
			 (vals (gathering ((v (collecting)))
                                 (iterate ((val (*list-elements (cdddr form)
								:by #'cddr)))
				   (gather val v)))))
		     `(funcall
			(symbol-function
			  (load-time-eval
			    (install-constructor-1 ',class
						   ',keys)))
			,@vals)))
		  (t	
		   (let ((keys (gathering ((k (collecting)))
                                 (iterate ((key (*list-elements (cddr form)
								:by #'cddr)))
                                   (gather (reduce-constant key) k))))
			 (vals (gathering ((v (collecting)))
                                 (iterate ((val (*list-elements (cdddr form)
								:by #'cddr)))
				   (gather val v)))))
		     `(funcall
			(symbol-function
			  (load-time-eval
			    (install-constructor-2 ',class
						   ',keys
						   ',vals))))))))))))

(defvar *initarg-argument-symbols* (make-hash-table :size 100 :test #'eq))

(defun initarg-argument-symbol (key)
  (or (gethash key *initarg-argument-symbols* nil)
      (setf (gethash key *initarg-argument-symbols* nil)
	    (make-symbol (symbol-name key)))))

(defun install-constructor-1 (class keys)
  (let ((name (intern (format nil "Make ~S ~S" class keys)))
	(vars (mapcar #'initarg-argument-symbol keys)))
    (unless nil (fboundp name)
      (compile name
	       `(lambda ,vars 
		  ,(install-constructor-internal name
						 class
						 keys
						 vars))))
    name))

(defun install-constructor-2 (class keys vals)
  (let ((name (intern (format nil "Make ~S ~S ~S" class keys vals)))
	(vars (mapcar #'initarg-argument-symbol keys)))
    (unless nil (fboundp name)
      (compile name
	       `(lambda ()
		  (let ,(mapcar #'list vars vals)
		    ,(install-constructor-internal name
						   class
						   keys
						   vars)))))
    name))

(defun install-constructor-internal (name class-name keys vars)
  `(apply #'make-instance
	  ',class-name
	  (list ,@(gathering ((initargs (collecting)))
                    (iterate ((key (list-elements keys))
      			      (var (list-elements vars)))
		      (gather key initargs)
		      (gather var initargs))))))

|#