;;;-*-Mode:LISP; Package: PCL; Base:10; Syntax:Common-lisp; -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

;;; 8/4/88
(defun GET-SETF-GENERIC-FUNCTION (name)
  (gdefinition `(setf ,name)))

(defsetf get-setf-generic-function (name) (new-value)
  `(setf (gdefinition ,name) ,new-value))

(defun get-setf-generic-function-name (name)
  (or (gethash name *setf-function-names*)
      (setf (gethash name *setf-function-names*)
	    (symbol-append "SETF " name (symbol-package name)))))


(defmacro defmethod-setf (name lambda-list new-value-lambda-list &body body)
  `(defmethod (setf ,name) (,@new-value-lambda-list ,@lambda-list)
     ,@body))

(defmacro run-super () '(call-next-method))

;;;
;;; set this variable to T if you insist upon not converting right away.
;;; 
(defvar *inhibit-with-slots-warning* nil)

(defmacro obsolete-with-slots
	  #-KCL (instance-forms-and-options &body body &environment env)
	  #+KCL (&environment env instance-forms-and-options &body body)
  (unless *inhibit-with-slots-warning*
    (warn "The obsolete-with-slots macro is obsolete.  You should convert to~%~
           with-slots or with-accessors as soon as possible."))
  (let ((ifos
	  (mapcar
	    #'(lambda (ifo)
		(when (symbolp ifo) (setq ifo (list ifo)))
		(let ((class
			(or (getf (cdr ifo) :class)
			    (variable-class (car ifo) env)))
		      (accessors
			(cond ((getf (cdr ifo) :use-accessors)  't)
			      ((getf (cdr ifo) :use-slot-value) 'nil)
			      (t 't)))
		      (prefix (getf (cdr ifo) :prefix nil)))
		  `(,(car ifo) :class ,class
			       :use-accessors ,accessors
			       :prefix ,prefix)))
	    instance-forms-and-options)))
    (labels ((convert-first-arg (ifo)
	       (unless (getf (cdr ifo) :class)
		 (error "The class of ~S was not specified and could not~%~
                         be inferred from the lexical context."
			(car ifo)))
	       (let* ((accessors (getf (cdr ifo) :use-accessors))
		      (class (getf (cdr ifo) :class))
		      (prefix (getf (cdr ifo) :prefix))
		      (slots (class-slots (find-class class))))
		 (if accessors
		     (values 'with-accessors*
			     (mapcar #'(lambda (slotd)
					 (list (if prefix
						   (symbol-append prefix
								  (slotd-name slotd))
						   (slotd-name slotd))
					       (car (slotd-readers slotd))))
				     slots))
		     (values 'with-slots*
			     (mapcar #'(lambda (slotd)
					 (list (if prefix
						   (symbol-append prefix
								  (slotd-name slotd))
						   (slotd-name slotd))
					       (slotd-name slotd)))
				     slots)))))
	     (recurse (tail)		 
	       (if (null tail)
		   body
		   (multiple-value-bind (form first-arg)
		       (convert-first-arg (car tail))			  
		     (list* form
			    first-arg
			    (caar tail)
			    (recurse (cdr tail)))))))
      (recurse ifos))))


;;;
;;; SYMBOL-CLASS
;;; CBOUNDP
;;; class-named
;;;
;;; These are exist for backward compatibility.
;;; 
(defun SYMBOL-CLASS (symbol &optional environment)
  (declare (ignore environment))
  (find-class symbol nil))

(defsetf SYMBOL-CLASS (symbol &optional environment) (new-value)
  (declare (ignore environment))
  `(|SETF FIND-CLASS| ,new-value ,symbol))

(defun CBOUNDP (symbol &optional environment)
  (declare (ignore environment))
  (if (find-class symbol nil) 't 'nil))

(defun class-named (name &optional no-error-p)
  (find-class name (not no-error-p)))

(defsetf class-named (name &optional no-error-p) (new-value)
  (declare (ignore no-error-p))
  `(|SETF FIND-CLASS| ,new-value ,name))
