/*
 * Copyright (c) 1987 Regents of the University of California
 * Copyright (c) 1982 Regents of the University of California
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the University of
 * California not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  The University of California makes no representations
 * about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 * 
 */

#include <strings.h>
#include <stdio.h>


void
myIIingres(dbname, flags)
    char *dbname;
    char *flags;
{
    /* Determine if ingres really allows multiple arguments in one string */
    if (!strlen(flags)) {
	IIingopen(0, dbname, NULL);
    } else {
	IIingopen(0, flags, dbname, NULL);
    }

/*    (void) IIseterr() */ /* should use this if don't want lisp to die */
}

/*
 * Use this to get back an int, since could be a bignum, not a fixnum.
 */
long
myIIreti()
{
    long num;

    IIretdom(1, 30, 4, &num);
    return (num);
}

/*
 * Use this, just so that don't have to play with magic at the lisp level.
 */
double
myIIretf()
{
    double	num;
    IIretdom(1, 31, 8, &num);
    return (num);
}

/*
 * The max char string is 255 chars and the max text string is 2000.
 * The given string buffer should be at least 2001 bytes long.
 */
int
myIIrets(s)
    char *s;
{
    bzero(s, 2001);
    IIretdom(1, 32, 0, s);
    return (strlen(s));
}

int
myIIeqinq(s)
char	*s;
{
    int	num;

    IIeqinq(1, 30, 4, &num, s);
    return (num);
}

/*
 * This is a dummy function to cause the loader to grab all
 * the right functions into the lisp environment.
 */
static void
libq()
{
    IIerrtest();
    IIexit();
    IIwritedb();
    IIretinit();
    IInextget();
    IIflush();
    IIsyncup();
    IIbreak();
}
