;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: bsmith $
;;; $Source: RCS/dialog-dir.cl,v $
;;; $Revision: 1.7 $
;;; $Date: 90/02/08 23:11:10 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;	
;;;	Functions to use with open-file & close-file dialogs
;;;

(defun load-dir-all (dir)
  (cons (list "../")
	(mapcar #'(lambda (x &aux fname) 
			  (setq fname (file-namestring x))
			  (if (probe-file (pcl::string-append 
					   (namestring x) "/"))
			      (list (pcl::string-append fname "/"))
			      (list fname)))
		(user::directory dir))))

(defun load-dir-dirs (dir)
  (cons (list "../")
	(mapcan #'(lambda (x &aux fname) 
			  (setq fname (file-namestring x))
			  (when (probe-file (pcl::string-append 
					     (namestring x) "/"))
				(list (list (pcl::string-append fname "/")))))
		(user::directory dir))))

(defun dir-button-pressed (self &rest event &aux entry)
  (declare (ignore event))
  (when #!ecur@self (return-from dir-button-pressed))
  (setf #!ecur@self t
	(current-indices (matrix-field #!ta@self)) nil)
  (setq entry #!entry@self)
  (pushnew :button-press (event-mask entry))
  (pushnew :button-release (event-mask entry))
  (setf (border-type entry)
	(if (eq (border-type entry) :frame)
	    :black-frame
	    :frame))
  (label-repaint (label-type entry) entry))
