;; this file contains the support code needed for the paper demo application

(defclass department ()
  ((name :initarg :name :type string :accessor name)
   (dfloor :initarg :dfloor :type string :accessor dfloor)
   (manager :initarg :manager :type string :accessor manager)
   (floor-plan :initarg :floor-plan :type t :accessor floor-plan)))

(defclass employee ()
 ((name :initarg :name :type string :accessor name)
  (next_name :type employee :initform nil :accessor next_name)
  (prev_name :type employee :initform nil :accessor prev_name)
  (age :initarg :age :type string :accessor age)
  (next_age :type employee :initform nil :accessor next_age)
  (prev_age :type employee :initform nil :accessor prev_age)
  (dname :initarg :dname :type string :accessor dname)
  (department :initarg :department :type department :accessor department)
  (next_dept :type employee :initform nil :accessor next_dept)
  (prev_dept :type employee :initform nil :accessor prev_dept)
  (floor-plan :initarg :floor-plan :type bitmap :accessor floor-plan)
  (picture :initarg :picture :type bitmap :accessor picture)))

(defun make-department (&rest keys)
  (apply #'make-instance 'department keys))

(defun make-employee (&rest keys)
  (apply #'make-instance 'employee keys))

(defvar *name-hash-tab* (make-hash-table :test #'equal))
(defvar *age-hash-tab* (make-hash-table :test #'equal))
(defvar *emp-dept-hash-tab* (make-hash-table :test #'equal))
(defvar *dname-hash-tab* (make-hash-table :test #'equal))

(defmethod new-instance ((self department)
			 &key 
			 name 
			 &allow-other-keys)
  (setf (gethash name *dname-hash-tab*) self))

(defvar *all_employees* nil)

(defmethod new-instance ((self employee)
			 &key 
			 name
			 age
			 dname
			 picture
			 floor-plan)
  (setf (gethash name *name-hash-tab*) self)
  (setf (gethash age *age-hash-tab*) self)
  (setf (gethash dname *emp-dept-hash-tab*) self)
  (push self *all_employees*)
  (setf (department self) (gethash dname *dname-hash-tab*))
  (setf (picture self) (make-image :file picture))
  (setf (floor-plan self) (make-image :file floor-plan))
  (attach (picture self))
  (attach (floor-plan self)))

(defvar *current-emp* (make-instance 'variable))

(defun initialize-links ()
  (init-one-linkset *name-hash-tab* 'prev_name 'next_name)
  (init-one-linkset *age-hash-tab* 'prev_age 'next_age)
  (init-one-linkset *emp-dept-hash-tab* 'prev_dept 'next_dept))

(defun init-one-linkset (table p-slot n-slot)
  (let ((ordered-list nil))
       (maphash #'(lambda (key value) (push (cons key value) ordered-list))
		table)
       (setq ordered-list 
	     (mapcar #'cdr (sort ordered-list #'string-lessp :key #'car)))
       (setf (slot-value (car ordered-list) p-slot) nil)
       (mapl #'(lambda (list) 
		       (setf (slot-value (car list) n-slot) (cadr list))
		       (if (cadr list)
			   (setf (slot-value (cadr list) p-slot) (car list))))
	     ordered-list)))

(defun get-emp (&key (name nil name-p)
		     (age nil age-p)
		     (department nil department-p)
		     (key nil key-p)
		     (dir nil dir-p))
  (cond (name-p (setf (value *current-emp*)
		      (or (gethash name *name-hash-tab*) 
			  (value *current-emp*))))
	(age-p  (setf (value *current-emp*)
		      (or (gethash age *age-hash-tab*) 
			  (value *current-emp*))))
	(department-p (setf (value *current-emp*)
			    (or (gethash department *emp-dept-hash-tab*)
				(value *current-emp*))))
	((eql key :name)
	 (if (eql dir :next)
	     (setf (value *current-emp*) (or (next_name (value *current-emp*))
					     (value *current-emp*)))
	     (setf (value *current-emp*)  (or (prev_name (value *current-emp*))
					      (value *current-emp*)))))
	((eql key :age)
	 (if (eql dir :next)
	     (setf (value *current-emp*)  (or (next_age (value *current-emp*))
					      (value *current-emp*)))
	     (setf (value *current-emp*)  (or (prev_age (value *current-emp*))
					      (value *current-emp*)))))
	((eql key :dept)
	 (if (eql dir :next)
	     (setf (value *current-emp*)  (or (next_dept (value *current-emp*))
					      (value *current-emp*)))
	     (setf (value *current-emp*)  (or (prev_dept (value *current-emp*))
					      (value *current-emp*)))))))


(defun open-database () 
  (initialize-links)
  (get-emp :age "25"))

(defun close-database () )

(defvar *employee-list*
  '(("Larry Rowe" "45" "Documentation" "larry.bitmap" "larry_floor.bitmap")
    ("Joe Konstan" "23" "Documentation" "joe.bitmap" "joe_floor.bitmap")
    ("Luis Miguel" "30" "Dissertation" "luis.bitmap" "luis_floor.bitmap")
    ("Steve Seitz" "20" "Production" "steve.bitmap" "steve_floor.bitmap")
    ("Yoda" "2003" "Jedi Master" "yoda.bitmap" "joe_floor.bitmap")
    ("Yongdong Wang" "27" "Dissertation" "yd.bitmap" "yd_floor.bitmap")
    ("Brian Smith" "25" "Production" "brian.bitmap" "brian_floor.bitmap")))

(defvar *department-list*
  '(("Documentation" "5" "Larry Rowe")
    ("Dissertation" "4" "Larry Rowe")
    ("Production" "4" "Larry Rowe")))

(mapc #'(lambda (dpt) (make-department :name (first dpt)
				      :dfloor (second dpt)
				      :manager (third dpt)
				      :floor-plan nil))
      *department-list*)

(mapc #'(lambda (emp) (make-employee :name (first emp)
				     :age (second emp)
				     :dname (third emp)
				     :picture (fourth emp)
				     :floor-plan (fifth emp)))
      *employee-list*)



