#-cling (in-package 'pt :use '(pcl lisp))
#+cling (in-package 'pt :use '(pcl lisp cling))

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass vertex ()
  ((id :initform 0 :type integer :accessor id)
   (x :initform 0 :type integer :accessor x)
   (y :initform 0 :type integer :accessor y)
   (tuple :initform nil :type list :accessor tuple)))

(defun vertex-p (x) (typep x 'vertex))

;;; =============================================================
;;;
;;; Convert a vertex tuple to a CLOS vertex object.
;;;
(defun make-vertex-from-tuple (tuple)
  ;; Tuples are of form (id x y)
  (let ((id (first tuple))
	(x (second tuple))
	(y (third tuple)))
       (add-sgg-vertex (copy-list tuple))
       (make-instance 'vertex :id id :x x :y y :tuple tuple)))

;;;
;;; Read all the vertex from the database -- faked, for now.
;;; Return a list of the objects read.
;;;
#-cling
(defun read-db-vertex (fac-id)
  (declare (ignore fac-id))
  (let* ((in-file (open "~picasso/lib/db/vertex" :direction :input))
	 (rv (mapcar #'make-vertex-from-tuple (read in-file nil nil t))))
	(close in-file)
	rv))

#+cling
(defun read-db-vertex (fac-id)
  "Read the vertex from the database for this facility and build the vertex objects."
  (declare (ignore fac-id))
  (db-mapl-retrieve #'make-vertex-from-tuple 
		    '((:integer vertex2.id)
		      (:float vertex2.x)
		      (:float vertex2.y))))

(defun save-db-vertex (vlist)
  (let ((tuple-list (mapcar #'tuple vlist))
	(out-file (open "~picasso/lib/db/vertex" :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))
