#-cling (in-package 'pt :use '(pcl lisp))
#+cling (in-package 'pt :use '(pcl lisp cling))

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass space (fac-object)
  ((id :initform 0 :type integer :accessor id)
   (clean-level :initform "" :type string :accessor clean-level)
   (tuple :initform nil :type list :accessor tuple)))

(defun space-p (x) (typep x 'space))

;;; =============================================================
;;;
;;; Convert a space tuple to a CLOS space object.
;;;
(defun make-space-from-tuple (tuple)
  ;; Tuples are of form (id name clean-level x1 y1 x2 y2 x3 y3 x4 y4)
  (let* ((id (first tuple))
	 (name (trim-str (second tuple)))
	 (clean-level (format nil "~a" (third tuple)))
	 (x1 (nth 3 tuple))
	 (y1 (nth 4 tuple))
	 (x2 (nth 5 tuple))
	 (y2 (nth 6 tuple))
	 (x3 (nth 7 tuple))
	 (y3 (nth 8 tuple))
	 (x4 (nth 9 tuple))
	 (y4 (nth 10 tuple))
	 (v1 (new-sgg-vertex x1 y1))
	 (v2 (new-sgg-vertex x2 y2))
	 (v3 (new-sgg-vertex x3 y3))
	 (v4 (new-sgg-vertex x4 y4))
	 (line1 (new-sgg-line v1 v2))
	 (line2 (new-sgg-line v2 v3))
	 (line3 (new-sgg-line v3 v4))
	 (line4 (new-sgg-line v4 v1))
	 rv)
	(setq rv (make-instance 'space :id id :tuple tuple
				:name name :clean-level clean-level))
	(new-sgg-object :id rv
			:line-ids `(,line1 ,line2 ,line3 ,line4)
			:annot-ids nil
			:symbol-ids nil
			:selectable t
			:visible t
			:color "white"
			:line-width 0)
	rv))

;;;
;;; Read all the space from the database -- faked, for now.
;;; Return a list of the objects read.
;;;
#-cling
(defun read-db-space (fac-id)
  "Read the space from the database for this facility and build the space objects."
  (let* ((in-file (open "~picasso/lib/db/space" :direction :input))
	 (rv (mapcar #'make-space-from-tuple (read in-file nil nil t))))
	(close in-file)
	;; Set the fac-id of each. We may also wish to set the color, etc.
	(dolist (obj rv) (setf (fac-id obj) fac-id))
	rv))

#+cling
(defun read-db-space (fac-id)
  "Read the space from the database for this facility and build the space objects."
  (let ((rv (db-mapl-retrieve
	     #'make-space-from-tuple
	     '((:integer space.id)
	       (:string space.name)
	       (:integer space.clean_level)))))
       ;; Set the fac-id.
       (dolist (obj rv) (setf (fac-id obj) fac-id))
       rv))

(defun save-db-space (sp-list)
  (let ((tuple-list (mapcar #'tuple sp-list))
	(out-file (open "~picasso/lib/db/space" :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))
