;;;
;;; PICASSO
;;;
;;; Copyright (c) 1989 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; Routines for gravity.
;;;
;;; $Author: bsmith $
;;; $Source: /b/users/bsmith/work/graphics/RCS/copyright.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 89/06/29 08:44:50 $
;;;

(in-package 'pt :use '(pcl lisp))

;;;
;;; Functions to save the database from FMTOOL
;;;

;;; =============================================================
;;;
;;; Save the database
;;;
(defun save-fmdb (equip-list eq-junct-list connect-list
		  util-list junct-list junct-kind-list space-list
		  vertex-list wall-list label-list lot-list lot-eq-list)
  "Save the database for the facility."
  (format t "Saving Equipment...~%")
  (save-db-equip equip-list)
  (format t "Saving Equipment-junctions...~%")
  (save-db-eq-junct eq-junct-list)
  (format t "Saving Utilities...~%")
  (save-db-util util-list)
  (format t "Saving Connection...~%")
  (save-db-connection connect-list)
  (format t "Saving Junctions...~%")
  (save-db-junct junct-list)
  (format t "Saving Junction-Kinds...~%")
  (save-db-junct-kind junct-kind-list)
  (format t "Saving Spaces...~%")
  (save-db-space space-list)
  (format t "Saving Vertex table...~%")
  (save-db-vertex vertex-list)
  (format t "Saving Walls...~%")
  (save-db-wall wall-list)
  (format t "Saving Labels...~%")
  (save-db-label label-list)
  (format t "Saving Lot Data...~%")
  (save-db-lot lot-list)
  (save-db-eq-run lot-eq-list))


