#-cling (in-package 'pt :use '(pcl lisp))
#+cling (in-package 'pt :use '(pcl lisp cling))

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass lot (fac-object)
  ((run-num :initform 0 :type integer :accessor run-num)
   (start-time :initform "" :type string :accessor start-time)
   (process-flow :initform "" :type string :accessor process-flow)
   (mask-set :initform "" :type string :accessor mask-set)
   (yield :initform 0.0 :type float :accessor yield)
   (status :initform :running :type keyword :accessor status)
   (tuple :initform nil :type list :accessor tuple)))

(defun lot-p (x) (typep x 'lot))

;;; =============================================================
;;;
;;; Convert a lot tuple to a CLOS lot object.
;;;
(defun make-lot-from-tuple (tuple)
  ;; Tuples are of form (run start process-flow mask-set status yield)
  (let ((run (first tuple))
	(start (trim-str (second tuple)))
	(pf (trim-str (third tuple)))
	(ms (trim-str (fourth tuple)))
	(stat (trim-str (fifth tuple)))
	(y (sixth tuple)))
       (if (string= stat "RUNNING")
	   (setq stat :running)
	   (setq stat :finished))
       (make-instance 'lot 
		      :run-num run
		      :tuple tuple
		      :start-time start
		      :process-flow pf
		      :mask-set ms
		      :status stat
		      :yield y)))

;;;
;;; Read all the lot from the database -- faked, for now.
;;; Return a list of the objects read.
;;;
#-cling
(defun read-db-lot (fac-id)
  (let* ((in-file (open "~picasso/lib/db/lot" :direction :input))
	 (rv (mapcar #'make-lot-from-tuple (read in-file nil nil t))))
	(close in-file)
	(dolist (obj rv) (setf (fac-id obj) fac-id))
	rv))

#+cling
(defun read-db-lot (fac-id)
  (let ((rv (db-mapl-retrieve #'make-lot-from-tuple 
			      '((:integer run_info.run_num)
				(:string run_info.start_time)
				(:string run_info.proc_flow)
				(:string run_info.mask_set)
				(:string run_info.status)
				(:float run_info.yield)))))
       (dolist (obj rv) (setf (fac-id obj) fac-id))
       rv))

(defun save-db-lot (lot-list)
  (let ((tuple-list (mapcar #'tuple lot-list))
	(out-file (open "~picasso/lib/db/lot" :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))

;;;
;;; Read the run-equip-map from the database -- faked, for now.
;;; Return a list of cons cells, car is run#, cdr is eq-id
;;;
#-cling
(defun read-db-eq-run (fac-id)
  (declare (ignore fac-id))
  (let* ((in-file (open "~picasso/lib/db/equip-run" :direction :input))
	 (rv (read in-file nil nil t)))
	(close in-file)
	rv))

#+cling
(defun read-db-eq-run (fac-id)
  (declare (ignore fac-id))
  (db-mapl-retrieve #'(lambda (x) (cons (first x) (second x))) 
		    '((:integer equip_run.run_num)
		      (:integer equip_run.equip_id))))

(defun save-db-eq-run (er-list)
  (let ((tuple-list er-list)
	(out-file (open "~picasso/lib/db/equip-run" :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))
