;;;
;;; PICASSO
;;;
;;; Copyright (c) 1989 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; Routines for gravity.
;;;
;;; $Author: bsmith $
;;; $Source: /b/users/bsmith/work/graphics/RCS/copyright.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 89/06/29 08:44:50 $
;;;

(in-package 'pt :use '(pcl lisp))

;;;
;;; Functions to load the database into FMTOOL
;;;

;;; =============================================================
;;;
;;; Load the database and makes parts-lists for all the various parts.
;;;
(defun load-fmdb (db-name fac-name equip-var eq-junct-var connect-var
			  util-var junct-var junct-kind-var space-var
			  vertex-var wall-var label-var lot-var lot-eq-var)
  "Load the database for the facility and construct the parts-lists."
  ;; Open the database...
  #+cling
  (db-open db-name)
  (let ((fac-id 1024))
       (format t "Reading Equipment...~%")
       (setf (value equip-var) (read-db-equip fac-id))
       (format t "Reading Equipment-junctions...~%")
       (setf (value eq-junct-var) (read-db-eq-junct fac-id))
       (format t "Reading Utilities...~%")
       (setf (value util-var) (read-db-util fac-id))
       (format t "Reading Connection...~%")
       (setf (value connect-var) (read-db-connection fac-id))
       (format t "Reading Junctions...~%")
       (setf (value junct-var) (read-db-junct fac-id))
       (format t "Reading Junction-Kinds...~%")
       (setf (value junct-kind-var) (read-db-junct-kind fac-id))
       (format t "Reading Spaces...~%")
       (setf (value space-var) (read-db-space fac-id))
       (format t "Reading Vertex table...~%")
       (setf (value vertex-var) (read-db-vertex fac-id))
       (format t "Reading Walls...~%")
       (setf (value wall-var) (read-db-wall fac-id))
       (format t "Reading Labels...~%")
       (setf (value label-var) (read-db-label fac-id))
       (format t "Reading Lot Data...~%")
       (setf (value lot-var) (read-db-lot fac-id))
       (setf (value lot-eq-var) (read-db-eq-run fac-id)))
  #+cling (db-close)
  )

(defun build-table (obj-list tab-var)
  "Build a hash table that maps from ids to objects."
  (let ((tab (value tab-var)))
       (if (null tab) (setq tab (make-hash-table)))
       (dolist (obj obj-list)
	       (setf (gethash (id obj) tab) obj))
       (setf (value tab-var) tab)))
