
(in-package 'pt)

(defun find-eq-space (equips spaces)
  "Return the equipment from equips within spaces."
  (let ((rv nil))
       (dolist (sp spaces)
	       (dolist (eq equips)
		       (if (inside-p eq sp) (pushnew eq rv))))
       rv))

(defun find-eq-junct (equips junct-list)
  "Return the equipment from equips with junct in junct-list."
  (let ((rv nil)
	(eid 0))
       (dolist (j junct-list)
	       (when (eq-junction-p j)
		     (setq eid (equip-id j))
		     (dolist (eq equips)
			     (if (eq (id eq) eid)
				 (pushnew eq rv)))))
       rv))

(defun find-eq-util (equips eq-juncts utils)
  "Return the equipment from equips connected to utils in util-list via
  junction in eq-juncts."
  (let ((junct-list nil)
	(uid 0))
       (dolist (ut utils)
	       (setq uid (id ut))
	       (dolist (ej eq-juncts)
		       (if (eq (util-id ej) uid)
			   (pushnew ej junct-list))))
       (find-eq-junct equips junct-list)))

(defun find-util-junct (utils junct-list)
  "Return the equipment from utils with a junct in junct-list."
  (let ((rv nil)
	(uid 0))
       (dolist (j junct-list)
	       (setq uid (util-id j))
	       (dolist (u utils)
		       (if (eq (id u) uid)
			   (pushnew u rv))))
       rv))

(defun find-eq-lot (equips lot-list eq-run-map)
  "Return the equipment from equips that works on a lot in lot-list"
  (let ((rv nil)
	(runs nil)
	(eids nil))
       (dolist (l lot-list)
	       (pushnew (run-num l) runs))
       (dolist (er eq-run-map)
	       (if (member (car er) runs)
		   (pushnew (cdr er) eids)))
       (dolist (e equips)
	       (if (member (id e) eids)
		   (pushnew e rv)))
       rv))

(defun find-util-equip (utils eq-junct-list equip-list)
  "Return the utilities from utils connected to a piece of equipment in
  equip-list via a junction in eq-junct-list."
  (let ((junct-list nil)
	(eid 0))
       (dolist (eq equip-list)
	       (setq eid (id eq))
	       (dolist (ej eq-junct-list)
		       (if (eq (equip-id ej) eid)
			   (pushnew ej junct-list))))
       (find-util-junct utils junct-list)))

(defun find-space-junct (spaces junct-list)
  "Return the spaces from spaces with a junct in junct-list."
  (let ((rv nil)
	(loc nil))
       (dolist (j junct-list)
	       (setq loc (location j))
	       (dolist (s spaces)
		       (if (and (not (member s rv))
				(pt-inside-p loc s))
			   (push s rv))))
       rv))

(defun find-space-equip (spaces equip-list)
  "Return the spaces from spaces containing a piece of equipment in equip-list."
  (let ((rv nil))
       (dolist (eq equip-list)
	       (dolist (sp spaces)
		       (if (and (not (member sp rv)) (inside-p eq sp))
			   (push sp rv))))
       rv))

(defun find-junct-equip (eq-juncts equip-list)
  (let ((rv nil)
	(eid 0))
       (dolist (j eq-juncts)
	       (setq eid (equip-id j))
	       (dolist (eq equip-list)
		       (if (eq (id eq) eid)
			   (pushnew j rv))))
       rv))

(defun find-junct-util (juncts util-list)
  (let ((rv nil)
	(uid 0))
       (dolist (j juncts)
	       (setq uid (util-id j))
	       (dolist (u util-list)
		       (if (eq (id u) uid)
			   (pushnew j rv))))
       rv))

(defun find-junct-space (juncts space-list)
  (let ((rv nil)
	(loc nil))
       (dolist (j juncts)
	       (setq loc (location j))
	       (dolist (sp space-list)
		       (if (and (not (member j rv)) (pt-inside-p loc sp))
			   (push j rv))))
       rv))

(defun find-lot-equip (lots equip-list eq-run-map)
  "Return the lots from lots processed by any equipment in equip-list"
  (let ((rv nil)
	(runs nil)
	(eids (mapcar #'id equip-list)))
       (dolist (er eq-run-map)
	       (if (member (cdr er) eids) 
		   (pushnew (car er) runs)))
       (dolist (l lots)
	       (if (member (run-num l) runs)
		   (pushnew l rv)))
       rv))
