(in-package 'pt :use '(pcl lisp))


(push :fac-objs *features*)

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass facility ()
  ((id :initform 0 :type integer :accessor id)
   (name :initform "" :type string :accessor name)
   (manager :initform "" :type string :accessor manager)
   (usage :initform "" :type string :accessor usage)
   (rating :initform "" :type string :accessor rating)))

(defclass fac-object ()
  ((name :initform "" :type string :accessor name)
   (fac-id :initform 0 :type integer :accessor fac-id)))

(defclass personnel (fac-object)
  ((id :initform 0 :type integer :accessor id)
   (age :initform 0 :type integer :accessor age)
   (phone :initform "" :type string :accessor phone)
   (space-id :initform 0 :type integer :accessor space-id)))

(defmacro xor (a b)
  "Return a xor b as a logical operation."
  `(if ,a (not ,b) ,b))

(defmacro trim-str (str)
  `(string-trim '(#\Space #\Tab #\Newline) ,str))
