;;;
;;; Copyright (c) 1982 Regents of the University of California
;;; Copyright (c) 1987 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 

(in-package 'cling :use '(ff))

;;;
;;; Load in the appropriate libq routines
;;;

(defvar *libq-loaded* nil)
  
(when (null *libq-loaded*)
  (load "/usr3/local/lib/cl/code/foreign.fasl")
  (remove-entry-point "__ubound")
  (remove-entry-point "__malloc_at_addr")
  (remove-entry-point "___mallinfo")
  (remove-entry-point "__root")
  (remove-entry-point "__lbound")
  (remove-entry-point "_pclose")
  (remove-entry-point "_realloc")
  (remove-entry-point "_valloc")
  (remove-entry-point "_calloc")
  (remove-entry-point "_malloc")
  (remove-entry-point "_memalign")
  (remove-entry-point "_free")
  ;; load the libq library via a slight hack
  (unless (null
	   (load ""
		 :foreign-files
		 '("libq.o"
		   "/usr5/rtingres/lib/libqlib"
		   "/usr5/rtingres/lib/compatlib")
		 ))
	  (setq *libq-loaded* t)))


;;;
;;; Set to t if you want strict argument checking
;;;

(defvar *libq-argument-check* t)

;;;
;;; system level database commands
;;;
(defun system-level-db-command (command dbname &optional flags)
  (excl:run-shell-command
   (concatenate 'simple-string 
		(string command) " " (string flags) " " (string dbname))))

;;;
;;; full path name
;;;
(defun full-path-name (name)
  (if (eql #\/ (char name 0))
      name
    (concatenate 'simple-string 
		 (pathname-directory (excl:current-directory))
		 "/" name)))
;;;
;;; Imported libq functions
;;;

;;; Special, since takes variables number of arguments
;;;
(defforeign 'ii-ingopen
  :entry-point "_myIIingres"
  :arg-checking *libq-argument-check*
  :arguments '(simple-string simple-string)
  :return-type :void)

(defforeign 'ii-errtest
  :entry-point "_IIerrtest"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :fixnum)

(defforeign 'ii-exit
  :entry-point "_IIexit"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :void)

(defforeign 'ii-writedb
  :entry-point "_IIwritedb"
  :arg-checking *libq-argument-check*
  :arguments '(simple-string)
  :return-type :void)

(defforeign 'ii-retinit
  :entry-point "_IIretinit"
  :arg-checking *libq-argument-check*
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-nextget
  :entry-point "_IInextget"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :fixnum)

(defforeign 'ii-retdom
  :entry-point "_IIretdom"
  :arg-checking *libq-argument-check*
  :arguments '(fixnum fixnum fixnum t)
  :return-type :fixnum)

;;; Special addition for getting around typing differences.
;;;
(defforeign 'ii-reti
  :entry-point "_myIIreti"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :integer)
(defforeign 'ii-retf
  :entry-point "_myIIretf"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :double-float)
(defforeign 'ii-rets
  :entry-point "_myIIrets"
  :arg-checking *libq-argument-check*
  :arguments '(simple-string)
  :return-type :integer)

(defforeign 'ii-flush
  :entry-point "_IIflush"
  :arg-checking *libq-argument-check*
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-syncup
  :entry-point "_IIsyncup"
  :arg-checking *libq-argument-check*
  :arguments '(fixnum fixnum)
  :return-type :void)

(defforeign 'ii-break
  :entry-point "_IIbreak"
  :arg-checking *libq-argument-check*
  :arguments nil
  :return-type :void)

(defforeign 'ii-eqinq
  :entry-point "_myIIeqinq"
  :arg-checking *libq-argument-check*
  :arguments '(simple-string)
  :return-type :integer)
