.LP
Persistent classes are treated exactly the same as conventional CLOS classes, 
called \fIlocal classes\fP, except that the class definition and 
selected instances are stored in the database.
Persistent classes are connected into the CLOS class hierarchy as shown
in figure \n(fn.
.(f
T
	OBJECT
		\fIlocal classes\fP
	DBOBJECT
		\fIpersistent classes\fP
.)f
A macro named \fIdefdbclass\fP is defined to create persistent classes
that takes the same arguments as the CLOS \fIdefclass\fP macro.
A template of the macro is:
.(c
(defdbclass \fIname\fP (\fIsuperclasses\fP)
  (\fIslot-definitions\fP)
  (\fIclass-attributes\fP))
.)c
\fISuperclasses\fP specifies a list of superclasses for this class.
The superclasses must all be persistent classes.
\fISlot-definitions\fP defines the object slots and \fIclass-attributes\fP
specifies attributes of the class (e.g., \fIgive-example\fP).
For example, the following definition creates a persistent box class:
.(c
(defdbclass box (dbobject)
  ((origin :type point :accessor origin)
   (width :type integer :accessor width)
   (height :type integer :accessor height)))
.)c
This macro defines the class and issues commands to the database to create
the class definition and the relation that will hold 
the instances of the class.
.LP
Instances of persistent classes are created by calling the CLOS 
\fImake-instance\fP method and passing it a persistent class.
The persistent object is stored in the database by calling the method
\fIstore-dbobject\fP.
Slots are accessed by calling \fIslot-value\fP or using the accessor functions
specified in the class definition.
A persistent object is loaded from the database by calling the method
\fIfetch-dbobject\fP.
This method creates the CLOS class object for the persistent class
if it is not defined and retrieves the specified object from the database
into an object cache in the tool.
.LP
Persistent objects are assigned a unique identifier, called an
\fIobject identifier\fP (OBJID) when it is created.
Objects can be fetched from the database by OBJID or by giving a
predicate on the slot values that uniquely specifies the desired object.
Slots in persistent objects can contain any valid \*(pi type including
a pointer to a local or persistent object.
Pointers to local objects are converted to \*(lfs that will recreate the
local object when the persistent object is reloaded.
Pointers to persistent objects are represented by OBJID's in the database.
They are represented by physical pointers when both objects are in the
object cache.
.LP
The following functions are provided to manipulate persistent objects.
.DG STORE-DBOBJECT
.LS
SELF
.LE
This generic function stores the object in the database.
The argument \fIself\fP can be an instance of a \fIdbobject\fP (i.e.,
a physical pointer to a persistent object) or the OBJID of a persistent
object in the cache.
.DG FETCH-DBOBJECT
.LS
SELF
\*(LO
NO-ERROR-P
.LE
This function fetches
a dbobject given an OBJID.
The argument can be a single OBJID or a list of OBJID's.
.DG FETCH-DBOBJECT
.LS
(SELF DBCLASS)
SLOT-NAME
SLOT-VALUE
\*(LO
NO-ERROR-P
.LE
This function fetches
a dbobject by slot value.
.DG MAKE-DBOBJECT-FROM-DATABASE
.LS
(SELF DBCLASS)
QUERY
\*(LO
NO-ERROR-P
.LE
This function takes an arbitrary query and fetches the specified objects
into the cache.
.DG SLOT-TYPE
.LS
(CLASS DBCLASS)
SLOT-NAME
.LE
This function returns the type of the specified slot.
.DG PPI
.LS
(SELF OBJID)
\*(LK
(STREAM *STANDARD-OUTPUT*)
(LEVEL NIL)
.LE
Pretty-print the specified object on the specified output stream.
.DF MAKE-INSTANCE
.LS
CLASS
\*(LR
INIT-PLIST
.LE
Make an instance of a persistent object.
This function calls the CLOS function \fImake-instance\fP to create the
local instance and assigns an OBJID.
