\"
\" LIBPQ - Common Lisp/POSTGRES Interface
\"
\" Copyright (c) 1986 Regents of the University of California
\" 
\" Permission to use, copy, modify, and distribute this software and its
\" documentation for any purpose and without fee is hereby granted,
\" provided that the above copyright notice appear in all copies and
\" that both that copyright notice and this permission notice appear in
\" supporting documentation, and that the name of the University of
\" California not be used in advertising or publicity pertaining to
\" distribution of the software without specific, written prior
\" permission.  The University of California makes no representations
\" about the suitability of this software for any purpose.  It is
\" provided "as is" without express or implied warranty.
\" 
\" $Author: ywang $
\" $Source: /b/objfads/doc/libpq/RCS/libpq.ms,v $
\" $Revision: 1.3 $
\" $Date: 88/02/26 16:38:21 $
\"
.nr PO 1i
.nr LL 6.5i
.ds LH "LIBPQ
.ds CH "- % -
.ds RH "Internal Release 
.ds LF "LIBPQ
.ds CF "\*(DY
.ds RF "Internal Release
.RP
.TL
LIBPQ - Common Lisp/POSTGRES Interface
.AU
Yongdong Wang
.AI
Computer Science Division
Department of Electrical Engineering and Computer Science
University of California
Berkeley, CA 94720
.AB
This document describes the Common Lisp/POSTGRES Interface (LIBPQ).  
LIBPQ is a package which allows the user to execute POSTGRES 
queries from Common Lisp.
.AE
.NH 1
Introduction to LIBPQ
.LP
LIBPQ is a Common Lisp Interface to POSTGRES, which allows the user to 
execute POSTGRES queries from Common Lisp.  
LIBPQ and the POSTGRES backend communicate through an IPC channel.
The variables and functions described in this document are in the 
package \fBlibpq\fP. 
The user should consult POSTGRES Reference Manual for commands to create
or destroy a database, and the syntax of POSTQUEL query commands.
.NH 1
Access POSTGRES
.LP
This section describes functions which handle the communication between
LIBPQ and the POSTGRES backend, and execute POSTQUEL queries.
.DF libpq:pqdatabase
.LS
.LE
Returns the name of the
current POSTGRES database accessed by LIBPQ, or NIL if no database is opened.  
Only one POSTGRES database can be accessed at a time.
The database name is a string.
The \fBsetf\fP function should be used to change this value.
.DF libpq:pqsetdb
.LS
dbname
.LE
The same as (setf (pqdatabase) \fBdbname\fP).
.DF libpq:pqreset
.LS
.LE
This function resets the communication between LIBPQ and the POSTGRES backend.
The communication between LIBPQ and the POSTGRES backend could be disconnected
when an error occurs.  
In this case this function should be called to reset the communication.
.DF libpq:pqfinish
.LS
.LE
This function terminates the communication between LIBPQ and the POSTGRES
backend.  
It also frees up the memory taken by the LIBPQ buffer.  
This function should be called when exiting LIBPQ.
.DF libpq:pqexec
.LS
query
\*(LO
no-error-p
.LE
This function sends \fBquery\fP to the POSTGRES backend for execution.
The argument \fBquery\fP is a POSTQUEL query command, the user should consult
the POSTGRES Reference Manual for the syntax of the query commands.
Some commonly used queries are illustrated
by examples in the last section of this document.
.LP
This function returns two values.
The first value is T or Nil, and the second value is a list.
If \fBquery\fP is executed successfully, the first value is T, and 
the second value is either ("C" query-command) or ("P" portal-name)
depending on if tuples are fetched.
When there is an error, the first value is Nil, and the second value is
("E" error-message).  However, if \fBno-error-p\fP is Nil, it signals an
error instead of returning Nil. 
.NH 1
Portal Functions
.LP
This section describes functions operating on POSTGRES \fBportals\fP.  
A portal is a POSTGRES buffer from which tuples can be fetched.
Each portal has a name which is a string no longer than 16.
The query command \fIretrieve portal foo (emp.all)\fP sets up a portal
named \fIfoo\fP with all the tuples in the relation \fIemp\fR.
The tuples in a portal do not necessarily have the same type.
Tuples in a portal can be fetched by \fIfetch\fP query commands such 
as \fIfetch all in foo\fP, or \fIfetch 10 in foo\fP.
Tuples fetched into LIBPQ from a portal are stored in a \fBportal-array\fP.
Portal names are mapped to portal arrays through an internal hash table.
Each tuple in a portal-array has an index which is an integer between 0
and \fIn - 1\fP, where \fIn\fP is the number of tuples in the portal-array.
Each tuple has one or more fields (attributes).
Each field has a name and a field number
which is an integer between 0 and \fIm - 1\fP, where \fIm\fP
is the number of fields in this tuple.
.LP
If no portal name is specified in a \fIretrieve\fP, the default portal
name is the empty string, and the portal is called a \fIblank portal\fP.  
All qualified tuples in a blank portal are fetched 
immediately without waiting for a fetch command.  
For example, the query \fIretrieve (emp.all)\fP will fetch all the tuples
in \fIemp\fP into a frontend \fIportal array\fP with portal name \fI""\fP.
.LP
A script in the last section of this document gives examples of these
queries and the functions to be described in this section.
.DF libpq:pqparray
.LS
portal-name
\*(LO
no-error-p
.LE
Returns the portal-array for \fBportal-name\fP.  
It signals an error if there is no portal-array corresponding 
to \fBportal-name\fP unless \fBno-error-p\fP is T.  In that case, 
it returns NIL.
.DF libpq:pqntuples
.LS
portal-array
\*(LO
no-error-p
.LE
Returns the number of tuples in \fBportal-array\fP.
It signals an error if \fBportal-array\fP is nil unless \fBno-error-p\fP
is T. In that case, it returns NIL.
.DF  libpq:pqnfields
.LS
portal-array
tuple-index
\*(LO
no-error-p
.LE
Returns the number of fields in the tuple \fBtuple-index\fP 
in \fBportal-array\fP.
If \fBportal-array\fP is nil, or \fBtuple-index\fP
is out of bound, i.e. not an integer between 0 
and (1- (pqntuples portal-array)), this function signals an error
unless \fBno-error-p\fP is T.  In that case, it returns NIL.
.DF libpq:pqfnumber
.LS
portal-array
tuple-index
field-name
\*(LO
no-error-p
.LE
Returns the field-number of \fBfield-name\fP in the tuple \fBtuple-index\fP
in \fBportal-array\fP.  
If \fBportal-array\fP is nil, or \fBtuple-index\fP
is out of bound, or \fBfield-name\fP does not
exist in the tuple, an error is signaled
unless \fBno-error-p\fP is T.  In that case, this function returns NIL.
.DF libpq:pqfname
.LS
portal-array
tuple-index
field-number
\*(LO
no-error-p
.LE
Returns the field-name of \fBfield-number\fP in the tuple \fBtuple-index\fP
in \fBportal-array\fP.
If \fBportal-array\fP is nil, or \fBtuple-index\fP
is out of bound, or \fBfield-number\fP is out of bound,
an error is signaled
unless \fBno-error-p\fP is T.  In that case, this function returns NIL.
.DF libpq:pqftype
.LS
portal-array
tuple-index
field-number
\*(LO
no-error-p
.LE
Returns the type of the field with \fBfield-number\fP in the 
tuple \fBtuple-index\fP in \fBportal-array\fP.
If \fBportal-array\fP is nil, or \fBtuple-index\fP is out of bound,
or \fBfield-number\fP is out of bound, an error is signaled 
unless \fBno-error-p\fP
is T.  In that case, this function returns NIL.
.DF libpq:pqsametype
.LS
portal-array
tuple-index1
tuple-index2
\*(LO
no-error-p
.LE
Returns T if the corresponding fields of the two 
tuples \fBtuple-index1\fP and \fBtuple-index2\fP
have the same types.  
It returns NIL if the two tuples have different types.
If \fBportal-array\fP is nil, or \fBtuple-index1\fP is out of bound,
or \fBtuple-index2\fP is out of bound, an error is signaled 
unless \fBno-error-p\fP
is T.  In that case, this function also returns NIL.
.DF libpq:pqgetvalue
.LS
portal-array
tuple-index
field-number
\*(LO
no-error-p
.LE
Returns the value of the field with \fBfield-number\fP in the
tuple \fBtuple-index\fP in \fBportal-array\fP.  
The value returned is always a string despite its type
(this will be changed in later release.)
If \fBportal-array\fP is nil, or \fBtuple-index\fP is out of bound,
or \fBfield-number\fP is out of bound, an error is signaled 
unless \fBno-error-p\fP
is T.  In that case, this function returns NIL.
.NH 1
Tracing 
.LP
This section describes functions which can be used to trace the execution
of a query command. 
The tracing messages printed out are the data passed between LIBPQ and
the POSTGRES backend.  
The user should consult the POSTGRES Communication Protocol
for interpretation of the tracing messages. 
.DV libpq::*pqtrace*
If the value is this variable is T, tracing messages will be printed out
on *standard-output* when executing a query command. This variable is
not exported form the package \fBlibpq\fP, therefore should not be accessed
except by calling the following two functions.
.DF libpq:pqtrace
.LS
.LE
This function rebinds libpq::*pqtrace* to T, therefore turns on the trace
flag.
.DF libpq:pquntrace
.LS
.LE
This function rebinds libpq::*pqtrace* to NIL, therefore turns off the
trace flag.
.NH 1
Hints and Future Changes
.NH 2
Hints
.IP (1)
The portal is not set up until the first fetch.  Therefore, 
(\fBpqparray\fP "foo") will signal an error if no fetch commands have
been executed on the portal \fIfoo\fP.
.IP (2)
There is now a limit on the length of the query, which is around 500 bytes.
Queries longer than that will be simply truncated, and ofter cause a parser
error.
.IP (3)
There is also a limit on the number of tuples which can be open at the same
time.  The limit is 3.  A portal \fIfoo\fP can be closed by 
the query \fI(pqexec "close foo")\fP.  If you have more than 3 portals open,
some weird error may occur.  
.IP (4)
The POSTGRES backend does not deal with the \fIHalloween problem\fP properly.
For example, if you have a tuple ("Yongdong" 10000 "Shoe") in your \fIemp\fP
relation, the following query \fIreplace emp (salary = 20000) 
where emp.name = "Yongdong"\fP will go on forever.  
Because after the \fIreplace\fP, there is still a tuple whose name 
is \fIYongdong\fP.  Therefore you have to make the tuple you intend to replace
unique.
The make this work, you need
to say \fIreplace emp (salary = 20000) where emp.name = "Yongdong" 
and emp.salary = 10000\fP, or \fIreplace emp (salary = 20000)
where emp.name = "Yongdong" and emp.salary != 20000\fP.
.IP (5)
You must have all your portals on a relation closed before you update that
relation.  Otherwise the update will not go into the database permanently.
.IP (6)
The communication between the frontend and the backend is not very stable. 
Sometimes a query just hangs there forever.  In this happens, 
you may be able to
kill the current query by \fIcntr-C\fP. 
If this does not work, you may have to kill the Lisp process. 
.NH 2
Future Changes
.LP
This limit on query length and number of open portals will be lifted
in the future.  The Halloween problem will be fixed.
Also, blank portals will made the
same as normal portals, and \fIfetch\fP and \fImove\fP will be allowed on
blank portals.
.NH 1
Examples
.LP
Suppose a database \fIywang\fP has already been created.
The following script shows how to
load the package \fBlibpq\fP, to create a relation, to append tuples to a 
relation, and to retrieve data from a relation.
.sp
.ID 10n
.nf
.ft CW
<cl> (load "/b/objfads/src/objfads/libpq/defsys.cl")
; Loading /b/objfads/src/objfads/libpq/defsys.cl.

T 
<cl> (libpq::load-libpq)
Loading PQEXEC...
; Fast loading /b/objfads/src/objfads/libpq/pqexec.fasl.
Loading PQCOMM...
; Fast loading /b/objfads/src/objfads/libpq/pqcomm.fasl.
; Foreign loading /b/objfads/src/objfads/libpq/libpq.o.
; Fast loading /usr/local/lib/cl/code/foreign.fasl.
Loading BLOCKS...
; Fast loading /b/objfads/src/objfads/libpq/blocks.fasl.
Loading PORTAL...
; Fast loading /b/objfads/src/objfads/libpq/portal.fasl.
Loading DUMPDATA...
; Fast loading /b/objfads/src/objfads/libpq/dumpdata.fasl.

NIL 
<cl> (use-package 'libpq)

T 
<cl> (pqdatabase)

NIL 
<cl> (pqsetdb "ywang")

"ywang" 
<cl> (pqexec "create emp (name = char16, salary = int4, dept = text)")

T 
("C" "CREATE") 
<cl> (pqexec "append emp (name = \\"Yongdong\\", salary = 10000, 
				dept = text[\\"shoe\\"])")

T 
("C" "append") 
<cl> (pqexec "retrieve portal eportal (emp.all) where emp.salary > 5000")

T 
("C" "retrieve") 
<cl> (pqexec "fetch all in eportal")

T 
("P" "eportal") 
<cl> (setq foo (pqparray "eportal"))

#(1 1 1 3 #("name" 19 16 "salary" 23 4 "dept" 25 65535 NIL ...) 
  #("Yongdong10000shoe" 0 8 "Yongdong10000shoe" 8 5 
    "Yongdong10000shoe" 13 4 NIL ...) NIL NIL NIL NIL ...) 
<cl> (setq n (pqntuples foo))

1 
<cl> (setq m (pqnfields foo 0))

3 
<cl> (dotimes (i m) (print (pqgetvalue foo 0 i)))

"Yongdong" 
"10000" 
"shoe" 
NIL 
<cl> (pqexec "replace emp (salary = 20000) where emp.dept = text[\\"shoe\\"] 
		and emp.salary != 20000")")

T 
("C" "replace") 
<cl> (pqexec "retrieve (emp.all)")

T 
("P" "") 
<cl> (let () (setq blankp (pqparray "")) nil)

NIL 
<cl> (pqfname blankp 0 0)

"name" 
<cl> (pqfname blankp 0 1)

"salary" 
<cl> (pqgetvalue blankp 0 1)

"20000" 
<cl> (pqexec "delete emp where emp.name = \\"Yongdong\\"")

T 
("C" "delete") 
<cl> (pqexec "destroy emp")

T 
("C" "DESTROY") 
<cl> (pqfinish)

T 
<cl> 
.ft R
.fi
.DE

