






            _C_L_I_N_G - _C_o_m_m_o_n _L_I_S_P/_I_N_G_R_E_S _I_n_t_e_r_f_a_c_e

                        Version 1.0

                _J_e_f_f _S_e_d_a_y_a_o _a_n_d _J_o_h_n _I_r_w_i_n

                 Computer Science Division
 Department of Electrical Engineering and Computer Science
                  University of California
                     Berkeley, CA 94720



_1.  _I_n_t_r_o_d_u_c_t_i_o_n

     CLING (Common LISP INGres interface) is a package  that
provides  an  interface  between  Common LISP and the INGRES
database system. Database commands can be executed from Com-
mon  LISP  programs.   Common LISP functions are defined for
every INGRES command.  CLING uses the QUEL  query  language.
A  later  version  of  CLING will support SQL.  In addition,
functions are provided  to  call  several  operating  system
level commands.

     This remainder of this document is  organized  as  fol-
lows: Section 2 shows an example that illustrates how to use
CLING.  Section 3 describes important list  structures  used
to  call  CLING  functions.   Section 4 describes the Common
LISP function calls that execute INGRES commands.  The  last
section  describes  how  to install the CLING package.  This
document assumes a knowledge of  INGRES,  QUEL,  and  Common
LISP.  This version of CLING works with INGRES version 5.0.

_1._1.  _A_b_o_u_t _t_h_e _F_o_r_m_a_t _f_o_r _D_e_f_i_n_i_t_i_o_n_s

     In this document, optional  items  are  placed  between
braces  ('[' and ']').  Optional items may be omitted from a
function call or list.  For example, the  specification  for
_d_b-_c_r_e_a_t_e_d_b function is

        (db-createdb database-name [:flags flags])

which specifies that :_f_l_a_g_s may be omitted when the function
is called.

     Ellipses (...) indicate that one or more items  may  be
used.   They  can be included with a braced expression, such
as in the specification for the format list

        (format-item1 [format-item2 ...])

     When one of many items must be chosen,  the  items  are
placed  within  brackets  ('{' and '}') and separated by the










Common LISP INGRES Interface-2-                  Version 1.0


'|' character. For example, the  specification  for  _d_b-_c_o_p_y
function is

        (db-copy  table-name  format-list  {:into  |  :from}
file-name)

which specifies that either :_i_n_t_o or :_f_r_o_m may  be  used  to
indicate  that  data  is to be copies into or from the data-
base.

_2.  _A_n _E_x_a_m_p_l_e _S_e_s_s_i_o_n _U_s_i_n_g _C_L_I_N_G

     This section shows an example of a CLING session.   The
example  demonstrates  how to load the CLING package, create
and open a database, create tables,  append  tuples  to  the
tables, and retrieve those tuples.  The Common LISP environ-
ment shown is based on Franz Allegro Common LISP.

     The first step to using CLING is to load it.


        <cl> (load "cling.cl")

        T


Doing this will load the entire package.  To use  the  pack-
age, the _u_s_e-_p_a_c_k_a_g_e function is executed:

        <cl> (use-package 'cling)

        T

     The next step will be to create and open a database.  A
private  database called "testdb" will be created.  The flag
"-p" (for private) ensures that access to  the  database  is
restricted.

        <cl> (db-createdb 'testdb :flags "-p")

        T

CLING may access any  INGRES  database  including  databases
created  by other users using other commands (e.g. the shell
command createdb).  Before the newly created database can be
accessed,  the  database  must  be opened, using the _d_b-_o_p_e_n
function:

        <cl> (db-open 'testdb)

        T

9

9







Common LISP INGRES Interface-3-                  Version 1.0


     Now that the database has been created and opened, some
tables  can  be  created.   Tables  are created with the _d_b-
_c_r_e_a_t_e command.

        <cl> (db-create 'paytable '((name c10) (pay f4) (job
c20)))

        NIL
        <cl> (db-create 'citytable '((name c10) (city c20)))

        NIL

The table "paytable" has a column called "name" is a 10 byte
character  string, a column called "pay" that is a four-byte
floating point number, and a column called "job" that  is  a
20   byte  character  string.   Table  "citytable"  has  two
columns.  Column "name"  has  10  characters,  while  column
"city" has 20.

     The two tables have been created, but they  are  empty.
_d_b-_a_p_p_e_n_d is used to add tuples to the tables.


        <cl> (db-append 'paytable
        '((= name "Jeff") (= pay 70) (= job "Research Assistant")))

        NIL


        <cl> (db-append 'paytable
        '((= name "Melvin") (= pay 3.50) (= job "Lawyer")))

        NIL


        <cl> (db-append 'paytable
        '((= name "Lois") (= pay 3.35) (= job "Professor")))

        NIL


        <cl> (db-append 'citytable '((= name "Jeff") (= city "Berkeley")))

        NIL


        <cl> (db-append 'citytable '((= name "Susan") (= city "Manila")))

        NIL



9

9







Common LISP INGRES Interface-4-                  Version 1.0


        <cl> (db-append 'citytable '((= name "Larry") (= city "Berkeley")))

        NIL


To display the tuples of a table, _d_b-_p_r_i_n_t may be used.


        <cl> (db-print 'citytable)

        citytable table

        |name      |city                |
        |-------------------------------|
        |Jeff      |Berkeley    |
        |Susan     |Manila      |
        |Larry     |Berkeley    |
        |-------------------------------|

        NIL


Note that _d_b-_p_r_i_n_t prints the table directly on  the  screen
rather than returning a value to your program.

     Tuples are retrieved  using  the  _d_b-_r_e_t_r_i_e_v_e  command.
Tuples  can  be  retrieved  into  a table or returned into a
list.  The following example returns a list of tuples:


        <cl> (db-retrieve '(paytable.name (:float paytable.pay))
        :where '(< paytable.pay (avg paytable.pay)))

        (("Larry     " 3.35d0) ("Melvin    " 3.5d0))


The "d0" in the numbers indicates that the number is  double
precision  with  exponent  0 (all floating point numbers are
stored as double precision).  The name and pay of all tuples
whose  pay  is  less  than  the  average  of  all  tuples is
returned.

     Tuple manipulation functions  are  provided  that  make
manipulating  tuples  easier.   In  the following example, a
sorted list of the weekly pay of all of the people in  payt-
able is returned.


        <cl> (db-mapl-retrieve #'(lambda (x) (* 40.0 (car x)))
        '((:float paytable.pay)) :sort '(pay))

        (134.0d0 140.0d0 2800.0d0)
9

9







Common LISP INGRES Interface-5-                  Version 1.0


Tuples are returned as lists, so that _c_a_r must  be  used  in
the map function.

     To close the database, the _d_b-_c_l_o_s_e function is used.


        <cl> (db-close)

        T


Other databases may now be opened.

_3.  _C_L_I_N_G _L_i_s_t _S_t_r_u_c_t_u_r_e_s

     CLING functions take a number of differently structured
lists  as  input.  This section details these lists, showing
their format, giving examples of their  usage,  and  listing
what  functions  use  them.   It  should  be noted the CLING
allows table and column names greater  than  12  characters,
but  will  truncate  them  before sending them to the INGRES
backend. This is done because the maximum length  of  INGRES
names is 12 characters.

_3._1.  _F_o_r_m_a_t _L_i_s_t_s

     A format list is used to specify the data format  of  a
table  or  a file.  In the CLING definitions, it is referred
to as a format-list.

_L_i_s_t _F_o_r_m_a_t:
        (format-item1 [format-item2 ...])

where   format-item is a format element (column-name format)
        column-name is the name of a column in a table, and
        format is an INGRES format specification, as  listed
below:

                format                  type

                 _c_1 - _c_2_5_5                 Character
                 _t_e_x_t(_1)-_t_e_x_t(_1_0_0_0)         Text
                 _i_1                         1-byte integer
                 _i_2                         2-byte integer
                 _i_4                         4-byte integer
                 _f_4                         4-byte floating
                 _f_8                         8-byte floating
                 _d_a_t_e                         date(12 bytes)
                 _m_o_n_e_y                         8-byte float-
ing

_E_x_a_m_p_l_e _U_s_a_g_e:
         ((name c10) (pay money) (job c20))










Common LISP INGRES Interface-6-                  Version 1.0


_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         (name=c10, pay=money, job=c20)

_C_L_I_N_G _F_u_n_c_t_i_o_n_s _U_s_i_n_g _t_h_i_s _L_i_s_t:
        db-copy
        db-create

_3._2.  _Q_u_a_l_i_f_i_c_a_t_i_o_n _L_i_s_t_s

     This list is  used  to  specify  a  qualification  that
selects  rows  from  a  table.  It is most often used as the
argument following the  position  argument  :where.  In  the
CLING definitions, it is referred to as qual-list.

_L_i_s_t _F_o_r_m_a_t:
        (boolean-expression)

where   boolean-expression is a boolean expression

_E_x_a_m_p_l_e _U_s_a_g_e:
         (AND (< paytable.pay 150) (= paytable.job "CEO"))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         paytable.pay < 150 and paytable.job = "CEO"

_C_L_I_N_G _F_u_n_c_t_i_o_n_s _U_s_i_n_g _t_h_i_s _L_i_s_t:
        db-append
        db-delete
        db-integrity
        db-permit
        db-replace
        db-retrieve
        db-view
        db-map-retrieve
        db-mapl-retrieve
        db-mapn-retrieve

_3._3.  _T_a_r_g_e_t _L_i_s_t_s

     The target list is used to specify tuples created by  a
query.   These tuples are either returned to the users (e.g.
_d_b-_r_e_t_r_i_e_v_e or update the database (e.g. _d_b-_a_p_p_e_n_d ).   When
a  target  list  is used in a retrieve command, values other
than strings must be preceded by a :_t_y_p_e specifier.  Because
of  this, target list elements of the type _t_a_b_l_e._a_l_l are not
allowed.  In the CLING definitions, a target list is  speci-
fied by target-list.

_L_i_s_t _F_o_r_m_a_t:
        (target-item1 [target-item2 ...])

where   target-item can be expr or ( :_t_y_p_e expr)
        expr can be










Common LISP INGRES Interface-7-                  Version 1.0


                table.column-name
                (arithmetic-op             table.column-name
[table.column-name])
                (= result-column-name expression)
                table.all
                aggregate
         :_t_y_p_e can be
                 :_s_t_r_i_n_g
                 :_f_l_o_a_t
                 :_i_n_t_e_g_e_r

_E_x_a_m_p_l_e _U_s_a_g_e:
         (paytable.name (:float (= weeklypay (* paytable.pay
40))))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         (paytable.name, weeklypay=paytable.pay*40)

_C_L_I_N_G _F_u_n_c_t_i_o_n_s _U_s_i_n_g _t_h_i_s _L_i_s_t:
        db-append
        db-replace
        db-retrieve
        db-map-retrieve
        db-mapl-retrieve
        db-mapn-retrieve

_3._4.  _S_o_r_t _L_i_s_t_s

     The sort list is used to  specify  the  sort  order  in
which  tuples  are  returned.   It  will be specified in the
definitions as sort-list.

_L_i_s_t _F_o_r_m_a_t:
        (sort-item1 [sort-item2 ...])

where   sort-item is column-name or (column-name order)
        column-name is the name of a column
        order is sort direction ( :_a for  ascending  and  :_d
for descending)

_E_x_a_m_p_l_e _U_s_a_g_e:
         (job (name :d))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         job,name:d

_C_L_I_N_G _F_u_n_c_t_i_o_n_s _U_s_i_n_g _t_h_i_s _L_i_s_t:
        db-modify
        db-retrieve
        db-map-retrieve
        db-mapl-retrieve
        db-mapn-retrieve
9

9







Common LISP INGRES Interface-8-                  Version 1.0


_3._5.  _A_g_g_r_e_g_a_t_e_s

     An aggregate is a function that computes a result  over
a  collections  of  data.   It  may be placed anywhere in an
expression where a constant can be used.  The following  are
valid aggregation operators:  count, countu, sum, sumu, avg,
avgu, max, min, any.

_L_i_s_t _F_o_r_m_a_t:
        (agg-op column-name
                [:by {column-name |  (column-name1  [column-
name2 ...])}]
                [:where qual-list])

where   qual-list is a qualification list
        agg-op is an aggregation operator

_E_x_a_m_p_l_e _U_s_a_g_e:
         (avg paytable.pay :where (= paytable.job  "Research
Assistant"))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
           avg(paytable.pay   where   paytable.job="Research
Assistant")

_4.  _C_L_I_N_G _F_u_n_c_t_i_o_n _R_e_f_e_r_e_n_c_e

     CLING has four groups  of  function  calls.  The  first
group  implements  Unix  operating  system level INGRES com-
mands. The second group consists of  CLING  specific  opera-
tions.   The  third  and largest group of function calls map
directly to QUEL commands.  The  fourth  group  of  function
calls  use the QUEL retrieve command to manipulate tuples in
ways useful to Common LISP.  All CLING  functions  are  pre-
fixed by"db-" to distinguish them from other LISP functions.

_4._1.  _S_y_s_t_e_m _L_e_v_e_l _C_a_l_l_s

     These three function calls correspond to operating sys-
tem level INGRES commands.

_4._1._1.  _c_l_i_n_g:_d_b-_c_r_e_a_t_e_d_b

     This function creates a database.  It  takes  the  same
flags  as  the  standard  INGRES command.  The flags must be
contained within a string.

_U_s_a_g_e:
         (db-createdb database-name [:flags flag-string])

_R_e_t_u_r_n_s:
         T - if successful
        NIL - if unsuccessful (database already exists)










Common LISP INGRES Interface-9-                  Version 1.0


_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         createdb

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-createdb 'testdb :flags "-p -usedayao")

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         createdb -p -usedayao testdb

_4._1._2.  _c_l_i_n_g:_d_b-_d_e_s_t_r_o_y_d_b

     This function destroys a database.  Attempting to  des-
troy  a  database  while  it is open (after _d_b-_o_p_e_n has been
executed and before _d_b-_c_l_o_s_e has been performed) will  fail.
Flags  are  the same as the standard INGRES command and must
be passed as a string.

_U_s_a_g_e:
         (db-destroydb database-name [:flags flag-string])

_R_e_t_u_r_n_s:
         T - if successful
        NIL - if unsuccessful (flags used improperly)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         destroydb

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-destroydb 'testdb :flags "-s")

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         destroydb -s testdb

_4._1._3.  _c_l_i_n_g:_d_b-_s_y_s_m_o_d

     This function optimizes the system catalogs of a  data-
base.   Flags are the same as in the standard INGRES command
and must be passed as a string.

_U_s_a_g_e:
         (db-sysmod database-name [:flags flag-string])

_R_e_t_u_r_n_s:
         T - if successful
        NIL - if unsuccessful

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         sysmod

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-sysmod 'testdb :flags "-w")

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:










Common LISP INGRES Interface-10-                 Version 1.0


         sysmod -w testdb

_4._2.  _C_L_I_N_G _C_a_l_l_s

     These two functions open and  close  a  database.   The
open  command creates the INGRES back-end process.  Only one
database may be open at one time.

_4._2._1.  _c_l_i_n_g:_d_b-_o_p_e_n

     This function opens a database.  It  must  be  executed
before  any commands are attempted, otherwise, an error will
be returned.  _d_b-_o_p_e_n is very sensitive  to  errors,  and  a
single  error  can  kill  the Common LISP process.  Only one
flag is permitted in the string.  If more than one  flag  is
specified  or if a flag is specified incorrectly, the Common
LISP process will die.

_U_s_a_g_e:
         (db-open database-name [:flags flag-string])

_R_e_t_u_r_n_s:
         T

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         ingres

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-open 'testdb :flags "-l")

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         ingres -l testdb (in operating system)

_4._2._2.  _c_l_i_n_g:_d_b-_c_l_o_s_e

     This function closes a database.  To uses another data-
base,  the  current  database  must  be closed and a new one
opened.

_U_s_a_g_e:
         (db-close)

_R_e_t_u_r_n_s:
         T

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         \quit (in terminal monitor)

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-close)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         \quit (in terminal monitor)










Common LISP INGRES Interface-11-                 Version 1.0


_4._3.  _Q_U_E_L _C_a_l_l_s

     These functions map to QUEL commands.  A database  must
be opened before any of these functions can be called.

_4._3._1.  _c_l_i_n_g:_d_b-_a_b_o_r_t

     This function undoes the effects of the current  multi-
statement transaction.

_U_s_a_g_e:
         (db-abort [:to savepoint])

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         abort

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-abort :to 'label)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         abort to label

_4._3._2.  _c_l_i_n_g:_d_b-_a_p_p_e_n_d

     This function appends rows to a table.

_U_s_a_g_e:
         (db-append table-name target-list [qual-list])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         append

_E_x_a_m_p_l_e _U_s_a_g_e:
          (db-append  'citytable  '(paytable.name   (=  city
"Chicago"))
                :where '(= paytable.job "Doctor"))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         append to citytable(paytable.name, city="Chicago")
                where paytable.job="Doctor"

_4._3._3.  _c_l_i_n_g:_d_b-_b_e_g_i_n-_x_a_c_t

     This function begins a multi-statement transaction.

_U_s_a_g_e:
         (db-begin-xact)

_R_e_t_u_r_n_s:
         NIL










Common LISP INGRES Interface-12-                 Version 1.0


_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         begin transaction

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-begin-xact)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         begin transaction

_4._3._4.  _c_l_i_n_g:_d_b-_c_o_p_y

     This function copies a table to or from a  file.   Note
that  the  filename must be a string.  CLING converts a file
name into its full path name for INGRES use if the  file  is
not specified with a full path name.

_U_s_a_g_e:
          (db-copy  table-name   format-list   {:into|:from}
file-name)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         copy

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-copy 'citytable '((name c10) (city c20))  :into
"cityfile")

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         copy citytable(name=c10,city=c20)
                into "/b/users/sedayao/CLING.cbw/cityfile"

_4._3._5.  _c_l_i_n_g:_d_b-_c_r_e_a_t_e

     This function creates a table.

_U_s_a_g_e:
         (db-create table-name format-list
                [:key journaling])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         create

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-create 'paytable '((name c10) (pay money)  (job
c20)))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:










Common LISP INGRES Interface-13-                 Version 1.0


         create paytable (name=c10, pay=money, job=c20)

_4._3._6.  _c_l_i_n_g:_d_b-_d_e_l_e_t_e

     This function deletes rows from a table.

_U_s_a_g_e:
         (db-delete table-name [:where qual-list])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         delete

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-delete 'paytable :where
                '(AND   (< paytable.pay 150) (= paytable.job
"CEO")))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
          delete  paytable  where  paytable.pay  <  150  and
paytable.job="CEO"

_4._3._7.  _c_l_i_n_g:_d_b-_d_e_s_t_r_o_y

     This function destroys tables.  Recall that CLING trun-
cates names to twelve characters.

_U_s_a_g_e:
         (db-destroy table-name1 [table-name2 ...])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         destroy

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-destroy 'paytable 'citytable 'personneltable)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         destroy paytable, citytable, personneltab

_4._3._8.  _c_l_i_n_g:_d_b-_d_e_s_t_r_o_y-_i_n_t_e_g_r_i_t_y

     This function destroys integrity constraints.  Integri-
ties are specified as integers.

_U_s_a_g_e:
          (db-destroy-integrity  table-name  {integrity1   |
(integrity1 ...) | ALL)})
9

9







Common LISP INGRES Interface-14-                 Version 1.0


_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         destroy integrity

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-destroy-integrity 'paytable 'all)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         destroy integrity paytable all

_4._3._9.  _c_l_i_n_g:_d_b-_d_e_s_t_r_o_y-_p_e_r_m_i_t

     This function destroys permits.  Permits are  specified
as integers.

_U_s_a_g_e:
         (db-destroy-permit table-name {permit1  |  (permit1
...) | ALL})

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         destroy permit

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-destroy-permit 'paytable '(2 3))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         destroy permit paytable 2,3


_4._3._1_0.  _c_l_i_n_g:_d_b-_e_n_d-_x_a_c_t

     This function terminates a multi-statement  transaction
and commits the updates to the database.

_U_s_a_g_e:
         (db-end-xact)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         end transaction

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-end-xact)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         end transaction










Common LISP INGRES Interface-15-                 Version 1.0


_4._3._1_1.  _c_l_i_n_g:_d_b-_h_e_l_p

     This function gives out information about tables in the
database.   Information  on  permits, integrity constraints,
and views can also be obtained with this  function.   Output
is  display  on the screen and cannot be recovered by Common
LISP.

_U_s_a_g_e:
         (db-help [{:permit | :integrity  |  :view}]  table-
name1 [table-name2 ...])
        (db-help {all | table-name1 ...})

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         help

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-help :permit 'citytable)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         help permit citytable

_4._3._1_2.  _c_l_i_n_g:_d_b-_i_n_d_e_x

     This function creates a secondary index on an  existing
table.   If index-name is a two element list, then the first
element is taken to be a database catalog, and the second is
the index name.

_U_s_a_g_e:
          (db-index  table-name   index-name   (column-name1
[column-name2 ...]))
where
        index-name can be a name or a list of form (location
index-name)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         index

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-index 'paytable 'index1 '(name job))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         index on paytable is index1(name job)


9

9







Common LISP INGRES Interface-16-                 Version 1.0


_4._3._1_3.  _c_l_i_n_g:_d_b-_i_n_t_e_g_r_i_t_y

     This  function  defines  integrity  constraints.    The
qual-list  must be a single table, aggregate free qualifica-
tion.

_U_s_a_g_e:
         (db-integrity table-name qual-list)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         define integrity

_E_x_a_m_p_l_e _U_s_a_g_e:
              (db-integrity       'personneltable       '(>=
personneltable.children 0))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
             define     integrity     personneltab     where
personneltab.pay >= 0

_4._3._1_4.  _c_l_i_n_g:_d_b-_m_o_d_i_f_y

     This function converts the storage structure of a table
or  index.   Various  other  storage  parameters may also be
specified.

_U_s_a_g_e:
         (db-modify table structure
                [:on sort-list]
                [:unique unique]
                [:fillfactor fill-factor]
                [:minpages minpages]
                [:maxpages maxpages]
                [:indexfill indexfill]
                [:maxindexfill maxindexfill])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         modify

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-modify 'citytable 'isam :on '(name)
                :on '(name)
                :unique 'yes
                :fillfactor 80)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         modify citytable  to  isam  unique  on  name  where










Common LISP INGRES Interface-17-                 Version 1.0


fillfactor=80

_4._3._1_5.  _c_l_i_n_g:_d_b-_p_e_r_m_i_t

     This function adds permissions to a table.  Times  must
be specified as strings.

_U_s_a_g_e:
         (db-permit (Quel-op1 [Quel-op2 ...]) table user
                [:cols column-name1 [column-name2 ...]]
                [:at term]
                [:from (time1 time2)]
                [:on (day1 day2)]
                [:where qual-list])

where   Quel-op is a quel operation

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         define permit

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-permit '(retrieve replace) 'paytable 'larry
                :cols '(name pay)
                :at "ttyv0"
                :from '("8:00" "17:00")
                :on '(Mon Fri)
                :where  '(=  paytable.job  "Research  Assis-
tant"))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         define permit  retrieve,  replace on  paytable(name
pay) to larry
                at "ttyv0" from 8:00 to 17:00 on Mon to Fri
                where paytable.job="Research Assistant"

_4._3._1_6.  _c_l_i_n_g:_d_b-_p_r_i_n_t

     This function prints out tables.

_U_s_a_g_e:
         (db-print table1 [table2 ...])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         print

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-print 'paytable 'citytable)










Common LISP INGRES Interface-18-                 Version 1.0


_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         print paytable, citytable

_4._3._1_7.  _c_l_i_n_g:_d_b-_r_a_n_g_e

     This function declares a range  variable  that  can  be
used in other commands to reference a table.

_U_s_a_g_e:
         (db-range range-variable table)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         range

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-range 'cityvar 'citytable)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         range of cityvar is citytable

_4._3._1_8.  _c_l_i_n_g:_d_b-_r_e_l_o_c_a_t_e

     This function relocates a table to a new storage area.

_U_s_a_g_e:
         (db-relocate table-name location)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         relocate

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-relocate 'citytable 'othersite)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         relocate citytable to othersite

_4._3._1_9.  _c_l_i_n_g:_d_b-_r_e_p_l_a_c_e

     This function replaces values of columns in a table.

_U_s_a_g_e:
         (db-replace table-name target-list [:where qual])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:










Common LISP INGRES Interface-19-                 Version 1.0


         replace

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-replace 'citytable '((= city "New Delhi"))
                :where '(= citytable.name "Suresh"))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
           replace   citytable(city="New    Delhi")    where
(citytable.name="Suresh")

_4._3._2_0.  _c_l_i_n_g:_d_b-_r_e_t_r_i_e_v_e

     This function retrieves rows from a table.  If :into is
specified,  a  new  table  is  produced  that  contains  the
retrieved  tuples.   Otherwise,  a   list   containing   the
retrieved  tuples  is  returned.   When  :_i_n_t_o  and  :_u_n_i_q_u_e
options are used together, the :_s_o_r_t  option  must  also  be
used.  Target list elements of the form _t_a_b_l_e._a_l_l may not be
used.

_U_s_a_g_e:
         (db-retrieve target-list [:where qual-list]
                [:sort sort-list]
                [:into location]
                [:unique unique])

_R_e_t_u_r_n_s:
         NIL if :into is specified.
        List of tuples if :into is not specified.

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         retrieve

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-retrieve '(paytable.name (:float  paytable.pay)
paytable.job)
                :into 'wealthytable
                :where '(> paytable.pay 50)
                :sort '(job (name :d)))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         retrieve into wealthytable
                (paytable.name paytable.pay paytable.job)
                where (paytable.pay > 50)
                sort job,name:d

_4._3._2_1.  _c_l_i_n_g:_d_b-_s_a_v_e

     This function saves a table until a specified date.

_U_s_a_g_e:
         (db-save table-name month day year)
9

9







Common LISP INGRES Interface-20-                 Version 1.0


_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         save

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-save 'citytable 8 28 1988)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         save citytable 8 28 1988

_4._3._2_2.  _c_l_i_n_g:_d_b-_s_a_v_e_p_o_i_n_t

     This function declares a savepoint marker within a mul-
tistatement transaction.

_U_s_a_g_e:
         (db-savepoint savepoint-name)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         savepoint

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-savepoint 'label)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         savepoint label

_4._3._2_3.  _c_l_i_n_g:_d_b-_v_i_e_w

     This function defines a view.

_U_s_a_g_e:
         (db-view view-name target-list [:where qual-list])

_R_e_t_u_r_n_s:
         NIL

_E_x_a_m_p_l_e _U_s_a_g_e:
          (db-view  'citypay  '(paytable.name   paytable.pay
citytable.city)
        :where '(= paytable.name citytable.name))

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         define  view  citypay  (paytable.name  paytable.pay
citytable.city)
   where (paytable.name=citytable)

9

9







Common LISP INGRES Interface-21-                 Version 1.0


_4._4.  _T_u_p_l_e _M_a_n_i_p_u_l_a_t_i_o_n _F_u_n_c_t_i_o_n_s

     These three functions are designed to make manipulating
tuples  easier.   They are variations of map, mapl, and mapn
functions in Common LISP  that  can  be  used  on  retrieved
tuples.   No INGRES equivalents are given, because QUEL does
not provide these functions.

_4._4._1.  _c_l_i_n_g:_d_b-_m_a_p-_r_e_t_r_i_e_v_e

     This function retrieves a list of  tuples  and  applies
the  specified  function  to  each  element of the list.  No
results are returned.  To halt the function, the  map  func-
tion should return NIL.

_U_s_a_g_e:
          (db-map-retrieve  function   target-list   [:where
qual-list] [:sort sort-list] [:unique])

_R_e_t_u_r_n_s:
         NIL

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-map-retrieve #'(lambda (x) (print (first x)))
                '(paytable.name    (:float     paytable.pay)
paytable.job)
                :sort '(name))

_4._4._2.  _c_l_i_n_g:_d_b-_m_a_p_l-_r_e_t_r_i_e_v_e

     This function retrieves a list of  tuples  and  applies
the  specified  function  to  each element of the list.  The
results are collected to a list and returned.

_U_s_a_g_e:
          (db-mapl-retrieve  function  target-list   [:where
qual-list] [:sort sort-list] [:unique])

_R_e_t_u_r_n_s:
         A list of the results of the function applied
        to each retrieved tuple.

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-mapl-retrieve #'(lambda (x) (if (>  (second  x)
0) (cons (first x) NIL)))
                '(personnelvar.name                (:integer
personnelvar.children))))

_4._4._3.  _c_l_i_n_g:_d_b-_m_a_p_n-_r_e_t_r_i_e_v_e

     This function retrieves a list of  tuples  and  applies
the  given  function  to  each  of  element of the list. The
results are collected to a list.  The return list is created










Common LISP INGRES Interface-22-                 Version 1.0


with _n_c_o_n_c rather than with _c_o_n_s.

_U_s_a_g_e:
          (db-mapn-retrieve  function  target-list   [:where
qual-list] [:sort sort-list] [:unique])

_R_e_t_u_r_n_s:
         A list of the results of the  function  applied  to
each retrieved tuple,
        nconc'ed together.

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-mapn-retrieve #'(lambda (x) (if (>  (second  x)
0) (cons (first x) NIL)))
                '(personnelvar.name                (:integer
personnelvar.children))))

_4._5.  _S_e_t _F_u_n_c_t_i_o_n_s

     These functions change the properties and  settings  of
an INGRES session.  They map to the QUEL set function.

_4._5._1.  _c_l_i_n_g:_d_b-_s_e_t-_j_o_u_r_n_a_l_i_n_g

     This function turns on journaling.  When journaling  is
on,   all  tables  created  within  a  session  are  logged.
Selected tables can be logged by specifying them in the  db-
set-journaling  command.   Tables  also  can  be  explicited
logged using the journaling option of the db-create command.

_U_s_a_g_e:
         (db-set-journaling [:table table])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set journaling

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-journaling :table 'citytable)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set journaling on citytable

_4._5._2.  _c_l_i_n_g:_d_b-_s_e_t-_n_o_j_o_u_r_n_a_l_i_n_g

     This function turns off journaling.  This is  also  the
default state of logging.

_U_s_a_g_e:
         (db-set-nojournaling [:table table])
9

9







Common LISP INGRES Interface-23-                 Version 1.0


_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set nojournaling

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-nojournaling :table 'citytable)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set nojournaling

_4._5._3.  _c_l_i_n_g:_d_b-_s_e_t-_r_e_t-_i_n_t_o

_U_s_a_g_e:
         (db-set-ret-into storage-structure)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set result_structure

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-ret-into 'cheap)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set ret_into "cheap"

     This function sets  the  storage  structure  of  tables
specified  when  using the :into option of the retrieve com-
mand.

_4._5._4.  _c_l_i_n_g:_d_b-_s_e_t-_l_o_c_k_m_o_d_e

     This function sets the various parameters involved with
locking in an INGRES session.

_U_s_a_g_e:
         (db-set-lockmode [:on table-name]
                [:level level]
                [:readlock readlock]
                [:maxlock maxlock]
                [:timeout timeout])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set lockmode session

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-lockmode :on 'citytable










Common LISP INGRES Interface-24-                 Version 1.0


                :level 'session
                :readlock 'system
                :maxlocks 10
                :timeout 0)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
          set  lockmode  on  citytable  where level=session,
readlock=system, maxlocks=10,
                timeout=0

_4._5._5.  _c_l_i_n_g:_d_b-_s_e_t-_q_b_u_f_s_i_z_e

     This function sets the size of the buffer qbuf.

_U_s_a_g_e:
         (db-set-qbufsize qbufsize)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set qbufsize

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-qbufsize 25000)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set qbufsize 25000

_4._5._6.  _c_l_i_n_g:_d_b-_s_e_t-_q_u_e_r_y-_s_i_z_e

     This function sets the size of the input query buffer.

_U_s_a_g_e:
         (db-set-query-size query-size)

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set query_size

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-query-size 4500)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set query_size 4500

_4._5._7.  _c_l_i_n_g:_d_b-_s_e_t-_c_a_c_h_e-_l_o_c_a_l

     This function enables a user to specify either the size
of  the  local  cache used in query processing (size) or the
number of INGRES data or index pages used in a  single  read










Common LISP INGRES Interface-25-                 Version 1.0


operation (readahead).

_U_s_a_g_e:
         (db-set-cache-local [:size size] [:readahead reada-
head])

_R_e_t_u_r_n_s:
         NIL

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t:
         set cache local

_E_x_a_m_p_l_e _U_s_a_g_e:
         (db-set-cache-local :size 23 :readahead 4)

_I_N_G_R_E_S _E_q_u_i_v_a_l_e_n_t _T_o _E_x_a_m_p_l_e:
         set cache local where size=23, readahead=4


_5.  _I_m_p_l_e_m_e_n_t_a_t_i_o_n _a_n_d _I_n_s_t_a_l_l_a_t_i_o_n _N_o_t_e_s

     CLING is implemented by connecting Common  LISP  to  an
INGRES  backend.   CLING  functions  are mapped to QUEL com-
mands, which are passed to the INGRES libq routines that are
loaded  into  the Common LISP process.  Libq routines create
the INGRES backend and arrange the protocol between the  two
processes.

     The libq routines are loaded into Common LISP  calls  C
languages  programs a Foreign Function Interface (FFI).  The
FFI is an implementation dependent feature of a Common  LISP
that allows Common LISP to use to non-LISP programs.

     CLING is composed of the following files:

        main.cl         user visible CLING functions
        subs.cl         CLING utility routines
        macros.cl       CLING macros
        libq.c          The INGRES interface library
        low.cl          libq foreign function interface

     Low.cl contains implementation  dependent  code.   This
file  must  be modified when porting CLING to various Common
LISPs.  Low.cl files have been  written  for  Franz  Allegro
Common LISP and Sun Common LISP (LUCID).

     To set up CLING, compile libq.c as follows

        cc -c libq.c

and put the rtingres/bin directory in your path.

9

9







Common LISP INGRES Interface-26-                 Version 1.0


     To use CLING, make sure you  are  a  registered  INGRES
user.  When  in  Common LISP, load the file cling.cl as fol-
lows:

        (load "cling.cl")

_A_c_k_n_o_w_l_e_d_g_e_m_e_n_t_s

     This work is a continuation of the work started by  Jim
Larus for use with Franz Lisp and University INGRES.










































9

9



