(defun weekly-pay (&aux emp-name hourly-pay)
  ;; prompt the user
  (format t "Display weekly salary for whom?  ")
  ;; get the employee name from the terminal
  (setq emp-name (read-line))
  ;; retrieve hourly pay from paytable using db-select
  ;; the result is a list of tuples, presumably one in this case
  ;; (caar result) gets the value
  (setq hourly-pay
	(caar (db-select '(hourly-pay)
			 :from '(paytable)
			 :where `(= name ,emp-name))))
  ;; display weekly pay, assuming a 40-hour week
  (format t "Weekly pay for ~A is ~$~%" emp-name (* 40 hourly-pay)))


(defun update-salary (&aux emp-name response)
  ;; prompt the user
  (format t "Display weekly salary for whom?  ")
  ;; get the employee name from the terminal
  (setq emp-name (read-line))
  ;; declare a cursor to retrieve hourly pay from paytable using db-select
  (db-declare-cursor 'pay-cursor
		     '((hourly-pay)
		       :from '(paytable)
		       :where `(= name ,emp-name))
		     :direct-update '(hourly-pay))
  ;; display hourly pay, using db-fetch to get the value from paytable
  (format t "Hourly pay for ~A is ~$~%" emp-name (caar (db-fetch 'pay-cursor)))
  ;; prompt the user again
  (format t "New hourly salary for ~A? Enter \"none\" for no change:  "
	  emp-name)
  ;; read the response from the terminal
  (setq response (read))
  ;; if it's a number, update the salary to be that value
  (when (numberp response)
	(db-update '(hourly-pay) (list response)
		   :where '(current-of pay-cursor))))
