(defmethod label-init ((label t) self &aux atts sup)
  (setq atts (slot-value self 'label-attributes)
	sup (parent self))
  (unless (getf atts :foreground)
	  (setf (getf atts :foreground) "black"))
  (unless (getf atts :background)
	  (setf (getf atts :background) 
		(if (or (null (background sup))
			(tile-p (background sup)) 
			(image-p (get-image (background sup))))
		    "white"
		    (background sup))))
  (unless (getf atts :font)
	  (setf (getf atts :font) "8x13"))
  (setf (slot-value self 'label-x) 0
	(slot-value self 'label-y) 0)
  (setf (slot-value self 'intern-label-gc)
	(make-shared-gc (parent self) atts)))
