/****************************************************************************
 * This module is all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/

#include "configuration.h"

#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

void SmartPlacement(FvwmWindow *t, int width, int height, int *x, int *y)
{
  int temp_h,temp_w;
  int test_x = 0,test_y = 0;
  int loc_ok = False, tw,tx,ty,th;
  FvwmWindow *test_window;

  temp_h = height;
  temp_w = width;
      
  while(((test_y + temp_h) < (Scr.MyDisplayHeight))&&(!loc_ok))
    {
      test_x = 0;
      while(((test_x + temp_w) < (Scr.MyDisplayWidth))&&(!loc_ok))
	{
	  loc_ok = True;
	  test_window = Scr.FvwmRoot.next;
	  while((test_window != (FvwmWindow *)0)&&(loc_ok == True))
	    {	
	      if(test_window->Desk == Scr.CurrentDesk)
		{
		  if(Scr.flags & StubbornPlacement)
		    {
		      if((test_window->flags & ICONIFIED)&&
			 (!(test_window->flags & ICON_UNMAPPED))&&
			 (test_window->icon_w)&&
			 (test_window != t))
			{
			  tw=test_window->icon_p_width;
			  th=test_window->icon_p_height+
			    test_window->icon_w_height;
			  tx = test_window->icon_x_loc;
			  ty = test_window->icon_y_loc;
			  
			  if((tx<(test_x+width))&&((tx + tw) > test_x)&&
			     (ty<(test_y+height))&&((ty + th)>test_y))
			    {
			      loc_ok = False;
			      test_x = tx + tw;
			    }
			}
		    }

		  if(!(test_window->flags & ICONIFIED)&&(test_window != t))
		    {
		      tw=test_window->frame_width;
		      th=test_window->frame_height;
		      tx = test_window->frame_x;
		      ty = test_window->frame_y;
		      if((tx < (test_x+width))&&((tx + tw) > test_x)&&
			 (ty < (test_y+height))&&((ty + th)>test_y))
			{
			  loc_ok = False;
			  test_x = tx + tw;
			}
		    }
		}
	      test_window = test_window->next;
	    }
	  test_x +=10;
	}
      test_y +=10;
    }
  if(loc_ok == False)
    {
      *x = -1;
      *y = -1;
      return;
    }
  *x = test_x-10;
  *y = test_y-10;
}
