/*---------------------------------------------
                 S I M P A C K++
            Simulation Tool Package
        Copyright 1991, Paul A. Fishwick
---------------------------------------------*/

#include "../../queuing/queuing.h"
#include <iostream.h>

#define MAX_TIME 10000.0
#define SECONDS 0
#define MINUTES 1
#define HOURS 2
class Time {
 public:
   int seconds,minutes,hours;
   void print_time();
   Time();
};

main() { 
 Time T;
 int event;
 Token tick;
 Facility Clock(0,1);

 init_simpack(HEAP);
 event_list.schedule(SECONDS,0.0,tick);
 event_list.schedule(MINUTES,60.0,tick);
 event_list.schedule(HOURS,3600.0,tick);
 while (time()< MAX_TIME) {
   event_list.next_event(event,tick); 
    switch(event) {
     case SECONDS: T.print_time(); T.seconds = (T.seconds+1) % 60; 
                   event_list.schedule(SECONDS,1.0,tick); break;

     case MINUTES: T.minutes = (T.minutes+1) % 60;
                   event_list.schedule(MINUTES,60.0,tick); break;

     case HOURS:   T.hours = (T.hours+1) % 12;
                   event_list.schedule(HOURS,3600.0,tick); break;

    } /* end switch */
 } /* end while */
} /* end main() */

Time::Time()
{
  seconds=0;
  minutes=0;
  hours=0;
}

void Time::print_time()
{ 
  cout<<"Time: "<<hours<<":"<<minutes<<":"<<seconds<<"\n";
} /* end print_time() */

