/* sim.c -- simulation system code */

#include <stdio.h>
#include <stdlib.h>

#define DEF_SPACE
#include "sim.h"

void engine(void)
{
EVENT *event;

	for(;;){
		TRACE(engine);
		if (!(event = nextevent())) return;
		if (event->time > now) now = event->time;
		(*event->f)(event->entity);
		free(event);
		}
	}

EVENT *nextevent(void)
{
EVENT *top;
extern EVENT *sched;
extern systime_t now;

	TRACE(nextevent);
	if (top = sched) sched = sched->next;
	return top;
	}

ENTITY *create(systime_t time,double feature)
{
ENTITY *new;
extern id_t entity_id;

	TRACE(create);
	new = (ENTITY *)calloc(1,sizeof(ENTITY));
	new->id = entity_id++;
	new->time = time;
	new->feature[0] = feature;
	return new;
	}

void sdump(void)
{
EVENT *sp;
extern EVENT *sched;

	sp = sched;
	while (sp){
#ifdef DEBUG
		printf("\tevent=%x, time=%f, f=%s, next=%x, entity=%x\n",
			sp,sp->time,sp->fs,sp->next,sp->entity);
#else
		printf("\tevent=%x, time=%f, next=%x, entity=%x\n",
			sp,sp->time,sp->next,sp->entity);
#endif
		if (sp->entity)
			printf("\tevent->entity->id=%ld, time=%f, feature[0]=%d\n",
				sp->entity->id,sp->entity->time,sp->entity->feature[0]);
		printf("\n");
		sp = sp->next;
		}
	}

#ifdef DEBUG
void schedule(void (*f)(), char *fs, ENTITY *entity, systime_t time)
#else
void schedule(void (*f)(), ENTITY *entity, systime_t time)
#endif
{
EVENT *sp, *event, *temp, *prev;
extern EVENT *sched;

	TRACE(schedule);
	event = (EVENT *)calloc(1,sizeof(EVENT));
	event->time = time;
#ifdef DEBUG
	event->fs = fs;
#endif
	event->f = f;
	event->entity = entity;
	if (!sched){
		sched = event;
		SDUMP();
		return;
		}
	if (sched->time > time){
		temp = sched;
		sched = event;
		event->next = temp;
		SDUMP();
		return;
		}
	sp = sched;
	while (sp && time >= sp->time){
		prev = sp;
		sp = sp->next;
		}
	prev->next = event;
	event->next = sp;
	SDUMP();
	return;
	}

void qdump(QUEUE_STRUCT *q)
{
ENTITY * ep;

	printf("\t* qdump: max= %d, current = %d, min=%d *\n",
		q->max_len,q->cur_len,q->min_len);
	ep = q->top;
	while (ep){
		PR_ENTITY(ep);
		ep = ep->next;
		}
	printf("\t* end of dump *\n");
	}


ENTITY *topq(QUEUE_STRUCT *q)
{
	return q->top;
	}

void nq(q,entity)
	QUEUE_STRUCT * q;
	ENTITY * entity;
{
	entity->next = (ENTITY *)0;
	if (q->end){
		q->end->next = entity;
		q->end = entity;
		}
	else
		q->top = q->end = entity;
	q->count++;
	entity->qtime = now;
	q->cur_len++;
	if (q->max_len < q->cur_len) q->max_len = q->cur_len;
#ifdef DEBUG
	qdump(q);
#endif
	}

ENTITY *dq(QUEUE_STRUCT *q)
{
ENTITY * p;

	p = q->top;
	if (p) q->top = q->top->next;
	if (p == q->end) q->end = (ENTITY *)0;
	if (p){
		q->total_wait += now - p->qtime;
		q->cur_len--;
		if (q->min_len > q->cur_len) q->min_len = q->cur_len;
		}
#ifdef DEBUG
	qdump(q);
#endif
	return p;
	}
