/*
 * File: cm_cellproto.h
 *   By: Dave Hiebeler
 *       August 1989
 *
 * Cellsim, cellular automata simulator
 *
 * Definitions for the protocol between SunView tool and CMFE program.
 */

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/


#define QUIT		1
#define SEND_LT		2
#define SEND_IMAGE	3
#define RUN		4
#define DISPLAY		5
#define CHANGE_STUFF	6
#define SET_DISPLAYS	7
#define GET_LT		8
#define PROBE		9
#define USE_SOCK	10
#define DONT_USE_SOCK	11
#define SEND_CMAP	12
#define CHANGE_DELAY	13
#define RUN_FOREVER	14
#define STOP_RUN	15
#define RUN2		16
#define SET_DISP_INTERVAL	17
#define DONE		18
#define ERROR		19
#define LOAD_IMAGE	20
#define QUICK_RANDOM	21
#define GENERAL_RANDOM	22
#define CLEAR		23
#define GET_IMAGE	24
#define SET_CM_IMAGE_DIR	25
#define SET_CM_FCN_DIR		26
#define SET_CM_LT_DIR		27
#define LOAD_RULE		28
#define SET_ZOOM	29
#define SET_PAN		30
#define CHANGE_IMAGE_SIZE	31
#define GET_CM_IMAGE_DIR	32
#define GET_CM_FCN_DIR		33
#define GET_CM_LT_DIR		34

#define DEFAULT_CM_PORT CELLSIM_PORT

#define COMPRESSED	1
#define UNCOMPRESSED	2

