/*****
 *
 * File: cellnborhoods.h
 *
 * Cellsim, cellular automata simulator
 *
 * Includes, declarations, definitions, etc used by the various
 * neighborhood-specific files, such as cellmoore.c, etc.
 *
 */


/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/


/*****
 *
 * Includes
 *
 *****/

#include "cell.def"
#include "nborhood.h"



/*****
 *
 * External vars
 *
 *****/
extern State
    *ia, *ca,	/* image array & current array */
    *ta;	/* lookup table */
extern int
    *statecount,	/* used to count states in array */
    stime,		/* current simulator time */
    TMASK, TMASK2, BSQR, BBUF, SOCKET_INUSE, function;
extern short
    S, N, L, R, B, AMASK, BM1, ABASE, RCOUNT, TBM1, BPL1;
/* pointers to nhood-dependent routines */
extern int
    (*get_address)(), (*to_nhood)(), (*to_index)(), (*rotate)(),
    (*auto_step)(), (*auto_screen)(), (*learn)();



/*****
 *
 * Private vars
 *
 *****/
static char string[BUFLEN];
