/*
 * File: heat.l256r2.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       August 1989
 *
 * The "heat" rule in the linear neighborhood.  See the "heat.m256.c" file
 * for more information on the heat rule itself.
 *
 * This rule works pretty well starting from random initial configurations.
 *
 * Try this with parm1 = 100 and parm2 = 2
 *  Also, try slight variations on both parameters to see the effects
 * You also get interesting behavior with parm1 = 100 and parm2 = 113.
 */

#include "nborhood.h"

byte heat();

void
init_function()
{
    update_function = heat;
    parm1 = 100;
    parm2 = 2;
}


byte
heat(nbors)
lr2_nbors *nbors;
{
    int heat_avg;

    Get_lr2_nbors;
    heat_avg = (ll + l + c + r + rr)/5;
    return (c + (heat_avg - c) * parm1 / 100 + parm2) % 256;
}
