 /*
  * Khoros: $Id: run_warpimage.c,v 1.1 1991/05/10 15:59:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_warpimage.c,v 1.1 1991/05/10 15:59:17 khoros Exp $";
#endif

 /*
  * $Log: run_warpimage.c,v $
 * Revision 1.1  1991/05/10  15:59:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "warpimage.h"

/********************************************************
*
*  Routine Name:  run_WarpImage
*
*       Purpose:  drives the subform 'WarpImage'
*
*         Input:  form - pointer to the form tree 
*		  WarpImage_info  - information structure for 
*				    subform 'WarpImage'
*        Output:  action of the application program
*
*     Called By:  run_Master()
*
*   Automatically Generated By:  conductor -i warpimage.form -l 1 -b
*
********************************************************/


run_WarpImage(form, WarpImage_info)

xvf_form *form;
Master_WarpImage *WarpImage_info;
{
	char temp[MaxLength];

	/*
	 * VIEW action came from the 'Options' pane
	 */
	if (WarpImage_info->view) 
	{
	    if (view_toplevel == NULL)
	        view_toplevel = create_view_workspace("View TiePoints");
	    else XMapRaised(display, XtWindow(view_toplevel));
	}

	/*
	 * CLEAR action came from the 'Options' pane
	 */
	else if (WarpImage_info->clear) 
	{
	   if (tiepoints == NULL) return;

           (void) (void) sprintf(temp,
             "This action will delete all tiepoints!!");
           if(! xvf_warn_wait(temp,"run_Input_Output", "OK", "Cancel"))
              return;
	   else
	      delete_all_tiepoints();
	}

	/*
	 * CLEAR action came from the 'Options' pane
	 */
	else if (WarpImage_info->warp) 
	{
	   warp_src_image();
	}

	/*
	 * action came from the 'Options' pane
	 */
	else if (WarpImage_info->Options_selected)
	    run_Options(form, WarpImage_info->Options);

	/*
	 * action came from the 'Input' pane
	 */
	else if (WarpImage_info->Input_selected)
	    run_Input(form, WarpImage_info->Input, WarpImage_info->Options);

	/*
	 * action came from the 'Output' pane
	 */
	else if (WarpImage_info->Output_selected)
	    run_Output(form, WarpImage_info->Output);

}   /* end run_WarpImage */





/********************************************************
*
*  Routine Name:  run_Options
*
*       Purpose:  drives the pane 'Options'
*
*         Input:  form - pointer to the form tree 
*		  Options_info  - information structure for pane 'Options'
*        Output:  action of the application program
*
*     Called By:  run_WarpImage()
*
*   Automatically Generated By:  conductor -i warpimage.form -l 1 -b
*
********************************************************/


run_Options(form, Options_info)

xvf_form *form;
WarpImage_Options *Options_info;
{
	float mfactor;
	unsigned long mask;
	char temp[MaxLength];
	char *error1 = "Please select a destination tiepoint before attempting another operation";


	/*
	 * user clicked on pane action button 'rb_zoom'
	 */
	if (Options_info->rb_zoom)
	{
	      rubberbanding = true;
	      mask = ButtonPressMask;

	      /* remove old event handlers on source image for zooming 
		 w/ Point & Click, install event handlers for 
		 rubberbanding zoom */ 
    	      XtRemoveEventHandler(src_image->raster, mask, FALSE, pc_zoom, 
				   NULL);
              XtInsertEventHandler(src_image->raster, ButtonPressMask, FALSE, 
				rb_start, NULL, XtListHead);
              XtInsertEventHandler(src_image->raster, ButtonMotionMask, FALSE, 
				rb_move, NULL, XtListHead);
              XtInsertEventHandler(src_image->raster, ButtonReleaseMask, FALSE, 
				rb_end, NULL, XtListHead);

	      /* remove old event handlers on dest image for zooming 
		 w/ Point & Click, install event handlers for 
		 rubberbanding zoom */ 
	      if (tiepoint_mode == SourceAndDest)
	      {
	          XtRemoveEventHandler(dest_image->raster, mask, FALSE, pc_zoom, 
				       NULL);
                  XtInsertEventHandler(dest_image->raster, ButtonPressMask, 
				    FALSE, rb_start, NULL, XtListHead);
                  XtInsertEventHandler(dest_image->raster, ButtonMotionMask, 
				    FALSE, rb_move, NULL, XtListHead);
                  XtInsertEventHandler(dest_image->raster, ButtonReleaseMask, 
				    FALSE, rb_end, NULL, XtListHead);
	      }

	}

	/*
	 * user clicked on pane action button 'pc_zoom'
	 */
	else if (Options_info->pc_zoom)
	{
	      point_and_clicking = True;


	      /* remove old event handlers on source image for zooming 
		 w/ Rubberbanding, install event handlers for 
		 Point & Click zoom */ 
	      XtRemoveEventHandler(src_image->raster, ButtonPressMask, FALSE,
                                   rb_start, NULL);
	      XtRemoveEventHandler(src_image->raster, ButtonMotionMask, FALSE,
                                   rb_move, NULL);
	      XtRemoveEventHandler(src_image->raster, ButtonReleaseMask, FALSE,
                                   rb_end, NULL);
              XtInsertEventHandler(src_image->raster, ButtonPressMask, FALSE, 
				   pc_zoom, NULL, XtListHead);
	    
	      /* remove old event handlers on dest image for zooming
                 w/ Rubberbanding, install event handlers for
                 Point & Click zoom */

              if (tiepoint_mode == SourceAndDest)
              {
		  XtRemoveEventHandler(dest_image->raster, ButtonPressMask, 
					FALSE, rb_start, NULL);
	          XtRemoveEventHandler(dest_image->raster, ButtonMotionMask, 
					FALSE, rb_move, NULL);
	          XtRemoveEventHandler(dest_image->raster, ButtonReleaseMask, 
					FALSE, rb_end, NULL);
                  XtInsertEventHandler(dest_image->raster, ButtonPressMask, 
				    FALSE, pc_zoom, NULL, XtListHead);
	      }
	}

	/*
	 * user clicked on 'live' float selection 'src_zoom_factor'
	 */
	else if (Options_info->src_zoom_factor_selected)
	{
	      if (src_zoom->mode == RubberBand)
	      {
	         refresh_workspace(src_image->raster, 
				   src_image->ximage, src_zoom);

		 mfactor = src_zoom->zoomfactor / 
					Options_info->src_zoom_factor;
		 src_zoom->xoffset = (int) 
				((float) src_zoom->xoffset * mfactor);
		 src_zoom->yoffset = (int) 
				((float) src_zoom->yoffset * mfactor);

	         refresh_workspace(src_image->raster, 
				   src_image->ximage, src_zoom);
	      }

	      src_zoom->zoomfactor = Options_info->src_zoom_factor;
	      refresh_zoom(src_zoom);
		
	}

	/*
	 * user clicked on 'live' float selection 'dest_zoom_factor'
	 */
	else if (Options_info->dest_zoom_factor_selected)
	{
	      if (dest_zoom->mode == RubberBand)
	      {
	         refresh_workspace(dest_image->raster, 
				   dest_image->ximage, dest_zoom);

		 mfactor = dest_zoom->zoomfactor / 
					Options_info->dest_zoom_factor;
		 dest_zoom->xoffset = (int) 
				((float) dest_zoom->xoffset * mfactor);
		 dest_zoom->yoffset = (int) 
				((float) dest_zoom->yoffset * mfactor);

	         refresh_workspace(dest_image->raster, 
				   dest_image->ximage, dest_zoom);
	      }
	      dest_zoom->zoomfactor = Options_info->dest_zoom_factor;
	      refresh_zoom(dest_zoom);
	}

	/*
         * user clicked on 'live' toggle 'operation'
         */
	else if (Options_info->operation_selected)
	{
	    if ((tiepoint_started == True) && (tiepoint_mode == SourceAndDest))
            {
           	xvf_error_wait(error1, "run_Options", NULL);
		if (Options_info->operation_selected)
	    	{
		    sprintf(temp, "%d", 1);
		    xvf_change_input(form, Options_info->operation_index, 
				     xvf_toggleval_chng, temp, 0);
	        }
            }

	    if (Options_info->operation_val == AddTiePoint)
	    {
		 /* remove any old event handlers from source image and
		    source zoom - add in the delete tiepoint event handlers */
		 XtRemoveEventHandler(src_image->raster, ButtonPressMask, 
				      FALSE, delete_tiepoint, NULL);
		 XtRemoveEventHandler(src_zoom->raster, ButtonPressMask, 
				      FALSE, delete_tiepoint, NULL);
                 XtInsertEventHandler(src_image->raster, ButtonPressMask, FALSE,
				   add_src_tiepoint, NULL, XtListHead);
                 XtInsertEventHandler(src_zoom->raster, ButtonPressMask, FALSE, 
				   add_src_tiepoint, NULL, XtListHead);

		 /* remove any old event handlers from dest image and
		    dest zoom - add in the delete tiepoint event handlers */
		 if (tiepoint_mode == SourceAndDest)
		 {
		     XtRemoveEventHandler(dest_image->raster, ButtonPressMask, 
				          FALSE, delete_tiepoint, NULL);
		     XtRemoveEventHandler(dest_zoom->raster, ButtonPressMask, 
				          FALSE, delete_tiepoint, NULL);
                     XtInsertEventHandler(dest_image->raster, ButtonPressMask, 
				  FALSE, add_dest_tiepoint, NULL, XtListHead);
                     XtInsertEventHandler(dest_zoom->raster, ButtonPressMask, 
				  FALSE, add_dest_tiepoint, NULL, XtListHead);
		 }
	    }
	    else if (Options_info->operation_val == DeleteTiePoint)
	    {
		 /* remove any old event handlers from source image and
		    source zoom - add in the delete tiepoint event handlers */
		 XtRemoveEventHandler(src_image->raster, ButtonPressMask,
                                      FALSE, add_src_tiepoint, NULL);
		 XtRemoveEventHandler(src_zoom->raster, ButtonPressMask,
                                      FALSE, add_src_tiepoint, NULL);
		 XtInsertEventHandler(src_image->raster, ButtonPressMask, FALSE,
                                   delete_tiepoint, NULL, XtListHead);
		 XtInsertEventHandler(src_zoom->raster, ButtonPressMask, FALSE,
                                   delete_tiepoint, NULL, XtListHead);

		 /* remove any old event handlers from dest image and
		    dest zoom - add in the delete tiepoint event handlers */
		 if (tiepoint_mode == SourceAndDest)
		 {
                     XtRemoveEventHandler(dest_image->raster, ButtonPressMask,
                                          FALSE, add_dest_tiepoint, NULL);
                     XtRemoveEventHandler(dest_zoom->raster, ButtonPressMask,
                                          FALSE, add_dest_tiepoint, NULL);
                     XtInsertEventHandler(dest_image->raster, ButtonPressMask, 
				  FALSE, delete_tiepoint, NULL, XtListHead);
                     XtInsertEventHandler(dest_zoom->raster, ButtonPressMask, 
				  FALSE, delete_tiepoint, NULL, XtListHead);
		 }

	    }
	}
}

/********************************************************
*
*  Routine Name:  run_Input
*
*       Purpose:  drives the pane 'Input'
*
*         Input:  form - pointer to the form tree 
*		  Input_info  - information structure for pane 'Input'
*        Output:  action of the application program
*
*     Called By:  run_WarpImage()
*
*   Automatically Generated By:  conductor -i warpimage.form -l 1 -b
*
********************************************************/


run_Input(form, Input_info, Options_info)

xvf_form *form;
WarpImage_Input *Input_info;
WarpImage_Options *Options_info;
{

	/*
	 * user clicked on 'live' input file selection 'in_src_img'
	 */
	if (Input_info->in_src_img_selected)
	{
	    /*
	     *  check to be sure they've specified a filename
	     */
	    if (Input_info->in_src_img == NULL)
	    {
	        xvf_error_wait("Error! No filename specified for source image",
                               "run_Input", NULL);
		return;
	    }
	    input_src_image(Input_info->in_src_img, 
			    Options_info->src_zoom_factor);
	}

	/*
	 * user clicked on 'live' input file selection 'in_dest_img'
	 */
	else if (Input_info->in_dest_img_selected)
	{

	    /*
	     *  if the tiepoint mode is SourceOnly, user is not allowed
	     *  to enter a destination image.
	     */
	    if (tiepoint_mode == SourceOnly)
	    {
	        xvf_error_wait(
		           "Sorry, the Tiepoint Mode for this execution of Warpimage is SourceOnly;  you are not allowed to enter a destination image.  If you need a destination image, re-execute warpimage with [-tp_mode 1].",
                           "run_Input", NULL);
		return;
	    }

	    /*
	     *  check to be sure they've specified a filename
	     */
	    if (Input_info->in_dest_img == NULL)
	    {
	        xvf_error_wait(
		           "Error! No filename specified for destination image",
                           "run_Input", NULL);
		return;
	    }

	    input_target_image(Input_info->in_dest_img, 
			       Options_info->dest_zoom_factor);
	}

	/*
	 * user clicked on 'live' input source tiepoints selection 
	 */
	else if (Input_info->in_tp_selected)
	{

	    /*
	     *  check to be sure they've specified a filename
	     */

	    if (Input_info->in_tp == NULL)
	    {
	        xvf_error_wait(
		       "Error! No filename specified for tiepoint image",
                       "run_Input", NULL);
		return;
	    }

	    if (src_image->image == NULL)
	    {
	        xvf_error_wait(
	                      "Error! No Source image is displayed",
                              "run_Input", NULL);
		return;
	    }
	    if (tiepoint_mode == SourceAndDest)
	    {
	       if (dest_image->image == NULL)
	       {
	           xvf_error_wait(
	                      "Error! No Target image is displayed",
                              "run_Input", NULL);
		   return;
	       }
	    }
	    input_tp_image(Input_info->in_tp);
	}
}


/********************************************************
*
*  Routine Name:  run_Output
*
*       Purpose:  drives the pane 'Output'
*
*         Input:  form - pointer to the form tree 
*		  Output_info  - information structure for pane 'Output'
*        Output:  action of the application program
*
*     Called By:  run_WarpImage()
*
*   Automatically Generated By:  conductor -i warpimage.form -l 1 -b
*
********************************************************/


run_Output(form, Output_info)

xvf_form *form;
WarpImage_Output *Output_info;
{
	char temp[MaxLength];


	/*
	 * user clicked on 'live' output file selection 'out_src_tp_img'
	 */

	if (Output_info->out_tp_selected)
	{
	   if (Output_info->out_tp == NULL)
	   {
	        xvf_error_wait(
	           "Error! No filename specified for outputting the tiepoints",
                           "run_Output", NULL);
		return;
	   }

	   if (tiepoints == NULL)
	   {
	       bzero(temp, MaxLength);
               sprintf(temp, 
               "No tiepoints have been selected. Please select tiepoints before attempting to output the tiepoints");
	       xvf_error_wait(temp, "run_Output", NULL);
	       return;
	   }
	   
	   output_tiepoints(Output_info->out_tp);
	}

	/*
	 * user clicked on 'live' output file selection 'out_dest_tp_img'
	 */
	else if (Output_info->out_coeff_selected)
	{
	   if (Output_info->out_coeff == NULL)
	   {
	        xvf_error_wait(
                 "Error! No filename specified for outputting the coefficients",
                           "run_Output", NULL);
		return;
	   }

	   if (tiepoints == NULL)
	   {
	       bzero(temp, MaxLength);
               sprintf(temp, 
               "No tiepoints have been selected. Please select tiepoints before attempting to output the tiepoints");
	       xvf_error_wait(temp, "run_Output", NULL);
	       return;
	   }
	   output_coeffs(Output_info->out_coeff);

	}
}

/* -library_code_end */

