 /*
  * Khoros: $Id: reader.c,v 1.2 1991/10/02 00:11:31 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: reader.c,v 1.2 1991/10/02 00:11:31 khoros Exp $";
#endif

 /*
  * $Log: reader.c,v $
 * Revision 1.2  1991/10/02  00:11:31  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: reader.c
 >>>>
 >>>>      Program Name: reader
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	The  purpose   of   Ghostreader   is   to   update   Program
 >>>>	Specification  File  (*.prog  file) so that it is consistent
 >>>>	with the C source code  and  man  pages  of  an  application
 >>>>	program that was originally generated with ghostwriter.  The
 >>>>	SOURCE  of  information  for  ghostreader  is  from   marked
 >>>>	segments  of  the  *.c,  *.h,  l*.c, *.1, and *.3 files. The
 >>>>	DESTINATION of extracted information  is  the  *.prog  file,
 >>>>	where '*' is the name of the program in question.
 >>>>	
 >>>>	
 >>>>            Author: Danielle Argiro
 >>>>
 >>>> Date Last Updated: Tue Apr  2 15:50:04 1991
 >>>>
 >>>>          Routines: main- the main program for reader
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "reader.h"


/****************************************************************
 *
 * Routine Name:  main program for reader
 *
 *       Input:  
 *        -name  name of program to update *.prog file for 
 *
 *
 *        [-config] use configuration file?
 *        [-lib] use lib file?
 *        [-man3] use man3 file?
 *        [-install] install output?
 *        [-format] formatting (0 = none, 1 = nroff)  (0 < value < 1)
 *        [-prog] use old .prog file?
 *        [-force] force output?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
	int dummy;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();
	gw_get_args();

/* -main_before_lib_call */
	if (dummy != dummy) XtToolkitInitialize();
/* -main_before_lib_call_end */

/* -main_library_call */
if (!(lreader()))
        {
           fprintf(stderr, "\nghostreader:\n");
           fprintf(stderr, "A New .prog File Has NOT Been Generated\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for reader 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "reader :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThe  purpose   of   Ghostreader   is   to   update   Program\n");
	fprintf(stderr, "\tSpecification  File  (*.prog  file) so that it is consistent\n");
	fprintf(stderr, "\twith the C source code  and  man  pages  of  an  application\n");
	fprintf(stderr, "\tprogram that was originally generated with ghostwriter.  The\n");
	fprintf(stderr, "\tSOURCE  of  information  for  ghostreader  is  from   marked\n");
	fprintf(stderr, "\tsegments  of  the  *.c,  *.h,  l*.c, *.1, and *.3 files. The\n");
	fprintf(stderr, "\tDESTINATION of extracted information  is  the  *.prog  file,\n");
	fprintf(stderr, "\twhere '*' is the name of the program in question.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-name  name of program to update *.prog file for  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-config]  use configuration file? (boolean) [false]\n");
	fprintf(stderr,"\t[-lib]  use lib file? (boolean) [true]\n");
	fprintf(stderr,"\t[-man3]  use man3 file? (boolean) [true]\n");
	fprintf(stderr,"\t[-install]  install output? (boolean) [false]\n");
	fprintf(stderr,"\t[-format]  formatting (0 = none, 1 = nroff) (integer, 0 to 1) [1]\n");
	fprintf(stderr,"\t[-prog]  use old .prog file? (boolean) [true]\n");
	fprintf(stderr,"\t[-force]  force output? (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for reader\n");
	fprintf(stderr, "\t[-U] Gives the usage for reader\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called reader.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses reader.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for reader
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*name_pstr = 
	"\nEnter: (name) name of program to update *.prog file for \n        {string}: "; 
char	*name_def = NULL;
char	*config_pstr = 
	"\nEnter: (config) use configuration file? \n        {boolean, (y/n)  [no] }: "; 
char	*lib_pstr = 
	"\nEnter: (lib) use lib file? \n        {boolean, (y/n)  [yes] }: "; 
char	*man3_pstr = 
	"\nEnter: (man3) use man3 file? \n        {boolean, (y/n)  [yes] }: "; 
char	*install_pstr = 
	"\nEnter: (install) install output? \n        {boolean, (y/n)  [no] }: "; 
char	*format_pstr = 
	"\nEnter: (format) formatting (0 = none, 1 = nroff) \n        {integer, 0 to 1 [1] }: "; 
char	*prog_pstr = 
	"\nEnter: (prog) use old .prog file? \n        {boolean, (y/n)  [yes] }: "; 
char	*force_pstr = 
	"\nEnter: (force) force output? \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "reader", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "reader.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "reader: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "reader.ans");
		}

	     }

	}

	/*
	 * allocate the reader structure
	 */
	reader = (reader_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (reader_struct));

	/*
	 * get required arguments for reader
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(reader->name_flag = vget_string(fid, prompt_flag,
			"-name", name_pstr, &(reader->name),
			name_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(reader->name_flag))
		{
		    fprintf(stderr, "\t\tname is required, please re-enter: \n");
		    reader->name_flag = vget_string(fid, prompt_flag,
		    "-name", name_pstr, &(reader->name),
		    name_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-name' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for reader
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	reader->config_flag = vget_logic(fid, prompt_flag,
	"-config", config_pstr, &(reader->config), 0);

	reader->lib_flag = vget_logic(fid, prompt_flag,
	"-lib", lib_pstr, &(reader->lib), 1);

	reader->man3_flag = vget_logic(fid, prompt_flag,
	"-man3", man3_pstr, &(reader->man3), 1);

	reader->install_flag = vget_logic(fid, prompt_flag,
	"-install", install_pstr, &(reader->install), 0);

	reader->format_flag = vget_int(fid, prompt_flag,
	"-format", format_pstr, &(reader->format),
	1, 0, 1);

	reader->prog_flag = vget_logic(fid, prompt_flag,
	"-prog", prog_pstr, &(reader->prog), 1);

	reader->force_flag = vget_logic(fid, prompt_flag,
	"-force", force_pstr, &(reader->force), 0);


}



