 /*
  * Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:38:42 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:38:42 dkhoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.3  1992/03/20  22:38:42  dkhoros
 * VirtualPatch5
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Fri Mar 13 14:22:56 1992
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_edit
*
*       Purpose: Fills in the user-specified
*                'edit'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'edit'
*
*       Output:  current values stored in  edit
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_edit(formptr, forminfo)

xvf_form *formptr;
edit *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'edit' Form Information structure *****/


	index = 2;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->image_workspace = line_info.workspace;

	index = 10;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->change_bands = line_info.selected;

	index = 11;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->overlay_image = line_info.selected;

	index = 12;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->combine_overlays = line_info.selected;

	index = 23;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->info = line_info.selected;

	index = 24;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->combine_annotations = line_info.selected;

	index = 30;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 32;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->zoom_subform_selected = line_info.selected;

	index = 42;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->pixels_subform_selected = line_info.selected;

	index = 60;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->lut_subform_selected = line_info.selected;

	index = 79;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->pseudo_subform_selected = line_info.selected;

	index = 96;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->thres_subform_selected = line_info.selected;

	index = 111;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->files_subform_selected = line_info.selected;

	index = 134;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->roi_subform_selected = line_info.selected;

	index = 154;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->colormap_subform_selected = line_info.selected;

	index = 179;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->xvoverlay_selected = line_info.selected;

	index = 266;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->comment_subform_selected = line_info.selected;

}

/********************************************************
*
*  Routine Name: xvf_get_zoom_subform
*
*       Purpose: Fills in the user-specified
*                'edit_zoom_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_zoom_subform'
*
*       Output:  current values stored in  'edit_zoom_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_zoom_subform(formptr, subforminfo)

xvf_form *formptr;
edit_zoom_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 33;


	/*** extracting 'edit->zoom_subform'
 	   Subform Information structure ***/


	index = 33;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->zoom_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_pixels_subform
*
*       Purpose: Fills in the user-specified
*                'edit_pixels_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_pixels_subform'
*
*       Output:  current values stored in  'edit_pixels_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pixels_subform(formptr, subforminfo)

xvf_form *formptr;
edit_pixels_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 43;


	/*** extracting 'edit->pixels_subform'
 	   Subform Information structure ***/


	index = 43;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->pixels_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_lut_subform
*
*       Purpose: Fills in the user-specified
*                'edit_lut_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_lut_subform'
*
*       Output:  current values stored in  'edit_lut_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_lut_subform(formptr, subforminfo)

xvf_form *formptr;
edit_lut_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 61;


	/*** extracting 'edit->lut_subform'
 	   Subform Information structure ***/


	index = 61;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->lut_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_pseudo_subform
*
*       Purpose: Fills in the user-specified
*                'edit_pseudo_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_pseudo_subform'
*
*       Output:  current values stored in  'edit_pseudo_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pseudo_subform(formptr, subforminfo)

xvf_form *formptr;
edit_pseudo_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 80;


	/*** extracting 'edit->pseudo_subform'
 	   Subform Information structure ***/


	index = 80;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->pseudo_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_thres_subform
*
*       Purpose: Fills in the user-specified
*                'edit_thres_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_thres_subform'
*
*       Output:  current values stored in  'edit_thres_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_thres_subform(formptr, subforminfo)

xvf_form *formptr;
edit_thres_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 97;


	/*** extracting 'edit->thres_subform'
 	   Subform Information structure ***/


	index = 97;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->thres_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_files_subform
*
*       Purpose: Fills in the user-specified
*                'edit_files_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_files_subform'
*
*       Output:  current values stored in  'edit_files_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_files_subform(formptr, subforminfo)

xvf_form *formptr;
edit_files_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 112;


	/*** extracting 'edit->files_subform'
 	   Subform Information structure ***/


	index = 112;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->file_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_roi_subform
*
*       Purpose: Fills in the user-specified
*                'edit_roi_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_roi_subform'
*
*       Output:  current values stored in  'edit_roi_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_roi_subform(formptr, subforminfo)

xvf_form *formptr;
edit_roi_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 135;


	/*** extracting 'edit->roi_subform'
 	   Subform Information structure ***/


	index = 135;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->roi_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_colormap_subform
*
*       Purpose: Fills in the user-specified
*                'edit_colormap_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_colormap_subform'
*
*       Output:  current values stored in  'edit_colormap_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_colormap_subform(formptr, subforminfo)

xvf_form *formptr;
edit_colormap_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 155;


	/*** extracting 'edit->colormap_subform'
 	   Subform Information structure ***/


	index = 155;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->colormap_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_xvoverlay
*
*       Purpose: Fills in the user-specified
*                'edit_xvoverlay'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_xvoverlay'
*
*       Output:  current values stored in  'edit_xvoverlay'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_xvoverlay(formptr, subforminfo)

xvf_form *formptr;
edit_xvoverlay *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 180;


	/*** extracting 'edit->xvoverlay'
 	   Subform Information structure ***/


	index = 181;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->delete = line_info.selected;

	index = 182;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->copy = line_info.selected;

	index = 183;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->raise = line_info.selected;

	index = 184;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->lower = line_info.selected;

	index = 192;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 194;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->ovfile_selected = line_info.selected;

	index = 201;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->text_selected = line_info.selected;

	index = 214;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->circle_selected = line_info.selected;

	index = 229;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->rectangle_selected = line_info.selected;

	index = 244;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->line_selected = line_info.selected;

	index = 258;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->polygon_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_comment_subform
*
*       Purpose: Fills in the user-specified
*                'edit_comment_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'edit_comment_subform'
*
*       Output:  current values stored in  'edit_comment_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_comment_subform(formptr, subforminfo)

xvf_form *formptr;
edit_comment_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 267;


	/*** extracting 'edit->comment_subform'
 	   Subform Information structure ***/


	index = 267;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->comment_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_zoom
*
*       Purpose: Fills in the user-specified
*                'zoom_subform_zoom'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'zoom_subform_zoom'
*
*       Output:  current values stored in  'zoom_subform_zoom'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_zoom(formptr, paneinfo)

xvf_form *formptr;
zoom_subform_zoom *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 34;


	/* extracting 'edit->zoom_subform->zoom'
 	   Pane Information structure */

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->zoomfactor = line_info.float_val;
	paneinfo->zoomfactor_selected = line_info.selected;
	index++;

	xvf_parse_cycle_line(database[index], &line_info);
	paneinfo->cursor = line_info.cycle_val;
	paneinfo->cursor_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->update_mode = line_info.logical_val;
	paneinfo->update_mode_selected = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->zoom_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_pixels
*
*       Purpose: Fills in the user-specified
*                'pixels_subform_pixels'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'pixels_subform_pixels'
*
*       Output:  current values stored in  'pixels_subform_pixels'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pixels(formptr, paneinfo)

xvf_form *formptr;
pixels_subform_pixels *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 44;


	/* extracting 'edit->pixels_subform->pixels'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 54;
	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->update_mode = line_info.logical_val;
	paneinfo->update_mode_selected = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->pixels_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_lut
*
*       Purpose: Fills in the user-specified
*                'lut_subform_lut'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'lut_subform_lut'
*
*       Output:  current values stored in  'lut_subform_lut'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_lut(formptr, paneinfo)

xvf_form *formptr;
lut_subform_lut *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 62;


	/* extracting 'edit->lut_subform->lut'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 72;
	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->histogram = line_info.logical_val;
	paneinfo->histogram_selected = line_info.selected;
	index++;

	xvf_parse_cycle_line(database[index], &line_info);
	paneinfo->hist_type = line_info.cycle_val;
	paneinfo->hist_type_selected = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->lut_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_pseudo
*
*       Purpose: Fills in the user-specified
*                'pseudo_subform_pseudo'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'pseudo_subform_pseudo'
*
*       Output:  current values stored in  'pseudo_subform_pseudo'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pseudo(formptr, paneinfo)

xvf_form *formptr;
pseudo_subform_pseudo *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 81;


	/* extracting 'edit->pseudo_subform->pseudo'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 91;
	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->pseudo_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_thres
*
*       Purpose: Fills in the user-specified
*                'thres_subform_thres'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'thres_subform_thres'
*
*       Output:  current values stored in  'thres_subform_thres'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_thres(formptr, paneinfo)

xvf_form *formptr;
thres_subform_thres *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 98;


	/* extracting 'edit->thres_subform->thres'
 	   Pane Information structure */

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->invert = line_info.logical_val;
	paneinfo->invert_selected = line_info.selected;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->non_zero_pixel = line_info.int_val;
	paneinfo->non_zero_pixel_selected = line_info.selected;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->thresholding_val = line_info.toggle_val;
	paneinfo->thresholding_selected = line_info.selected;
	index++;

	index = 104;
	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->thres_workspace = line_info.workspace;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->accept = line_info.logical_val;
	paneinfo->accept_selected = line_info.selected;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->fill_pixel = line_info.int_val;
	paneinfo->fill_pixel_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_file
*
*       Purpose: Fills in the user-specified
*                'files_subform_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'files_subform_file'
*
*       Output:  current values stored in  'files_subform_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_file(formptr, paneinfo)

xvf_form *formptr;
files_subform_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 113;


	/* extracting 'edit->files_subform->file'
 	   Pane Information structure */

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->input_path = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->input_path = NULL;

	paneinfo->input_path_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->output_path = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->output_path = NULL;

	paneinfo->output_path_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->image = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->image = NULL;

	paneinfo->image_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->colormap = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->colormap = NULL;

	paneinfo->colormap_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->clip = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->clip = NULL;

	paneinfo->clip_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->shape = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->shape = NULL;

	paneinfo->shape_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->overlay = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->overlay = NULL;

	paneinfo->overlay_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->outfile = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->outfile = NULL;

	paneinfo->outfile_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->outmap = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->outmap = NULL;

	paneinfo->outmap_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_roi
*
*       Purpose: Fills in the user-specified
*                'roi_subform_roi'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'roi_subform_roi'
*
*       Output:  current values stored in  'roi_subform_roi'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_roi(formptr, paneinfo)

xvf_form *formptr;
roi_subform_roi *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 136;


	/* extracting 'edit->roi_subform->roi'
 	   Pane Information structure */

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->place_val = line_info.logical_val;
	paneinfo->place_val_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->height = line_info.int_val;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->insert = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->insert = NULL;

	paneinfo->insert_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->extract = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->extract = NULL;

	paneinfo->extract_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->options = line_info.logical_val;
	paneinfo->options_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->commands = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_colormap
*
*       Purpose: Fills in the user-specified
*                'colormap_subform_colormap'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'colormap_subform_colormap'
*
*       Output:  current values stored in  'colormap_subform_colormap'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_colormap(formptr, paneinfo)

xvf_form *formptr;
colormap_subform_colormap *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 156;


	/* extracting 'edit->colormap_subform->colormap'
 	   Pane Information structure */

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_type_val = line_info.toggle_val;
	paneinfo->color_type_selected = line_info.selected;
	index++;

	index = 175;
	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_ovfile
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_ovfile'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_ovfile'
*
*       Output:  current values stored in  'xvoverlay_ovfile'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_ovfile(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_ovfile *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 195;


	/* extracting 'edit->xvoverlay->ovfile'
 	   Pane Information structure */

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->ov_input = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->ov_input = NULL;

	paneinfo->ov_input_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->ov_output = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->ov_output = NULL;

	paneinfo->ov_output_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_text
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_text'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_text'
*
*       Output:  current values stored in  'xvoverlay_text'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_text(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_text *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 202;


	/* extracting 'edit->xvoverlay->text'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->font = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->font = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->text = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->text = NULL;

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 209;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_circle
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_circle'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_circle'
*
*       Output:  current values stored in  'xvoverlay_circle'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_circle(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_circle *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 215;


	/* extracting 'edit->xvoverlay->circle'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 222;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_edge = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_edge = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_rectangle
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_rectangle'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_rectangle'
*
*       Output:  current values stored in  'xvoverlay_rectangle'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_rectangle(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_rectangle *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 230;


	/* extracting 'edit->xvoverlay->rectangle'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 237;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_corner = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_corner = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_line
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_line'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_line'
*
*       Output:  current values stored in  'xvoverlay_line'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_line(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_line *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 245;


	/* extracting 'edit->xvoverlay->line'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 251;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_end = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_end = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_polygon
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_polygon'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_polygon'
*
*       Output:  current values stored in  'xvoverlay_polygon'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_polygon(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_polygon *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 259;


	/* extracting 'edit->xvoverlay->polygon'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_comment
*
*       Purpose: Fills in the user-specified
*                'comment_subform_comment'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'comment_subform_comment'
*
*       Output:  current values stored in  'comment_subform_comment'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_comment(formptr, paneinfo)

xvf_form *formptr;
comment_subform_comment *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 268;


	/* extracting 'edit->comment_subform->comment'
 	   Pane Information structure */

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->comment_string = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->comment_string = NULL;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->comment = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


