 /*
  * Khoros: $Id: strings.c,v 1.1 1991/05/10 15:57:18 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: strings.c,v 1.1 1991/05/10 15:57:18 khoros Exp $";
#endif

 /*
  * $Log: strings.c,v $
 * Revision 1.1  1991/05/10  15:57:18  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: strings.c
   >>>>              
   >>>>   description: utility routines to handle the plot type
   >>>>			and marker names
   >>>>              
   >>>>      routines:
   >>>>			marker_type_string
   >>>>			line_type_string
   >>>>			plot_type_string
   >>>>              
   >>>> modifications:	
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
*  MODULE NAME: marker_type_string
*
*      PURPOSE: returns the string name of the marker type of a plot
*
*        INPUT: plot - pointer to the plot in question
*
*       OUTPUT: marker_name - string name of the marker type
*
*
*   WRITTEN BY: Danielle Argiro, Mark Young, Mike Lang
*
*
*************************************************************/

char *marker_type_string(plot)
XPlot *plot;
{
	char *marker_name;

	/*  all this code simply to display the appropriate prompt ! */
	switch(plot->marker)
	{
	    case MarkerSquare:
		 marker_name = xvf_strcpy("square");
		 break;
	    case MarkerTriangle:
		 marker_name = xvf_strcpy("triangle");
		 break;
	    case MarkerCross:
		 marker_name = xvf_strcpy("cross");
		 break;
	    case MarkerBowTie:
		 marker_name = xvf_strcpy("bow tie");
		 break;
	    case MarkerArc:
		 marker_name = xvf_strcpy("arc");
		 break;
	    case MarkerDiamond:
		 marker_name = xvf_strcpy("diamond");
		 break;
	    case MarkerCircle:
		 marker_name = xvf_strcpy("circle");
		 break;
	    case MarkerV:
		 marker_name = xvf_strcpy("V");
		 break;
	    case MarkerHexagon:
		 marker_name = xvf_strcpy("hexagon");
		 break;
	    case MarkerX:
		 marker_name = xvf_strcpy("X");
		 break;
	    case MarkerDot:
		 marker_name = xvf_strcpy("dot");
		 break;
	    case MarkerCaret:
		 marker_name = xvf_strcpy("carat");
		 break;
	    case MarkerPoint:
		 marker_name = xvf_strcpy("star");
		 break;
	    case MarkerDagger:
		 marker_name = xvf_strcpy("dagger");
		 break;
	    case MarkerBox:
		 marker_name = xvf_strcpy("box");
		 break;
	}
	return(marker_name);
}


/************************************************************
*
*  MODULE NAME: plot_type_string
*
*      PURPOSE: returns the string name of the plot type of a plot
*
*        INPUT: plot - pointer to the plot in question
*
*       OUTPUT: marker_name - string name of the plot type
*
*
*   WRITTEN BY: Danielle Argiro, Mark Young, Mike Lang
*
*
*
*
*************************************************************/

char *plot_type_string(plot)
XPlot *plot;
{
	char *plot_type_name;

	/*  all this code simply to display the appropriate prompt ! */
	switch(plot->plot_type)
	{
	    case PLOT_3D:
		 plot_type_name = xvf_strcpy("3D");
		 break;
	    case PLOT_MESH:
		 plot_type_name = xvf_strcpy("mesh");
		 break;
	    case PLOT_COLORMESH:
		 plot_type_name = xvf_strcpy("color mesh");
		 break;
	    case PLOT_SCATTER:
		 plot_type_name = xvf_strcpy("scatter");
		 break;
	    case PLOT_CONTOUR_3D:
		 plot_type_name = xvf_strcpy("3D contour");
		 break;
	    case PLOT_CONTOUR_2D:
		 plot_type_name = xvf_strcpy("2D contour");
		 break;
	    case PLOT_HORIZON:
		 plot_type_name = xvf_strcpy("horizon");
		 break;
	    case PLOT_2D:
		 plot_type_name = xvf_strcpy("2D");
		 break;
	    case PLOT_DISCRETE:
		 plot_type_name = xvf_strcpy("discrete ");
		 break;
	    case PLOT_HISTOGRAM:
		 plot_type_name = xvf_strcpy("bar graph");
		 break;
	    case PLOT_POLYMARKER:
		 plot_type_name = xvf_strcpy("polymarker");
		 break;
	    case PLOT_LINEMARKER:
		 plot_type_name = xvf_strcpy("linemarker");
		 break;
	    case PLOT_SURFACE:
		 plot_type_name = xvf_strcpy("surface");
		 break;
	}
	return(plot_type_name);
}


/************************************************************
*
*  MODULE NAME: line_type_string
*
*      PURPOSE: returns the string name of the line type of a plot
*
*        INPUT: plot - pointer to the plot in question
*
*       OUTPUT: line_type_name - string name of the plot type
*
*
*   WRITTEN BY: Danielle Argiro, Mark Young, Mike Lang
*
*
*
*
*************************************************************/

char *line_type_string(plot)
XPlot *plot;
{
	char *line_type_name;

	/*  all this code simply to display the appropriate prompt ! */
	switch(plot->line_type)
	{
	    case SOLID:
		 line_type_name = xvf_strcpy("solid");
		 break;
	    case DOTTED:
		 line_type_name = xvf_strcpy("dotted");
		 break;
	    case DOT_DASHED:
		 line_type_name = xvf_strcpy("dot dashed");
		 break;
	    case SHORT_DASHED:
		 line_type_name = xvf_strcpy("short dashed");
		 break;
	    case LONG_DASHED:
		 line_type_name = xvf_strcpy("long dashed");
		 break;
	    case ODD_DASHED:
		 line_type_name = xvf_strcpy("odd dashed");
		 break;
	}
	return(line_type_name);
}


/************************************************************
*
*  MODULE NAME: font_type_string
*
*      PURPOSE: returns the string name of the font type of a string
*
*        INPUT: plot - pointer to the plot in question
*
*       OUTPUT: font_name - name of the font 
*
*
*   WRITTEN BY: Danielle Argiro, Mark Young, Mike Lang
*
*
*
*
*************************************************************/

char *font_type_string(font_type)
int font_type;
{
	char *font_type_name;

	/*  all this code simply to display the appropriate prompt ! */
	switch(font_type)
	{
	    case 0 :
		 font_type_name = xvf_strcpy("DoubleRoman");
		 break;
	    case 1 :
		 font_type_name = xvf_strcpy("SimplexRoman");
		 break;
	    case 2 :
		 font_type_name = xvf_strcpy("Symbols");
		 break;
	    case 3 :
		 font_type_name = xvf_strcpy("TimesItalics");
		 break;
	    case 4 :
		 font_type_name = xvf_strcpy("ComplexItalics");
		 break;
	    case 5 :
		 font_type_name = xvf_strcpy("ComplexRoman");
		 break;
	    case 6 :
		 font_type_name = xvf_strcpy("TimesRoman");
		 break;
	}
	return(font_type_name);
}




/************************************************************
*
*  MODULE NAME: color_string
*
*      PURPOSE: returns the string name of the color 
*
*        INPUT: plot - pointer to the plot in question
*
*       OUTPUT: color_name - name of the font 
*
*
*   WRITTEN BY: Danielle Argiro, Mark Young, Mike Lang
*
*
*
*
*************************************************************/

char *color_string(color)
int color;
{
	char *color_name;

	/*  all this code simply to display the appropriate prompt ! */
	switch(color)
	{
	    case 0 :
		 color_name = xvf_strcpy("white");
		 break;
	    case 1 :
		 color_name = xvf_strcpy("MediumSpringGreen");
		 break;
	    case 2 :
		 color_name = xvf_strcpy("Yellow");
		 break;
	    case 3 :
		 color_name = xvf_strcpy("Cyan");
		 break;
	    case 4 :
		 color_name = xvf_strcpy("MediumOrchid");
		 break;
	    case 5 :
		 color_name = xvf_strcpy("Magenta");
		 break;
	    case 6 :
		 color_name = xvf_strcpy("Orange");
		 break;
	    case 7 :
		 color_name = xvf_strcpy("Wheat");
		 break;
	    case 8 :
		 color_name = xvf_strcpy("LimeGreen");
		 break;
	    case 9 :
		 color_name = xvf_strcpy("Turquoise");
		 break;
	    case 10 :
		 color_name = xvf_strcpy("Pink");
		 break;
	    case 11 :
		 color_name = xvf_strcpy("LightGrey");
		 break;
	    case 12 :
		 color_name = xvf_strcpy("Plum");
		 break;
	    case 13 :
		 color_name = xvf_strcpy("ForestGreen");
		 break;
	    case 14 :
		 color_name = xvf_strcpy("Salmon");
		 break;
	    case 15 :
		 color_name = xvf_strcpy("Thistle");
		 break;
	    case 16 :
		 color_name = xvf_strcpy("Violet");
		 break;
	    case 17 :
		 color_name = xvf_strcpy("OrangeRed");
		 break;
	    case 18 :
		 color_name = xvf_strcpy("Red");
		 break;
	    case 19 :
		 color_name = xvf_strcpy("SeaGreen");
		 break;
	    case 20 :
		 color_name = xvf_strcpy("Blue");
		 break;
	    case 21 :
		 color_name = xvf_strcpy("Goldenrod");
		 break;
	    case 22 :
		 color_name = xvf_strcpy("Coral");
		 break;
	    case 23 :
		 color_name = xvf_strcpy("Sienna");
		 break;
	}
	return(color_name);
}
