 /*
  * Khoros: $Id: trans_tables.h,v 1.2 1991/10/02 00:15:11 khoros Exp $
  */

 /*
  * $Log: trans_tables.h,v $
 * Revision 1.2  1991/10/02  00:15:11  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef _trans_tables_h_
#define _trans_tables_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>	     file: trans_tables.h				 <<<<
   >>>>                                                          <<<<
   >>>>      contains: Translation Tables                        <<<<
   >>>>                                                          <<<<
   >>>>      These are the translation tables that are used      <<<<
   >>>>      by the routines in createwid.c - xvf_create_xxx_sel <<<<           
   >>>>      routines that need to map <CR> in an asciiString    <<<<
   >>>>      widget (selection parameter box) to do something    <<<<
   >>>>      special.  In particular, "live" selections need to  <<<<
   >>>>      update form information & return to the application,<<<<
   >>>>      and selections with scroll bars need to update      <<<<
   >>>>      the scroll bar. Selections that are not live, and   <<<<
   >>>>      don't have a scroll bar, simply move the cursor to  <<<<
   >>>>      the beginning of the widget.                        <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro & Stephanie Hallett     <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/* 
 * General translation table -
 * Map <CR> and control-X to go to beginning of text widget. 
 */
XtTranslations  search_trans;
static char search_trans_table[] =
"<Key>0xff0d:   beginning-of-file() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for int selections with scroll bars
 *  Map <CR> to call xvf_update_int_scroll to update the scroll bar
 */
XtTranslations  int_scroll_trans;
static char int_scroll_trans_table[] =
"<Key>0xff0d:   xvf_update_int_scroll() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for float selections with scroll bars
 *  Map <CR> to call xvf_update_float_scroll to update the scroll bar
 */
XtTranslations  float_scroll_trans;
static char float_scroll_trans_table[] =
"<Key>0xff0d:   xvf_update_float_scroll() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for "live" int selections without scroll bars
 *  Map <CR> to call xvf_return_live_int to collect form info & return
 *  to application program
 */
XtTranslations  live_int_trans;
static char live_int_trans_table[] =
"<Key>0xff0d:   xvf_return_live_int() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for "live" float selections without scroll bars
 *  Map <CR> to call xvf_return_live_float to collect form info & return
 *  to application program
 */
XtTranslations  live_float_trans;
static char live_float_trans_table[] =
"<Key>0xff0d:   xvf_return_live_float() \n\
Ctrl<Key>x:    beginning-of-file()";


/*
 *  translation table for "live" string selections
 *  Map <CR> to call xvf_return_live_string to collect form info & return
 *  to application program
 */
XtTranslations  live_string_trans;
static char live_string_trans_table[] =
"<Key>0xff0d:   xvf_return_live_string() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for "live" input file  selections
 *  Map <CR> to call xvf_return_live_input_file to collect form info & return
 *  to application program
 */
XtTranslations  live_infile_trans;
static char live_infile_trans_table[] =
"<Key>0xff0d:   xvf_return_live_infile() \n\
Ctrl<Key>x:    beginning-of-file()";


/*
 *  translation table for "live" output file selections
 *  Map <CR> to call xvf_return_live_output_file to collect form info 
 *  & return to application program
 */
XtTranslations  live_outfile_trans;
static char live_outfile_trans_table[] =
"<Key>0xff0d:   xvf_return_live_outfile() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for AnswerInfile  selections
 *  Map <CR> to call xvf_update_forms_from_answerfile to update values
 *  shown on form
 */
XtTranslations  ansinfile_trans;
static char ansinfile_trans_table[] =
"<Key>0xff0d:   xvf_update_forms_from_answerfile() \n\
Ctrl<Key>x:    beginning-of-file()";

/*
 *  translation table for AnswerOutfile  selections
 *  Map <CR> to call xvf_update_answerfile_from_forms to update values
 *  shown on form
 */
XtTranslations  ansoutfile_trans;
static char ansoutfile_trans_table[] =
"<Key>0xff0d:   xvf_update_answerfile_from_forms() \n\
Ctrl<Key>x:    beginning-of-file()";


#endif
/* Don't add after this line */

