 /*
  * Khoros: $Id: runform.c,v 1.3 1991/12/18 09:12:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: runform.c,v 1.3 1991/12/18 09:12:19 dkhoros Exp $";
#endif

 /*
  * $Log: runform.c,v $
 * Revision 1.3  1991/12/18  09:12:19  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"

/************************************************************
*
*  Routine Name:  xvf_run_form()
*
*      Purpose:   Used to run the user interface.  This is done
*		  by done getting events and dispatching them
*		  until the FORM_DONE is set to true.  We then
*		  search thru the form list looking for the
*		  entry that matches our "current_form". We then
*		  either call the callback routine (if one exists)
*		  or return the form for the calling routine to
*		  handle.
*
*        Input:	  None.
*
*       Output:	  changes the knowledge base that was
*		  associated with the form when it was
*		  created.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett, Danielle Argiro, and Mark Young
*
*
*************************************************************/


xvf_form *xvf_run_form()
{
	xvf_list *entry;

	FORM_DONE = false;
	current_form = NULL;

	while (!FORM_DONE)
	{
	   /* this does XtNextEvent/DispatchEvent*/
           xvf_process_event();	

	   if ((FORM_DONE) && (current_form != NULL))
	   {
	      if ((entry = xvf_get_entry(current_form)) != NULL)
	      {
		 if (entry->routine != NULL)
		 {
		    FORM_DONE = false;
		    (void) entry->routine(current_form, current_subform,
					  entry->clientData);

		    current_form = NULL;
		 }
	      }
	   }
	}
	FORM_DONE = false;
	return(current_form);
}



/************************************************************
*
*  Routine Name:  xvf_map_form()
*
*      Purpose:   Used to map the user interface.  
*
*        Input:	  xvf_form - pointer to the form tree 
*
*       Output:	  maps the forms
*
*   Written By:   Danielle Argiro, Mark Young, Stephanie Hallett
*
*
*************************************************************/

xvf_map_form(form)

xvf_form *form;
{
   xvf_sub_form *subform;

   if (form->glyph_state == true)
   {
      if (form->glyph_type != ICON)
	 xvf_map_widget(form->glyph_toplevel);
   }
   else
   {
      xvf_map_widget(form->toplevel);
   }

   form->count++;

   /* map the subforms associated with master form */
   if (form->glyph_state == false)
   {
      subform = form->subform;
      while (subform != NULL)
      {
	 if ((subform->type == SubFormButton) && (subform->selected == true))
            xvf_map_subform(form, subform);

         subform = subform->next_subform;
      }
   }
}


/************************************************************
*
*  Routine Name:  xvf_map_subform()
*
*      Purpose:   Used to map a subform .  
*
*        Input:	  xvf_form - pointer to the form tree
*		  xvf_sub_form - pointer to the subform branch 
*
*       Output:	  maps the subform
*
*   Written By:   Danielle Argiro, Mark Young, Stephanie Hallett
*
*
*************************************************************/

xvf_map_subform(form, subform)

xvf_form     *form;
xvf_sub_form *subform;
{
	if (subform->glyph_state == true)
	{
	   if (subform->glyph_type != ICON)
	      xvf_map_widget(subform->glyph_toplevel);
	}
	else
	{
	   if (subform->back == NULL)
	   {
	      if (!(xvf_create_subform(form->db, form, subform, true)))
	      {
		 fprintf(stderr, "xvf_map_subform:\n");
		 fprintf(stderr, "Couldn't create subform\n");
	      }
	   }
	   xvf_map_widget(subform->toplevel);
	   subform->count++;
	}
}



/************************************************************
*
*  Routine Name:  xvf_unmap_form()
*
*      Purpose:   Used to unmap the user interface.  
*
*        Input:	  xvf_form - pointer to the form tree 
*
*       Output:	  unmaps the forms
*
*   Written By:   Danielle Argiro, Mark Young, Stephanie Hallett
*
*
*************************************************************/

xvf_unmap_form(form)
xvf_form *form;
{
   xvf_sub_form *subform;


   if (form->glyph_type != ICON)
   {
      if (form->glyph_state == true)
          xvf_unmap_widget(form->glyph_toplevel);
      else
          xvf_unmap_widget(form->toplevel);
   }
   else if (form->glyph_state == false)
      xvf_iconify_widget(form->toplevel);

   form->count++;

   /* unmap the subforms associated with master form */
   if (form->glyph_state == false)
   {
      subform = form->subform;
      while (subform != NULL)
      {
	 if (subform->type == SubFormButton && subform->selected == true)
            xvf_unmap_subform(subform);

         subform = subform->next_subform;
      }
   }
}

/************************************************************
*
*  Routine Name:  xvf_unmap_subform()
*
*      Purpose:   Used to unmap a subform   
*
*        Input:	  xvf_sub_form - pointer to the subform branch 
*
*       Output:	  unmaps the subform
*
*   Written By:   Danielle Argiro, Mark Young, Stephanie Hallett
*
*
*************************************************************/

xvf_unmap_subform(subform)

xvf_sub_form *subform;
{
      if (subform->glyph_type != ICON)
      {
         if (subform->glyph_state == true)
	    xvf_unmap_widget(subform->glyph_toplevel);
         else
	    xvf_unmap_widget(subform->toplevel);
      }
      else if (subform->glyph_state == false)
	 xvf_iconify_widget(subform->toplevel);
}
