 /*
  * Khoros: $Id: form_list.c,v 1.1 1991/05/10 15:56:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_list.c,v 1.1 1991/05/10 15:56:26 khoros Exp $";
#endif

 /*
  * $Log: form_list.c,v $
 * Revision 1.1  1991/05/10  15:56:26  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"

/************************************************************
*
*  MODULE NAME: xvf_get_entry
*
*      PURPOSE: Returns the form list structure associated 
*		to the given form structure.
*		
*
*        INPUT: form - an xvf_form structure
*
*       OUTPUT: returns the xvf_list form structure
*
*    CALLED BY:
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/

xvf_list *xvf_get_entry(form)

xvf_form	*form;
{
	xvf_list	*current;

	/*
	 *  Search through the linked form list for the desired list
	 *  structure.
	 */
	if (form_list == NULL)
	{
	   /* mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_get_entry:", NULL);
	   free(mesg); */
	   return(NULL);
	}
	else if (form_list->form == form)
	   return(form_list);

	current = form_list;
	while (current->next != NULL && current->form != form)
	      current = current->next;

	if (current->form == form)
	{
	   /*
	    *  Stick the current list form structure at the top of the list, 
	    *  since it will probably be used again soon.
	    */
/*
 Commented this caching out since it messes Stephanie up
	   current->prev->next = current->next;
	   if (current->next != NULL)
	   {
	      current->next->prev = current->prev;
	   }

	   current->next = form_list;
	   current->prev = NULL;

	   form_list->prev = current;
	   form_list = current;
 */

	   return(current);
	}
	else
	{
	   /* mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_get_entry:", NULL);
	   free(mesg); */
	   return(NULL);
	}
}



/************************************************************
*
*  MODULE NAME: xvf_add_entry
*
*      PURPOSE: 
*
*        INPUT: 1) form	      -  xvf_form struture
*		2) routine    -  the routine to call when a form needs
*			         to be run
*		3) clientData -  the client data to be returned with
*				 callback routine.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/

xvf_add_entry(form, routine, clientData)

xvf_form *form;
void	 (*routine)();
char	 *clientData;
{
	char		*mesg;
	xvf_list	*entry;

	entry = (xvf_list *) calloc(1,sizeof(xvf_list));
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("Out of memory!");
	   xvf_error_wait(mesg, "xvf_add_entry:", NULL);
	   free(mesg); return;
	}

	if (xvf_get_entry(form) != NULL)
        {
           mesg = xvf_strcpy("Form has already been added to list!");
           xvf_error_wait(mesg, "xvf_add_entry:", NULL);
           free(mesg);
	   return;
        }

	entry->form	  = form;
	entry->routine	  = routine;
	entry->clientData = clientData;

	entry->active	= false;
	entry->unmap	= false;
	entry->glyph	= false;

	entry->next	= form_list;
	entry->prev	= NULL;

	if (form_list != NULL)
	   form_list->prev	= entry;

	form_list = entry;
}



/************************************************************
*
*  MODULE NAME: xvf_delete_entry
*
*      PURPOSE: Deletes the xvf_list structure.
*
*        INPUT: form -  xvf_form structure desigating the form to be
*			deleted.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/

xvf_delete_entry(form)

xvf_form *form;
{
	xvf_list	*current;

	
	if ((current = xvf_get_entry(form)) != NULL)
	{
	   /*
	    *  Delete the entry from the list by adjusting the
	    *  next & previous pointers and then freeing the
	    *  xvf_list structure.
	    */
	   if (current->next == NULL && current->prev == NULL)
	   {
	      form_list = NULL;
	   }
	   else if (current->prev == NULL)
	   {
	      current->next->prev = NULL;
	      form_list = current->next;
	   }
	   else if (current->next == NULL)
	   {
	      current->prev->next = NULL;
	   }
	   else
	   {
	      current->next->prev = current->prev;
	      current->prev->next = current->next;
	   }
	   free(current);
	}
}



/************************************************************
*
*  MODULE NAME: xvf_change_active, xvf_change_routine
*		xvf_change_glyph, xvf_change_unmap
*				or
*			xvf_change_entry
*
*      PURPOSE: changes an entry in the xvf_list list.
*
*        INPUT: form -  xvf_form structure desigating the form to be
*			changed.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/


xvf_change_active(form, active)

xvf_form *form;
int	 active;
{
	xvf_list *entry;
	char 	 *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   if ((active == false) && (entry->active == true))
	   {
	       xvf_unmap_form(form);
	   }
	   else if ((active == true) && (entry->active == false))
	   {
	       xvf_map_form(form);
	   }
	   entry->active = active;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_change_active:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_change_routine(form, routine, clientData)

xvf_form *form;
void     (* routine)();
char	 *clientData;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   entry->routine    = routine;
	   entry->clientData = clientData;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_change_routine:", NULL);
	   free(mesg); 
	   return;
	}
}


xvf_change_unmap(form, unmap)

xvf_form *form;
int	 unmap;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   entry->unmap = unmap;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_change_unmap:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_change_glyph(form, glyph)

xvf_form *form;
int	 glyph;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   entry->glyph = glyph;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_change_glyph:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_change_entry(form, active, unmap, glyph, routine, clientData)

xvf_form *form;
int	 active, unmap, glyph;
void	 (*routine)();
char	 *clientData;
{
	/*
	 *  xvf_change_entry calls the other xvf_change routines
	 *  to do it's work.
	 */
	xvf_change_active(form, active);
	xvf_change_unmap(form, unmap);
	xvf_change_glyph(form, glyph);
	xvf_change_routine(form, routine, clientData);
}



/************************************************************
*
*  MODULE NAME: xvf_change_all_active, xvf_change_all_routine
*		xvf_change_all_glyph, xvf_change_all_unmap
*				or
*			xvf_change_all_entry
*
*      PURPOSE: changes all form entries in the xvf_list list.
*
*        INPUT:
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/


xvf_change_all_active(active)

int	 active;
{
	char		*mesg;
	xvf_list	*entry;

	entry = form_list;
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_change_all_active:", NULL);
	   free(mesg); return;
	}

	while (entry != NULL)
	{
	   entry->active = active;
	   entry = entry->next;
	}
}

xvf_change_all_routine(routine, clientData)

void     (* routine)();
char	 *clientData;
{
	char		*mesg;
	xvf_list	*entry;

	entry = form_list;
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_change_all_routine:", NULL);
	   free(mesg); return;
	}

	while (entry != NULL)
	{
	   entry->routine    = routine;
	   entry->clientData = clientData;
	   entry = entry->next;
	}
}


xvf_change_all_unmap(unmap)

int	unmap;
{
	char		*mesg;
	xvf_list	*entry;

	entry = form_list;
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_change_all_unmap:", NULL);
	   free(mesg); return;
	}

	while (entry != NULL)
	{
	   entry->unmap = unmap;
	   entry = entry->next;
	}
}

xvf_change_all_glyph(glyph)

int	glyph;
{
	char		*mesg;
	xvf_list	*entry;

	entry = form_list;
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_change_all_glyph:", NULL);
	   free(mesg); return;
	}

	while (entry != NULL)
	{
	   entry->glyph = glyph;
	   entry = entry->next;
	}
}

xvf_change_all_entry(form, active, unmap, glyph, routine, clientData)

xvf_form *form;
int	 active, unmap, glyph;
void	 (*routine)();
char	 *clientData;
{
	char		*mesg;

	if (form_list == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_change_all_entry:", NULL);
	   free(mesg); return;
	}

	/*
	 *  xvf_change_all_entry calls the other xvf_change_all routines
	 *  to do it's work.
	 */
	xvf_change_all_active(active);
	xvf_change_all_unmap(unmap);
	xvf_change_all_glyph(glyph);
	xvf_change_all_routine(routine, clientData);
}



/************************************************************
*
*  MODULE NAME: xvf_inquire_active, xvf_inquire_routine
*		xvf_inquire_glyph, xvf_inquire_unmap
*				or
*			xvf_inquire_entry
*
*      PURPOSE: inquires about an entry in the xvf_list list.
*
*        INPUT: form -  xvf_form structure desigating the form to be
*			inquired about.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Stephanie Hallet
*
*
*************************************************************/


xvf_inquire_active(form, active)

xvf_form *form;
int	 *active;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   *active = entry->active;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_inquire_active:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_inquire_routine(form, routine, clientData)

xvf_form *form;
void	 (**routine)();
char	 **clientData;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   *routine     = entry->routine;
	   *clientData = entry->clientData;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_inquire_routine:", NULL);
	   free(mesg); 
	   return;
	}
}


xvf_inquire_unmap(form, unmap)

xvf_form *form;
int	 *unmap;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   *unmap = entry->unmap;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_inquire_unmap:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_inquire_glyph(form, glyph)

xvf_form *form;
int	 *glyph;
{
	xvf_list *entry;
	char     *mesg;

	if ((entry = xvf_get_entry(form)) != NULL)
	{
	   *glyph = entry->glyph;
	}
	else
	{
	   mesg = xvf_strcpy("Unknown form!");
	   xvf_error_wait(mesg, "xvf_inquire_glyph:", NULL);
	   free(mesg); 
	   return;
	}
}

xvf_inquire_entry(form, active, unmap, glyph, routine, clientData)

xvf_form *form;
int	 *active, *unmap, *glyph;
void	 *((*routine)());
char	 **clientData;
{
	/*
	 *  xvf_inquire_entry calls the other xvf_inquire routines
	 *  to do it's work.
	 */
	xvf_inquire_active(form, active);
	xvf_inquire_unmap(form, unmap);
	xvf_inquire_glyph(form, glyph);
	xvf_inquire_routine(form, routine, clientData);
}


/*  DESTROY ALL FORMS */

xvf_destroy_all_forms()
{
	char		*mesg;
	xvf_list	*entry, *next;

	entry = form_list;
	if (entry == NULL)
	{
	   mesg = xvf_strcpy("No forms exist at this time!");
	   xvf_error_wait(mesg, "xvf_destroy_all_forms:", NULL);
	   free(mesg); return;
	}

	while (entry != NULL)
	{
	   next = entry->next;
	   xvf_destroy_form(entry->form);
	   entry = next;
	}
}
