 /*
  * Khoros: $Id: actions.c,v 1.2 1991/10/02 00:15:28 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: actions.c,v 1.2 1991/10/02 00:15:28 khoros Exp $";
#endif

 /*
  * $Log: actions.c,v $
 * Revision 1.2  1991/10/02  00:15:28  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       filename: actions.c			      <<<<
   >>>>                                                       <<<<
   >>>>		       Action Routines                        <<<<
   >>>>                                                       <<<<
   >>>>       These are the XtActionProc's that are called    <<<<
   >>>>       when the user hits <CR> in a parameter box      <<<<
   >>>>       (asciiString widget) of a selection that is     <<<<
   >>>>       either "live", or (for int & floats selections) <<<<
   >>>>       has a scroll bar. Since i cannot figure out how <<<<
   >>>>       to pass the desired information to these        <<<<
   >>>>       routines at this time, we have linked lists of  <<<<
   >>>>       the asciiString widget in question, paired with <<<<
   >>>>       the desired information structure, that are     <<<<
   >>>>       set by the xvf_create_xxx_sel procedure         <<<<
   >>>>       at the time when the selection is first created.<<<<
   >>>>       This way, for lack of a better method, we can   <<<<
   >>>>       look up the desired information pertinent to    <<<<
   >>>>       that selection when we need it.                 <<<<
   >>>>                                                       <<<<
   >>>>            xvf_update_int_scroll()                    <<<<
   >>>>            xvf_update_float_scroll()                  <<<<
   >>>>            xvf_return_live_int()                      <<<<
   >>>>            xvf_return_live_float()                    <<<<
   >>>>            xvf_return_live_string()                   <<<<
   >>>>            xvf_return_live_infile()                   <<<<
   >>>>            xvf_return_live_infile()                   <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
 

/************************************************************
*
* Routine Name:  xvf_update_int_scroll
*
*      Purpose:  When an integer selection has a scroll bar,
*	         this is the XtActionProc that is initiated when the
*	         user enters a value directly into the integer value
*		 widget and hits <CR>.  It will update the int scroll bar
*		 to reflect the new value.  If the int selection is "live",
*                it will also update the form tree and set FORM_DONE.
*
*        Input:  widget - the value widget of the integer selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_update_int_scroll(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
   IntScroll_Data *scroll_data;
   float percent;
   xvf_int_scroll_link *int_scroll_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;

   /* 
    *  find the correct int_scroll_data info for this integer
    */
   int_scroll_ptr = int_scroll_list;
   if (int_scroll_ptr == NULL) 
   {
       fprintf(stderr, "xvf_update_int_scroll: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (int_scroll_ptr->int_value != widget)
	int_scroll_ptr = int_scroll_ptr->next;
   scroll_data = int_scroll_ptr->scroll_info; 

   /* 
    *  find out if this selection is "live" - if it is, update its database
    *  line, update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = scroll_data->formptr->db;
   xvf_clear_line_info(&line_info);
   xvf_parse_int_line(database[scroll_data->selptr->index], &line_info);
   if (line_info.live == true)
   {
        current = xvf_sel_search(scroll_data->formptr, scroll_data->selptr->index);
        if (!(xvf_collect_int(scroll_data->formptr,database, current)))
  	    return;
        scroll_data->int_value = atoi(current->buffer);

        line_info.selected = true;
        line_info.int_val = scroll_data->int_value;
        line_info.literal = xvf_strcpy(current->buffer);
        xvf_deparse_int_line(&line_info, database, scroll_data->selptr->index);

        xvf_update_form_tree(database, scroll_data->selptr->index,
                             scroll_data->subformptr);

        scroll_data->subformptr->subform_sel = true;

        FORM_DONE = True;
        current_subform = scroll_data->subformptr;
        current_form = scroll_data->formptr;

   }
  
   /*
    * if this selection is not "live", simply need to collect the integer
    * from its parameter box, update the int value stored in the scroll data,
    */
   else
   {
        current = xvf_sel_search(scroll_data->formptr, scroll_data->selptr->index);
        if (!(xvf_collect_int(scroll_data->formptr,database, current)))
  	    return;
        scroll_data->int_value = atoi(current->buffer);
   }

   /* 
    * in either case, need to update the thumb of the scroll bar to match
    * the new int value in the parameter box..
    */
   percent = ((float) scroll_data->int_value - (float) scroll_data->int_min)/
	     ((float) scroll_data->interval);
   XawScrollbarSetThumb(scroll_data->int_scroll, percent, 1.0);

}


/************************************************************
*
* Routine Name:  xvf_update_float_scroll
*
*      Purpose:  When an float selection has a scroll bar,
*	         this is the XtActionProc that is initiated when the
*	         user enters a value directly into the float value
*		 widget and hits <CR>.  It will update the float scroll bar
*		 to reflect the new value.  If the float selection is "live",
*                it will also update the form tree and set FORM_DONE.
*
*        Input:  widget - the value widget of the float selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_update_float_scroll(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
   FloatScroll_Data *scroll_data;
   float percent; 
   double atof();
   xvf_float_scroll_link *float_scroll_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char  **database;

   /* 
    * find the correct float_scroll_data info for this float selection
    */
   float_scroll_ptr = float_scroll_list;
   if (float_scroll_ptr == NULL) 
   {
       fprintf(stderr, "xvf_update_float_scroll: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (float_scroll_ptr->float_value != widget)
	float_scroll_ptr = float_scroll_ptr->next;
   scroll_data = float_scroll_ptr->scroll_info; 

   /* 
    *  find out if this selection is "live" - if it is, update its database
    *  line, update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = scroll_data->formptr->db;
   xvf_clear_line_info(&line_info);
   xvf_parse_float_line(database[scroll_data->selptr->index], &line_info);
   if (line_info.live == true)
   {
        current = xvf_sel_search(scroll_data->formptr, scroll_data->selptr->index);
        if (!(xvf_collect_float(scroll_data->formptr,database, current)))
   	     return;
        scroll_data->float_value = (float) atof(current->buffer);

        line_info.selected = true;
        line_info.float_val = scroll_data->float_value;
        line_info.literal   = xvf_strcpy(current->buffer);
        xvf_deparse_float_line(&line_info, database,
                               scroll_data->selptr->index);

        xvf_update_form_tree(database, scroll_data->selptr->index,
                             scroll_data->subformptr);

        scroll_data->subformptr->subform_sel = true;

        FORM_DONE = True;
        current_subform = scroll_data->subformptr;
        current_form = scroll_data->formptr;
   }
  
   /*
    * if this selection is not "live", simply need to collect the float
    * from its parameter box, update the float value stored in the scroll data,
    */
   else
   {
       current = xvf_sel_search(scroll_data->formptr, scroll_data->selptr->index);

       if (!(xvf_collect_float(scroll_data->formptr,database, current)))
  	    return;
       scroll_data->float_value = (float) atof(current->buffer);
   }

   /* 
    * in either case, need to update the thumb of the scroll bar to match
    * the new float value in the parameter box..
    */
   percent = (scroll_data->float_value - scroll_data->float_min)/
	     ( scroll_data->interval);
   XawScrollbarSetThumb(scroll_data->float_scroll, percent, 1.0);

}

   
/************************************************************
*
* Routine Name:  xvf_return_live_int
*
*      Purpose:  When an integer selection does not have a scroll bar,
*		 but is "live", this is the XtActionProc that is initiated 
*		 when the user enters a value directly into the integer value
*		 widget and hits <CR>.  It updates the form tree and sets
*		 FORM_DONE.
*
*        Input:  widget - the value widget of the integer selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_return_live_int(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{

   Callback_Data *live_data;
   xvf_live_sel_link *live_sel_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;
   int    index;

   /* 
    * find the correct live_sel_data info for this int selection
    */
   live_sel_ptr = live_sel_list;
   if (live_sel_ptr == NULL) 
   {
       fprintf(stderr, "xvf_return_live_int: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (live_sel_ptr->value_widget != widget)
	live_sel_ptr = live_sel_ptr->next;
   live_data = live_sel_ptr->live_data; 

   /* 
    *  update the database line for this int selection,
    *  update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = live_data->formptr->db;
   index    = live_data->selptr->index;
   xvf_clear_line_info(&line_info);
   xvf_parse_int_line(database[index], &line_info);
   if (line_info.live == true)
   {
        current = xvf_sel_search(live_data->formptr, index);
        if (!(xvf_collect_int(live_data->formptr,database, current)))
   	     return;

        line_info.selected = true;
        line_info.int_val = atoi(current->buffer);
        line_info.literal = xvf_strcpy(current->buffer);
        xvf_deparse_int_line(&line_info, database, index);

        xvf_update_form_tree(database, index, live_data->subformptr);

        live_data->subformptr->subform_sel = true;

        FORM_DONE = True;
        current_subform = live_data->subformptr;
        current_form = live_data->formptr;

        xvf_collect_check_data(live_data->formptr, database, 
				live_data->guideptr);
   }
}


/************************************************************
*
* Routine Name:  xvf_return_live_float
*
*      Purpose:  When a float selection does not have a scroll bar,
*		 but is "live", this is the XtActionProc that is initiated 
*		 when the user enters a value directly into the float value
*		 widget and hits <CR>.  It updates the form tree and sets
*		 FORM_DONE.
*
*        Input:  widget - the value widget of the float selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_return_live_float(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{

   Callback_Data *live_data;
   xvf_live_sel_link *live_sel_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;
   int    index;

   /* 
    * find the correct live_sel_data info for this int selection
    */
   live_sel_ptr = live_sel_list;
   if (live_sel_ptr == NULL) 
   {
       fprintf(stderr, "xvf_return_live_float: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (live_sel_ptr->value_widget != widget)
	live_sel_ptr = live_sel_ptr->next;
   live_data = live_sel_ptr->live_data; 

   /* 
    *  update the database line for this float selection,
    *  update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = live_data->formptr->db;
   index    = live_data->selptr->index;
   xvf_clear_line_info(&line_info);
   xvf_parse_float_line(database[index], &line_info);
   if (line_info.live == true)
   {
        current = xvf_sel_search(live_data->formptr, index);
        if (!(xvf_collect_float(live_data->formptr,database, current)))
   	     return;

        line_info.selected = true;
        line_info.float_val = atof(current->buffer);
        line_info.literal   = xvf_strcpy(current->buffer);
        xvf_deparse_float_line(&line_info, database, index);

        xvf_update_form_tree(database, index, live_data->subformptr);

        live_data->subformptr->subform_sel = true;

        FORM_DONE = True;
        current_subform = live_data->subformptr;
        current_form = live_data->formptr;

        xvf_collect_check_data(live_data->formptr, database, 
				live_data->guideptr);
   }
}



/************************************************************
*
* Routine Name:  xvf_return_live_string
*
*      Purpose:  When a string selection is "live", this is the XtActionProc 
*		 that is initiated when the user enters a string in the 
*		 parameter box (asciiString widget) and hits <CR>.  
*		 It updates the form tree and sets FORM_DONE.
*
*        Input:  widget - the value widget of the string selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_return_live_string(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
   Callback_Data *live_data;
   xvf_live_sel_link *live_sel_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;
   int    index;


   /*
    * find the correct live_sel_data info for this string selection
    */
   live_sel_ptr = live_sel_list;
   if (live_sel_ptr == NULL)
   {
       fprintf(stderr, "xvf_return_live_string: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (live_sel_ptr->value_widget != widget)
        live_sel_ptr = live_sel_ptr->next;
   live_data = live_sel_ptr->live_data;

   /*
    *  update the database line for this string selection,
    *  update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = live_data->formptr->db;
   index    = live_data->selptr->index;
   xvf_clear_line_info(&line_info);
   xvf_parse_string_line(database[index], &line_info);
   current = xvf_sel_search(live_data->formptr, index);
   if (!(xvf_collect_string(live_data->formptr,database, current)))
         return;

   line_info.selected = true;
   line_info.string_val = xvf_strcpy(current->buffer);
   line_info.literal    = xvf_strcpy(current->buffer);
   xvf_deparse_string_line(&line_info, database, index);

   xvf_update_form_tree(database, index, live_data->subformptr);

   live_data->subformptr->subform_sel = true;

   FORM_DONE = True;
   current_subform = live_data->subformptr;
   current_form = live_data->formptr;

   xvf_collect_check_data(live_data->formptr, database, live_data->guideptr);

}




/************************************************************
*
* Routine Name:  xvf_return_live_infile
*
*      Purpose:  When an inputfile selection is "live" this is the XtActionProc 
*		 that is initiated when the user enters a filename in the 
*		 parameter box (asciiString widget) and hits <CR>.  
*		 It updates the form tree and sets FORM_DONE.
*
*        Input:  widget - the value widget of the input file selection
*		 event  -  the event that initiated this Action Procedure (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_return_live_infile(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{

   Callback_Data *live_data;
   xvf_live_sel_link *live_sel_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;
   int    index;


   /*
    * find the correct live_sel_data info for this input file selection
    */
   live_sel_ptr = live_sel_list;
   if (live_sel_ptr == NULL)
   {
       fprintf(stderr, "xvf_return_live_infile: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (live_sel_ptr->value_widget != widget)
        live_sel_ptr = live_sel_ptr->next;
   live_data = live_sel_ptr->live_data;

   /*
    *  update the database line for this input file selection,
    *  update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = live_data->formptr->db;
   index    = live_data->selptr->index;
   xvf_clear_line_info(&line_info);
   xvf_parse_input_line(database[index], &line_info);
   current = xvf_sel_search(live_data->formptr, index);
   if (!(xvf_collect_infile(live_data->formptr,database, current)))
         return;

   line_info.selected = true;
   line_info.filename = xvf_strcpy(current->buffer);
   line_info.literal = xvf_strcpy(current->buffer);
   xvf_deparse_input_line(&line_info, database, index);

   xvf_update_form_tree(database, index, live_data->subformptr);

   live_data->subformptr->subform_sel = true;

   FORM_DONE = True;
   current_subform = live_data->subformptr;
   current_form = live_data->formptr;

   xvf_collect_check_data(live_data->formptr, database, live_data->guideptr);

}



/************************************************************
*
* Routine Name:  xvf_return_live_outfile
*
*      Purpose:  For a "live" outputfile selection, this is the XtActionProc 
*		 that is initiated when the user enters a filename in the 
*		 parameter box (asciiString widget) and hits <CR>.  
*		 It updates the form tree and sets FORM_DONE.
*
*        Input:  widget - the value widget of the output file selection
*		 event  -  the event that initiated this Action Procedure 
*			   (<cr>)
*	         params -  can't figure out how to use this properly.
*		 num_params -  see params
*
*   Written By: Danielle Argiro
*
*************************************************************/

void xvf_return_live_outfile(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{

   Callback_Data *live_data;
   xvf_live_sel_link *live_sel_ptr;
   xvf_selection *current;
   Line_Info  line_info;
   char **database;
   int    index;


   /*
    * find the correct live_sel_data info for this output file selection
    */
   live_sel_ptr = live_sel_list;
   if (live_sel_ptr == NULL)
   {
       fprintf(stderr, "xvf_return_live_outfile: \n");
       fprintf(stderr, "   ERROR: something awful wrong; linking struct NULL\n");
       return;
   }
   while (live_sel_ptr->value_widget != widget)
        live_sel_ptr = live_sel_ptr->next;
   live_data = live_sel_ptr->live_data;

   /*
    *  update the database line for this output file selection,
    *  update the form tree, set the current form and current subform,
    *  collect & check the data from the current pane, and indicate FORM_DONE
    */
   database = live_data->formptr->db;
   index    = live_data->selptr->index;
   xvf_clear_line_info(&line_info);
   xvf_parse_output_line(database[index], &line_info);
   current = xvf_sel_search(live_data->formptr, index);
   if (!(xvf_collect_outfile(live_data->formptr,database, current)))
         return;

   line_info.selected = true;
   line_info.filename = xvf_strcpy(current->buffer);
   line_info.literal  = xvf_strcpy(current->buffer);
   xvf_deparse_output_line(&line_info, database, index);

   xvf_update_form_tree(database, index, live_data->subformptr);

   live_data->subformptr->subform_sel = true;

   FORM_DONE = True;
   current_subform = live_data->subformptr;
   current_form = live_data->formptr;

   xvf_collect_check_data(live_data->formptr, database, live_data->guideptr);

}

