 /*
  * Khoros: $Id: vdyth.c,v 1.3 1992/03/20 23:10:52 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vdyth.c,v 1.3 1992/03/20 23:10:52 dkhoros Exp $";
#endif

 /*
  * $Log: vdyth.c,v $
 * Revision 1.3  1992/03/20  23:10:52  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdyth.c
 >>>>
 >>>>      Program Name: vdyth
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform dynamic thresholding on an image.
 >>>>	
 >>>>	

 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Fri Feb 28 18:41:58 1992
 >>>>
 >>>>          Routines: main- the main program for vdyth
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vdyth.h"


/****************************************************************
 *
 * Routine Name:  main program for vdyth
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *       -w  window width argument   (1 < value < 100)
 *       -h  window height argument   (1 < value < 100)
 *       -v  non zero output pixel value   (0 < value < 255)
 *
 *
 *       [-t] Use Median as Threshold [False] or Mean [True]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    image = readimage(vdyth->i_file);
    if (image == NULL){
        (void)fprintf(stderr,"vdyth: Image could not be read\n");
         exit(1);               /* Quit if bad image */
    }

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvdyth(image,vdyth->w_int,vdyth->h_int,vdyth->t_logic,
                  vdyth->v_int))
    {
        (void) fprintf(stderr, "lvdyth Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vdyth->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vdyth 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vdyth :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform dynamic thresholding on an image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-w  window width argument  (integer, 1 to 100)\n");
	fprintf(stderr,"\t-h  window height argument  (integer, 1 to 100)\n");
	fprintf(stderr,"\t-v  non zero output pixel value  (integer, 0 to 255)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  Use Median as Threshold [False] or Mean [True] (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vdyth\n");
	fprintf(stderr, "\t[-U] Gives the usage for vdyth\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vdyth.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vdyth.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vdyth
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) window width argument \n        {integer, 1 to 100}: "; 
char	*h_pstr = 
	"\nEnter: (h) window height argument \n        {integer, 1 to 100}: "; 
char	*v_pstr = 
	"\nEnter: (v) non zero output pixel value \n        {integer, 0 to 255}: "; 
char	*t_pstr = 
	"\nEnter: (t) Use Median as Threshold [False] or Mean [True] \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vdyth", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vdyth.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vdyth: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vdyth.ans");
		}

	     }

	}

	/*
	 * allocate the vdyth structure
	 */
	vdyth = (vdyth_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vdyth_struct));

	/*
	 * get required arguments for vdyth
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vdyth->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vdyth->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdyth->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vdyth->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vdyth->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdyth->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vdyth->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdyth->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vdyth->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vdyth->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdyth->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(vdyth->w_int),
			3, 1, 100)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdyth->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vdyth->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(vdyth->w_int),
		    3, 1, 100);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdyth->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(vdyth->h_int),
			3, 1, 100)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdyth->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    vdyth->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(vdyth->h_int),
		    3, 1, 100);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdyth->v_flag = vget_int(fid, prompt_flag,
			"-v", v_pstr, &(vdyth->v_int),
			255, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdyth->v_flag))
		{
		    fprintf(stderr, "\t\tv is required, please re-enter: \n");
		    vdyth->v_flag = vget_int(fid, prompt_flag,
		    "-v", v_pstr, &(vdyth->v_int),
		    255, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-v' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vdyth
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vdyth->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vdyth->t_logic), 0);


}



