 /*
  * Khoros: $Id: vect2band.c,v 1.1 1991/05/10 15:47:07 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vect2band.c,v 1.1 1991/05/10 15:47:07 khoros Exp $";
#endif

 /*
  * $Log: vect2band.c,v $
 * Revision 1.1  1991/05/10  15:47:07  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vect2band.c
 >>>>
 >>>>      Program Name: vect2band
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	reformats data stored in vector format to a file where  each
 >>>>	vector is represented as a single band in the output file.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:23:54 1991
 >>>>
 >>>>          Routines: main- the main program for vect2band
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vect2band.h"


/****************************************************************
 *
 * Routine Name:  main program for vect2band
 *
 *       Input:  
 *           -i  input (vector) data file 
 *           -o  output (image) file 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image,         /* input/output image */
                *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}
READIMAGE(image);
CHECKTYPE(program, image);
CHECKINPUT(program, image);

if ( (image->num_data_bands > 1) && (image->map_scheme == VFF_MS_ONEPERBAND) )
{
  fprintf(stderr,"%s: MUST remove map or map data through the map before using this routine.\n", program);
}
if ((image->map_scheme == VFF_MS_CYCLE) || (image->map_scheme == VFF_MS_GROUP))
{
  fprintf(stderr,"%s: will not work with map_scheme of MS_CYCLE or MS_GROUP\n", program);
}
/* -main_before_lib_call_end */

/* -main_library_call */
 if(! lvect2band (image) )
 {
   (void) fprintf(stderr, "lvect2band Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vect2band->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vect2band 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vect2band :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\treformats data stored in vector format to a file where  each\n");
	fprintf(stderr, "\tvector is represented as a single band in the output file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input (vector) data file  (infile)\n");
	fprintf(stderr,"\t-o  output (image) file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vect2band\n");
	fprintf(stderr, "\t[-U] Gives the usage for vect2band\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vect2band.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vect2band.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vect2band
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input (vector) data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output (image) file \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vect2band", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vect2band.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vect2band: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vect2band.ans");
		}

	     }

	}

	/*
	 * allocate the vect2band structure
	 */
	vect2band = (vect2band_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vect2band_struct));

	/*
	 * get required arguments for vect2band
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vect2band->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vect2band->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vect2band->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vect2band->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vect2band->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vect2band->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vect2band->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vect2band->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vect2band->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vect2band->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



