 /*
  * Khoros: $Id: vconvert.h,v 1.3 1992/03/20 23:03:14 dkhoros Exp $
  */

 /*
  * $Log: vconvert.h,v $
 * Revision 1.3  1992/03/20  23:03:14  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vconvert.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Sun Feb 23 11:51:22 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vconvert_h_
#define _vconvert_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vconvert Argument Structure
*
****************************************************************/

typedef struct _vconvert  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  if true, bands are processed independently (Optional logical)
 */
int	 b_logic;	/* if true, bands are processed independently LOGIC */
int	 b_flag;  	/* if true, bands are processed independently FLAG */

/*
 * lets user choose output data type (Optional string toggle - )
 */
char	*t_toggle;		/* lets user choose output data type STRING TOGGLE */
int	 t_flag;		/* lets user choose output data type FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  specifies normalization value (Required float)
 */
float	 n_float;	/* specifies normalization value FLOAT */
int	 n_flag;   	/* specifies normalization value FLAG */

/*
 *  specifies scale factor (Required float)
 */
float	 s_float;	/* specifies scale factor FLOAT */
int	 s_flag;   	/* specifies scale factor FLAG */

/*-------------------------------------------*/

}  vconvert_struct;

vconvert_struct *vconvert;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
