 /*
  * Khoros: $Id: lvnot.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvnot.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvnot.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvnot.c
 >>>>
 >>>>      Program Name: vnot
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:58:47 1991 
 >>>>
 >>>>          Routines: lvnot - the library call for vnot
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvnot - library call for vnot
*
* Purpose:
*    
*    Compliment an image  by  subtracting  pixel  values  from  a
*    constant.
*    
*    
* Input:
*    
*         1.  img -- xvimage structure
*         2.  level -- subtraction constant (float)
*    
*    
* Output:
*    
*         1.  img -- xvimage structure img is used for both the  input
*         xvimage  structure  and the output result xvimage structure.
*         This is done to save space, but you must be careful  not  to
*         overwrite important data.
*    
*         lvnot returns a zero upon failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure
*    
*    
****************************************************************/


/* -library_def */
int
lvnot(img,level)
struct xvimage *img;
float level;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i;
    short  *s;
    float  *f;
    unsigned char *c;

    k = img->row_size*img->col_size * img->num_data_bands;          /* Normal operation count */
    switch (img->data_storage_type)
      {
        case VFF_TYP_BIT :
          c = (unsigned char *)(img->imagedata);
          k = (img->row_size+7)/8;
          for (j=0; j<k*img->col_size; j++) { *c = ~(*c); c++; }
          break;
        case VFF_TYP_1_BYTE : 
          c = (unsigned char *)(img->imagedata);
          for (j=0; j<k; j++) { *c = level - *c; c++; }
          break;
        case VFF_TYP_2_BYTE :
          s = (short *)(img->imagedata);
          for (j=0; j<k; j++) { *s = level - *s; s++; }
          break;
        case VFF_TYP_4_BYTE :
          i = (int *)(img->imagedata);
          for (j=0; j<k; j++) { *i = level - *i; i++; }
          break;
        case VFF_TYP_FLOAT :
          f = (float *)(img->imagedata);
          for (j=0; j<k; j++) { *f = level - *f; f++; }
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvnot: Don't know how to complement COMPLEX images (yet)\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvnot: Unknown data storage type, %d\n",img->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
