 /*
  * Khoros: $Id: lvimpulse.c,v 1.2 1991/12/18 09:24:50 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvimpulse.c,v 1.2 1991/12/18 09:24:50 dkhoros Exp $";
#endif

 /*
  * $Log: lvimpulse.c,v $
 * Revision 1.2  1991/12/18  09:24:50  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvimpulse.c
 >>>>
 >>>>      Program Name: vimpulse
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:34:01 1991 
 >>>>
 >>>>          Routines: lvimpulse - the library call for vimpulse
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvimpulse - library call for vimpulse
*
* Purpose:
*    
*    Create an image containing one or more unit impulses  spaced
*    as specified.
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    deltax         impulse spacing in x direction
*    
*    deltay         impulse spacing in y direction
*    
*    nx             number of impulses in x direction
*    
*    ny             number of impulses in y direction
*    
*    xoff           the X offset for the first impulse from the  upper
*                   left corner of the image
*    
*    yoff           the Y offset for the first impulse from the  upper
*                   left corner of the image
*    
*    rows           number of rows in the image to be generated
*    
*    cols           number of columns in the image to be generated
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

* Written By:
*
*    
*    John Rasure, Marcelo Teran, Ron E. Neher 10-May-89
*    
*    

****************************************************************/


/* -library_def */
int
lvimpulse(image,deltax,deltay,nx,ny,xoff,yoff,rows,cols)
struct xvimage **image;
int deltax,deltay,nx,ny,xoff,yoff,rows,cols;
/* -library_def_end */

/* -library_code */
{
    char *program = "lvimpulse";
    int i,j,k,l;
    unsigned char *d;
    struct xvimage *createimage();

    *image = createimage((unsigned long)rows,
                        (unsigned long)cols,
                        (unsigned long)
                        VFF_TYP_1_BYTE,         /* data_storage_type */
                        (unsigned long) 1,      /* num_of_images */
                        (unsigned long) 1,      /* num_data_bands */
                        "Impulse image",        /* comment */
                        (unsigned long) 0,      /* map_row_size */
                        (unsigned long) 0,      /* map_col_size */
                        (unsigned long)
                        VFF_MS_NONE,             /* map_scheme */
                        (unsigned long)
                        VFF_MAPTYP_NONE,        /* map_storage_type */
                        (unsigned long)
                        VFF_LOC_IMPLICIT,       /* location_type */
                        (unsigned long) 0);     /* location_dim */

    if (image == NULL)
      {
        (void)fprintf(stderr,"%s: Unable to allocate new image!\n",program);
        return(0);
      }

    d = (unsigned char *)((*image)->imagedata);
    bzero(d,rows*cols);
    for (i=0; i<nx; i++)
      {
        for (j=0; j<ny; j++)
          {
            k = i*deltax+xoff;
            l = j*deltay+yoff;
            if (k >= 0 && k < cols && l >= 0 && l < rows) *(d+l*cols+k) = 1;
          }
      }

    return(1);
}
/* -library_code_end */
