 /*
  * Khoros: $Id: vcost.c,v 1.1 1991/05/10 15:51:41 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcost.c,v 1.1 1991/05/10 15:51:41 khoros Exp $";
#endif

 /*
  * $Log: vcost.c,v $
 * Revision 1.1  1991/05/10  15:51:41  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcost.c
 >>>>
 >>>>      Program Name: vcost
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute cost (surface arc length) for an image
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:18:57 1991
 >>>>
 >>>>          Routines: main- the main program for vcost
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcost.h"


/****************************************************************
 *
 * Routine Name:  main program for vcost
 *
 *       Input:  
 *       -i  input image 
 *       -o  output image 
 *       -x  X coordinate of reference pixel  
 *       -y  Y coordinate of reference pixel  
 *
 *
 *       [-m] mask image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img, *mask, *m;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img = readimage(vcost->i_file);
        if (img == NULL) exit(1);                    

        proper_num_images(program,img,1,1);
        proper_loc_type(program,img,VFF_LOC_IMPLICIT,1);
        proper_num_bands(program,img,1,1);
        if (img->data_storage_type != VFF_TYP_FLOAT)
          {
            lvconvert(img,VFF_TYP_FLOAT,0,1,0.0,1.0,0);
          }

        mask = NULL;
        if (vcost->m_flag != 0)
          {
            m =readimage(vcost->m_file);
            if (m == NULL) exit(1);                    
            match_num_images(program,m,img,1);
            match_loc_type(program,m,img,1);
            match_num_bands(program,m,img,1);
            matchsize(program,m,img,1);
            if (m->data_storage_type != VFF_TYP_FLOAT)
              {
                mask = copyimage(m);
                lvconvert(mask,VFF_TYP_FLOAT,0,1,0.0,1.0,0);
              }
            else
              mask = m;
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvcost(img,mask,vcost->x_int,vcost->y_int) )
        {
            (void) fprintf(stderr, "lvcost Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vcost->o_file,img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcost 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcost :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute cost (surface arc length) for an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-x  X coordinate of reference pixel  (integer)\n");
	fprintf(stderr,"\t-y  Y coordinate of reference pixel  (integer)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  mask image (infile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcost\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcost\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcost.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcost.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcost
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) X coordinate of reference pixel \n        {integer}: "; 
char	*y_pstr = 
	"\nEnter: (y) Y coordinate of reference pixel \n        {integer}: "; 
char	*m_pstr = 
	"\nEnter: (m) mask image \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcost", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcost.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcost: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcost.ans");
		}

	     }

	}

	/*
	 * allocate the vcost structure
	 */
	vcost = (vcost_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcost_struct));

	/*
	 * get required arguments for vcost
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcost->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vcost->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcost->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vcost->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vcost->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcost->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vcost->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcost->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vcost->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vcost->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcost->x_flag = vget_int(fid, prompt_flag,
			"-x", x_pstr, &(vcost->x_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcost->x_flag))
		{
		    fprintf(stderr, "\t\tx is required, please re-enter: \n");
		    vcost->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(vcost->x_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcost->y_flag = vget_int(fid, prompt_flag,
			"-y", y_pstr, &(vcost->y_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcost->y_flag))
		{
		    fprintf(stderr, "\t\ty is required, please re-enter: \n");
		    vcost->y_flag = vget_int(fid, prompt_flag,
		    "-y", y_pstr, &(vcost->y_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcost
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcost->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vcost->m_file))
;


}



