 /*
  * Khoros: $Id: dfht.h,v 1.2 1992/03/20 23:21:54 dkhoros Exp $
  */

 /*
  * $Log: dfht.h,v $
 * Revision 1.2  1992/03/20  23:21:54  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfht.h
 >>>>            Author: Per Lysne
 >>>> Date Last Updated: Thu Mar  5 10:34:48 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dfht_h_
#define _dfht_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dfht Argument Structure
*
****************************************************************/

typedef struct _dfht  {

/*
 *  input signal (xviff file) (Required infile)
 */
char	*i_file;	/* input signal (xviff file) FILENAME */
int	 i_flag;	/* input signal (xviff file) FLAG */

/*
 *  output signal (xviff file) (Required outfile)
 */
char	*o_file;	/* output signal (xviff file) FILENAME */
int	 o_flag;	/* output signal (xviff file) FLAG */

/*
 *  data processing direction (n=vectors,y=bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (n=vectors,y=bands) LOGIC */
int	 d_flag;  	/* data processing direction (n=vectors,y=bands) FLAG */

/*
 * scale fft by 1, 1/N or 1/sqrt(N) (Optional integer toggle - )
 */
int	 s_toggle;		/* scale fft by 1, 1/N or 1/sqrt(N) INT TOGGLE */
int	 s_flag;		/* scale fft by 1, 1/N or 1/sqrt(N) FLAG */

}  dfht_struct;

dfht_struct *dfht;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img) {                                            \
        (void) proper_loc_type (program, img, VFF_LOC_IMPLICIT, TRUE);        \
        (void) proper_map_type (program, img, VFF_MAPTYP_NONE, TRUE);         \
        (void) proper_map_enable (program, img, VFF_MAP_OPTIONAL, TRUE);      \
        (void) proper_map_scheme (program, img, VFF_MS_NONE, TRUE);           \
        (void) proper_num_images (program, img, 1, TRUE);                     \
        (void) proper_num_bands (program, img, 1, TRUE);                      \
        if ((img->data_storage_type != VFF_TYP_1_BYTE) &&                     \
           (img->data_storage_type != VFF_TYP_2_BYTE)  &&                     \
           (img->data_storage_type != VFF_TYP_4_BYTE)  &&                     \
           (img->data_storage_type != VFF_TYP_FLOAT)) {                       \
            fprintf (stderr, "error in dfht: input data type must be ");      \
            fprintf (stderr, "byte, short, int, or float\n");                 \
            exit (1);                                                         \
        }                                                                     \
}
/* -include_macros_end */

#endif
