 /*
  * Khoros: $Id: dstats.c,v 1.3 1992/03/20 23:15:46 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dstats.c,v 1.3 1992/03/20 23:15:46 dkhoros Exp $";
#endif

 /*
  * $Log: dstats.c,v $
 * Revision 1.3  1992/03/20  23:15:46  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dstats.c
 >>>>
 >>>>      Program Name: dstats
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	dstats computes 1-D statistics of an input VIFF file.
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:28:51 1992
 >>>>
 >>>>          Routines: main- the main program for dstats
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dstats.h"


/****************************************************************
 *
 * Routine Name:  main program for dstats
 *
 *       Input:  
 *        -i  input file 
 *
 *
 *        [-m] statistics operation masking file
 *        [-f] output ASCII file
 *        [-o] VIFF format output file
 *        [-all] if yes, all stats saved
 *        [-mu] if yes, mean is a band of output
 *        [-var] if yes, variance is a band of output
 *        [-sd] if yes, std deviation is a band of output
 *        [-rms] if yes, rms is a band of output
 *        [-vmax] if yes, maximum value is a band of output
 *        [-xmax] if yes, x coord of max value is a band of output
 *        [-vmin] if yes, minimum value is a band of output
 *        [-xmin] if yes, x coord of min value is a band of output
 *        [-in] if yes, integral value is a band of output
 *        [-pin] if yes, pos part of integral is a band of output
 *        [-nin] if yes, neg part of integral is a band of output
 *        [-pts] if yes, num contributing pts is a band of output
 *        [-ppts] if yes, num positive pts is a band of output
 *        [-npts] if yes, num negative pts is a band of output
 *        [-sk] if yes, skewness is a band of output
 *        [-kur] if yes, kurtosis is a band of output
 *        [-ent] if yes, entropy is a band of output
 *        [-con] if yes, contrast is a band of output
 *        [-d] process dir. (0=down vectors, 1=across bands, 2=entire file)
 *		1 (Process by Bands),
 *		0 (direction of processing (1 = across bands, 0 = down vectors)),
 *		or 2 (Process by Bands)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1,*img2,*img3,*createimage(),*readimage();
struct lvstat   **stats, *new_stats;
FILE            *printdev;
int             i, p,
                num_bands,              /* number of bands in input image */
                opt_index;              /* bands index for output image */

int             num_opts;               /* num opts selected for VIFF output */
float           *viff_out;              /* pointer to viff output */
char            comment[512];
char            *vbasename();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT(img1) ;
READMASK(img2) ;
CHECKINPUT(program, img1) ;
MATCHINPUT(program, img1, img2) ;


/*
 * Check to see that at least one stat is specified for the VIFF output file 
 */
if ( dstats->o_flag     && !dstats->all_logic   && !dstats->mu_logic    &&
    !dstats->var_logic  && !dstats->sd_logic    && !dstats->rms_logic   &&
    !dstats->vmin_logic && !dstats->xmin_logic  && !dstats->vmax_logic  && 
    !dstats->xmax_logic && !dstats->in_logic    && !dstats->pin_logic   && 
    !dstats->nin_logic  && !dstats->pts_logic   && !dstats->ppts_logic  && 
    !dstats->npts_logic && !dstats->sk_logic    && !dstats->kur_logic   && 
    !dstats->ent_logic  && !dstats->con_logic )
{
  (void)fprintf(stderr,"%s: If VIFF output file is selected, at least",program);
  (void)fprintf(stderr,"one statistic should be selected\n");
  exit(1);
}

/*
 * If all flag is TRUE and any other stat flag is TRUE, set all flag to FALSE
 */
if (dstats->all_logic   && (dstats->mu_logic   || dstats->var_logic  ||
    dstats->sd_logic    || dstats->rms_logic   || dstats->vmin_logic ||
    dstats->xmin_logic  || dstats->vmax_logic  || dstats->xmax_logic || 
    dstats->in_logic    || dstats->pin_logic   || dstats->nin_logic  || 
    dstats->pts_logic   || dstats->ppts_logic  || dstats->npts_logic || 
    dstats->sk_logic    || dstats->kur_logic   || dstats->ent_logic  || 
    dstats->con_logic ) )
{
  dstats->all_logic = FALSE;
}

if (dstats->f_flag) 
{
  if (! vwrite_ascii(dstats->f_file, &printdev))
  {
    (void) fprintf(stderr, "%s:  Can't open ascii output file: \\n",program);
    exit(1);
  }
}
else if (!dstats->f_flag && !dstats->o_flag) {
  printdev = stdout;
  dstats->f_flag = TRUE;
}

/*
 * calculate number of stat vectors that we'll have 
 */
switch(dstats->d_toggle)
{
  case DSP_VECTOR:
       num_bands = img1->row_size * img1->col_size;
       break;
  case DSP_BAND:
       num_bands = img1->num_data_bands;
       break;
  case 2:       /* single set of stats for entire file */
       num_bands = 1;
       break;
  default:
       (void)fprintf(stderr,"%s: unknown process direction (-d): %d\n",
                     program, dstats->d_toggle);
       exit(1);
}

stats = (struct lvstat **) malloc(num_bands * sizeof(struct lvstat *));
if (stats == NULL)
{
  (void)fprintf(stderr,"%s: No memory available for statistics structure\n",
                program);
  exit(1);
}

for (i = 0 ; i < num_bands; i++)
{
  stats[i] = (struct lvstat *) malloc(sizeof(struct lvstat));
  if (stats[i] == NULL)
  {
    (void)fprintf(stderr,"%s: No memory available for statistics structure\n",
                  program);
    exit(1);
  }
}
/* -main_before_lib_call_end */

/* -main_library_call */
if (! lvstats(img1,img2,dstats->m_flag,stats,dstats->d_toggle))
{
  (void) fprintf(stderr,"%s: lvstats Failed\n",program);
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
if (dstats->f_flag)
{
  (void) fprintf(printdev,"\nStatistics for File Name: %s\n",
                 dstats->i_file);

  if (dstats->m_flag)
  {
    (void) fprintf(printdev,"Masking File Name: %s\n",
                   dstats->m_file);
  }
  (void) fprintf(printdev,"\n");
  
  for (p=0 ; p < num_bands; p++)
  {
    new_stats = stats[p];
    if (dstats->d_toggle == DSP_VECTOR)
      (void)fprintf(printdev,"\n*******  Statistics for Vector #%d  ****** \n\n",
                    p);
    if (dstats->d_toggle == DSP_BAND)
      (void)fprintf(printdev,"\n*******  Statistics for Band #%d  ****** \n\n",
                    p);
  
    (void) fprintf(printdev,"  Mean: %g\n",new_stats->mean);
    (void) fprintf(printdev,"  Variance: %g\n",new_stats->var);
    (void) fprintf(printdev,"  Std. Dev: %g\n",new_stats->sdev);
    (void) fprintf(printdev,"  RMS:  %g\n",new_stats->rms);
    (void) fprintf(printdev,"  Peaks:\n");

    if (img1->startx >= 0)  /* print location in both subsignal and parent */
    {
      (void) fprintf(printdev,"    High: %g at (X) subsignal location: (%d):",
                     new_stats->fmax,new_stats->maxp);
      (void) fprintf(printdev," signal location: (%d)\n",
                     (new_stats->maxp + img1->startx));
      (void) fprintf(printdev,"    Low : %g at (X) subsignal location: (%d):",
                     new_stats->fmin,new_stats->minp);
      (void) fprintf(printdev," signal location: (%d)\n",
                     (new_stats->minp + img1->startx));
    }
    else        /* signal is not a subsignal */
    {
      (void) fprintf(printdev,"    High: %g at (X) location: (%d)\n",
                     new_stats->fmax,new_stats->maxp);
      (void) fprintf(printdev,"    Low : %g at (X) location: (%d)\n",
                     new_stats->fmin,new_stats->minp);
    }
    (void) fprintf(printdev,"  Total integral under the image: %g\n",
                   new_stats->integ);
    (void) fprintf(printdev,"  Positive part of integral under the image: %g\n",
                   new_stats->pinteg);
    (void) fprintf(printdev,"  Negative part of integral under the image: %g\n",
                   new_stats->ninteg);
    (void) fprintf(printdev,"  Contributing points: %d\n",new_stats->cpts);
    (void) fprintf(printdev,"  Number of positive points in image: %d\n",
                   new_stats->pos);
    (void) fprintf(printdev,"  Number of negative points in image: %d\n",
                   new_stats->neg);
    if(new_stats->var == 0){
      (void) fprintf(printdev,"  Skewness:  Not calculated (variance = 0)\n");
      (void) fprintf(printdev,"  Kurtosis:  Not calculated (variance = 0)\n");
    }
    else {
      (void) fprintf(printdev,"  Skewness:  %g\n",new_stats->skewness);
      (void) fprintf(printdev,"  Kurtosis:  %g\n",new_stats->kurtosis);
    }
    if ( img1->data_storage_type == VFF_TYP_1_BYTE)
    {
      (void) fprintf(printdev,"  Entropy:  %g\n",new_stats->entropy);
      (void) fprintf(printdev,"  Contrast:  %g\n",new_stats->contrast);
    }
  }
}


if (dstats->o_flag)  /* if VIFF output file was specified */
{
  img3 = createimage((unsigned long) 1,                 /* col_size */
                     (unsigned long) num_bands,         /* row_size */
                     (unsigned long) VFF_TYP_FLOAT,     /* data_storage_type */
                     (unsigned long) 1,                 /* num_of_images */
                     (unsigned long) ALL_OPTS,          /* num_data_bands */
                     comment,                           /* comment */
                     (unsigned long) 0,                 /* map_row_size */
                     (unsigned long) 0,                 /* map_col_size */
                     (unsigned long) VFF_MS_NONE,       /* map_scheme */
                     (unsigned long) VFF_MAPTYP_NONE,   /* map_storage_type */
                     (unsigned long) VFF_LOC_IMPLICIT,  /* location_type */
                     (unsigned long) 0                  /* location_dim */
                    );

  if (img3 == NULL)
  {
    (void) fprintf(stderr,"%s: output file allocation failed\n",program);
    exit(1);
  }

  (void)sprintf(comment,"Statistics for File:  %s\n",
                vbasename(dstats->i_file));
  append_comment(img3->comment, comment);

  if(dstats->m_flag)
  {
    (void)sprintf(comment,"Masking File:  %s\n",
                  vbasename(dstats->m_file));
    append_comment(img3->comment, comment);
  }

  append_comment(img3->comment, "\n");

  num_opts = 0;
    
  if(dstats->all_logic || dstats->mu_logic)        
  {
    (void)sprintf(comment,"Band %2d: Mean\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->var_logic)
  {
    (void)sprintf(comment,"Band %2d: Variance\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->sd_logic)
  {
    (void)sprintf(comment,"Band %2d: Std Dev\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->rms_logic)
  {
    (void)sprintf(comment,"Band %2d: RMS\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->vmax_logic)
  {
    (void)sprintf(comment,"Band %2d: Max Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->xmax_logic)
  {
    (void)sprintf(comment,"Band %2d: X Pos of Max Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->vmin_logic)
  {
    (void)sprintf(comment,"Band %2d: Min Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->xmin_logic)
  {
    (void)sprintf(comment,"Band %2d: X Pos of Min Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->in_logic)
  {
    (void)sprintf(comment,"Band %2d: Total Integral\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->pin_logic)
  {
    (void)sprintf(comment,"Band %2d: Pos Part of Integ\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->nin_logic)
  {
    (void)sprintf(comment,"Band %2d: Neg Part of Integ\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->pts_logic)
  {
    (void)sprintf(comment,"Band %2d: Total Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->ppts_logic)
  {
    (void)sprintf(comment,"Band %2d: Pos Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->npts_logic)
  {
    (void)sprintf(comment,"Band %2d: Neg Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->sk_logic)
  {
    (void)sprintf(comment,"Band %2d: Skewness\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->kur_logic)
  {
    (void)sprintf(comment,"Band %2d: Kurtosis\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->ent_logic)
  {
    (void)sprintf(comment,"Band %2d: Entropy\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(dstats->all_logic || dstats->con_logic)
  {
    (void)sprintf(comment,"Band %2d: Contrast\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  img3->num_data_bands = num_opts;

 /*
  * allocate for float array to contain stat data 
  */

  viff_out = (float *)malloc((unsigned int)(num_opts * num_bands 
              * sizeof(float)));
  if (viff_out == NULL)
  {
    (void)fprintf(stderr,"%s: cannot allocate for output info\n");
  }

  for (i=0; i<num_bands; i++)
  {
    opt_index = 0;
    new_stats = stats[i];

    if (dstats->all_logic || dstats->mu_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->mean;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->var_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->var;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->sd_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->sdev;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->rms_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->rms;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->vmax_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->fmax;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->xmax_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->maxp;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->vmin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->fmin;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->xmin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->minp;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->in_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->integ;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->pin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->pinteg;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->nin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->ninteg;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->pts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->cpts;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->ppts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->pos;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->npts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->neg;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->sk_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->skewness;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->kur_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->kurtosis;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->ent_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->entropy;
      opt_index ++;
    }

    if (dstats->all_logic || dstats->con_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->contrast;
      /*opt_index ++;*/
    }

  }  /* end of for loop throught image bands */


  img3->imagedata = (char *)viff_out;

  writeimage(dstats->o_file,img3);


}  /* end or writing stat data to output file */

for (i=0; i<num_bands; i++)       
{
  free((struct lvstat *)stats[i]);
}
free((struct lvstat **)stats);
if (dstats->f_flag == TRUE && printdev != stdout)
   fclose(printdev);


/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dstats 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dstats :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tdstats computes 1-D statistics of an input VIFF file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  statistics operation masking file (infile) [null]\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr,"\t[-o]  VIFF format output file (outfile) [null]\n");
	fprintf(stderr,"\t[-all]  if yes, all stats saved (boolean) [true]\n");
	fprintf(stderr,"\t[-mu]  if yes, mean is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-var]  if yes, variance is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-sd]  if yes, std deviation is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-rms]  if yes, rms is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-vmax]  if yes, maximum value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-xmax]  if yes, x coord of max value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-vmin]  if yes, minimum value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-xmin]  if yes, x coord of min value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-in]  if yes, integral value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-pin]  if yes, pos part of integral is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-nin]  if yes, neg part of integral is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-pts]  if yes, num contributing pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ppts]  if yes, num positive pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-npts]  if yes, num negative pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-sk]  if yes, skewness is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-kur]  if yes, kurtosis is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ent]  if yes, entropy is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-con]  if yes, contrast is a band of output (boolean) [false]\n");
	fprintf(stderr, "\t[-d]  process dir. (0=down vectors, 1=across bands, 2=entire file)\n");
	fprintf(stderr, "\t\t1  (Process by Bands),\n");
	fprintf(stderr, "\t\t0  (direction of processing (1 = across bands, 0 = down vectors)),\n");
	fprintf(stderr, "\t\tor 2  (Process by Bands)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dstats\n");
	fprintf(stderr, "\t[-U] Gives the usage for dstats\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dstats.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dstats.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dstats
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file \n        {infile}: "; 
char	*m_pstr = 
	"\nEnter: (m) statistics operation masking file \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*o_pstr = 
	"\nEnter: (o) VIFF format output file \n        {outfile}: "; 
char	*all_pstr = 
	"\nEnter: (all) if yes, all stats saved \n        {boolean, (y/n)  [yes] }: "; 
char	*mu_pstr = 
	"\nEnter: (mu) if yes, mean is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*var_pstr = 
	"\nEnter: (var) if yes, variance is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*sd_pstr = 
	"\nEnter: (sd) if yes, std deviation is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*rms_pstr = 
	"\nEnter: (rms) if yes, rms is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*vmax_pstr = 
	"\nEnter: (vmax) if yes, maximum value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*xmax_pstr = 
	"\nEnter: (xmax) if yes, x coord of max value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*vmin_pstr = 
	"\nEnter: (vmin) if yes, minimum value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*xmin_pstr = 
	"\nEnter: (xmin) if yes, x coord of min value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*in_pstr = 
	"\nEnter: (in) if yes, integral value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*pin_pstr = 
	"\nEnter: (pin) if yes, pos part of integral is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*nin_pstr = 
	"\nEnter: (nin) if yes, neg part of integral is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*pts_pstr = 
	"\nEnter: (pts) if yes, num contributing pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ppts_pstr = 
	"\nEnter: (ppts) if yes, num positive pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*npts_pstr = 
	"\nEnter: (npts) if yes, num negative pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*sk_pstr = 
	"\nEnter: (sk) if yes, skewness is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*kur_pstr = 
	"\nEnter: (kur) if yes, kurtosis is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ent_pstr = 
	"\nEnter: (ent) if yes, entropy is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*con_pstr = 
	"\nEnter: (con) if yes, contrast is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = "\nEnter: (d) process dir. (0=down vectors, 1=across bands, 2=entire file) -- \n      \t\t1 (Process by Bands)\n\t\t0 (direction of processing (1 = across bands, 0 = down vectors))\n\t\tor 2 (Process by Bands)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dstats", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dstats.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dstats: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dstats.ans");
		}

	     }

	}

	/*
	 * allocate the dstats structure
	 */
	dstats = (dstats_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dstats_struct));

	/*
	 * get required arguments for dstats
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dstats->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dstats->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dstats->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dstats->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dstats->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dstats
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dstats->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(dstats->m_file))
;

	dstats->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(dstats->f_file))
;

	dstats->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(dstats->o_file))
;

	dstats->all_flag = vget_logic(fid, prompt_flag,
	"-all", all_pstr, &(dstats->all_logic), 1);

	dstats->mu_flag = vget_logic(fid, prompt_flag,
	"-mu", mu_pstr, &(dstats->mu_logic), 0);

	dstats->var_flag = vget_logic(fid, prompt_flag,
	"-var", var_pstr, &(dstats->var_logic), 0);

	dstats->sd_flag = vget_logic(fid, prompt_flag,
	"-sd", sd_pstr, &(dstats->sd_logic), 0);

	dstats->rms_flag = vget_logic(fid, prompt_flag,
	"-rms", rms_pstr, &(dstats->rms_logic), 0);

	dstats->vmax_flag = vget_logic(fid, prompt_flag,
	"-vmax", vmax_pstr, &(dstats->vmax_logic), 0);

	dstats->xmax_flag = vget_logic(fid, prompt_flag,
	"-xmax", xmax_pstr, &(dstats->xmax_logic), 0);

	dstats->vmin_flag = vget_logic(fid, prompt_flag,
	"-vmin", vmin_pstr, &(dstats->vmin_logic), 0);

	dstats->xmin_flag = vget_logic(fid, prompt_flag,
	"-xmin", xmin_pstr, &(dstats->xmin_logic), 0);

	dstats->in_flag = vget_logic(fid, prompt_flag,
	"-in", in_pstr, &(dstats->in_logic), 0);

	dstats->pin_flag = vget_logic(fid, prompt_flag,
	"-pin", pin_pstr, &(dstats->pin_logic), 0);

	dstats->nin_flag = vget_logic(fid, prompt_flag,
	"-nin", nin_pstr, &(dstats->nin_logic), 0);

	dstats->pts_flag = vget_logic(fid, prompt_flag,
	"-pts", pts_pstr, &(dstats->pts_logic), 0);

	dstats->ppts_flag = vget_logic(fid, prompt_flag,
	"-ppts", ppts_pstr, &(dstats->ppts_logic), 0);

	dstats->npts_flag = vget_logic(fid, prompt_flag,
	"-npts", npts_pstr, &(dstats->npts_logic), 0);

	dstats->sk_flag = vget_logic(fid, prompt_flag,
	"-sk", sk_pstr, &(dstats->sk_logic), 0);

	dstats->kur_flag = vget_logic(fid, prompt_flag,
	"-kur", kur_pstr, &(dstats->kur_logic), 0);

	dstats->ent_flag = vget_logic(fid, prompt_flag,
	"-ent", ent_pstr, &(dstats->ent_logic), 0);

	dstats->con_flag = vget_logic(fid, prompt_flag,
	"-con", con_pstr, &(dstats->con_logic), 0);


	/*
	 * get optional toggles for dstats
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dstats->d_flag = vget_int(fid, prompt_flag,
		"-d", d_pstr, &(dstats->d_toggle),
		1, 0, 0);

		if ((dstats->d_toggle == 1 ) || 
		    (dstats->d_toggle == 0 ) || 
		    (dstats->d_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dstats->d_flag = vget_int(fid, prompt_flag,
		"-d", d_pstr, &(dstats->d_toggle),
		1, 0, 0);

		if ((dstats->d_toggle != 1 ) && 
		    (dstats->d_toggle != 0 ) && 
		    (dstats->d_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



