 /*
  * Khoros: $Id: rast.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: rast.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: rast.h                                 <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains defines to Sun Raster	      <<<<
   >>>>                file format                            <<<<
   >>>>                                                       <<<<
   >>>>      written by: Daniel Pasono & Tom Sauer	      <<<<
   >>>>                                                       <<<<
   >>>>      date: 12/21/90                                   <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _ras_h_
#define _ras_h_

/*
 *
 *   A Sun raster image file is composed of three parts: a  header
 *   containing 8 integers, a possibly empty set of colormap values,
 *   and the pixel image, stored a line at a time, in increasing y order.
 *   The image is layed out in the file as in a memory pixrect.  Each line 
 *   of the image is rounded up to the nearest 16 bits.
 *
 *   The header is defined as follows:
 *
 *    struct rasterfile {
 *                      int  ras_magic;
 *                      int  ras_width;
 *                      int  ras_height;
 *                      int  ras_depth;
 *                      int  ras_length;
 *                      int  ras_type;
 *                      int  ras_maptype;
 *                      int  ras_maplength;
 *                     };
 *
 *   The ras_magic field always contains the value 0x59a66a95. 
 *   The ras_width and ras_height are the width & height of image in pixels. 
 *   The ras_depth is the number of bits used per pixel (1, 8, or 24).
 *   The ras_length is the number of bytes used to store the data of the image. 
 *   The ras_type field is one of the following:
 *       #define RT_OLD          0   -- Raw pixrect image in 68000 byte order
 *       #define RT_STANDARD     1   -- Raw pixrect image in 68000 byte order
 *       #define RT_BYTE_ENCODED 2   -- Run-length compression of bytes
 *       #define RT_EXPERIMENTAL 0xffff  -- Reserved for testing 
 *       For historical reasons, files of type RT_OLD will usually have a 0 in 
 *       the ras_length field and therefore the actual image length will need 
 *       to be computed. 
 *   The ras_maptype will be one of the following:
 *       #define RMT_NONE        0   --ras_maplength is expected to be 0
 *       #define RMT_EQUAL_RGB   1   --red[ras_maplength/3],green[],blue[]
 *       #define RMT_RAW         2   --Sun's registered maptype
 *       If ras_maptype is not RMT_NONE and the ras_maplength is not 0, then 
 *       the colormap values are the ras_maplength bytes immediately following 
 *       the header.
 *   The ras-maplength is the number of bytes used to store the images colormap.
 *       These values are either uninterpreted bytes (usually with the 
 *       ras_maptype set to RMT_RAW) or the equal length red, green and blue 
 *       vectors, in that order (when the ras_maptype is RMT_EQUAL_RGB). In the
 *       latter case, the ras_maplength must be three times the size in bytes 
 *       of any one of the vectors.
 *
 *   The information in this header was derived from Sun's man page for 
 *   rasterfile as well as the /usr/include/rasterfile.h file.
 *                      
 */

struct rast {
            int  ras_magic;        /* always contains 0x59a66a95    */
            int  ras_width;        /* image's width in pixels       */
            int  ras_height;       /* image's height in pixels      */
            int  ras_depth;        /* bits per pixel (1 or 8)       */
            int  ras_length;       /* length of image data in bytes */
            int  ras_type;         /* type of image (0 1 or 2)      */
            int  ras_maptype;      /* map type (0 1 or 2)           */
            int  ras_maplength;    /* length of map in bytes        */

            char *data;             /* my addition for my use        */
            /* there are ras_maplength bytes of color map following 
               and that is followed by the image data               */
           } ;

#define RAS_MAGIC       0x59a66a95

        /* Sun supported ras_type's */
#define RT_OLD          0       /* Raw pixrect image in 68000 byte order */
#define RT_STANDARD     1       /* Raw pixrect image in 68000 byte order */
#define RT_BYTE_ENCODED 2       /* Run-length compression of bytes */
#define RT_EXPERIMENTAL 0xffff  /* Reserved for testing */

        /* Sun supported ras_maptype's */
#define RMT_NONE        0       /* ras_maplength is expected to be 0 */
#define RMT_EQUAL_RGB   1       /* red[ras_maplength/3],green[],blue[] */

        /* Sun registered ras_maptype's */
#define RMT_RAW         2

#endif

/* Don't add after the endif */

