/* $Id: sa_decode.cpp,v 1.4 1997/11/20 18:31:51 eds Exp $ */
/* $Log: sa_decode.cpp,v $
// Revision 1.4  1997/11/20  18:31:51  eds
// Added SASBF block.
// Changed many direct actual parameters to pointer-passing.
// Bug fixes.
//
 * Revision 1.2  1997/11/15 00:42:59  luked
 * This is the result of the manual merge from the vendor branch for the
 * release tagged Fribourg_after_integration. I (brian) have probably lost
 * some history, but oh well.
 *
 * This contains the integration work by Eric Scheirer (MIT).
 *
// Revision 1.2  1997/11/11  22:24:39  eds
// Fixed control line bug.
//
// Revision 1.1  1997/11/10  22:54:35  eds
// Initial revision
// */

/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards-> Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include "y.tab.h"
extern "C"  {
#include "aifif.h"
#include "saol.h"
}
#include "bitstream.h"
#include "saol_tok_table.h"
#include "sa_bitstream.h"

void dump_orc(SA_streaminfo *,orc_file);
void dump_score(SA_streaminfo *info, score_file s);
int isSample(int sym);


void dump_orc(SA_streaminfo *info, orc_file *o) {
  int i,j;
  int indent =0;
  FILE *fp;

  if (!(fp = fopen(cmd.orc,"w"))) {
    printf("Couldn't write temporary orc file.\n");
    exit(1);
  }
  
  for (i=0;i!=o->length;i++) {
    switch(o->data[i].token) {
    case TOK_SYMBOL:
      if (isSample(o->data[i].sym.sym))
	fprintf(fp,"\"samp_%d.aif\"",o->data[i].sym.sym);
      else {
	if (all.has_sym)
	  fprintf(fp,"%s ",info->sym->ref(o->data[i].sym));
	else
	  fprintf(fp,"s%d ",o->data[i].sym.sym);
      }
      break;
	
    case TOK_NUMBER:
      fprintf(fp,"%lf ",o->data[i].val);
      break;
    case TOK_INT:
      fprintf(fp,"%d ",o->data[i].ival);
      break;
    case TOK_STRING:
      fprintf(fp,"\"");
      for (j=0;j!=o->data[i].length;j++) fprintf(fp,"%c ",o->data[i].str[i]);
      fprintf(fp,"\" ");
      break;
    case TOK_EOO:
      fprintf(fp,"\n");
    default:
      fprintf(fp,"%s ",tok_str(o->data[i].token));
      switch(o->data[i].token) {
      case TOK_LC :
	indent += 2;
	fprintf(fp,"\n");
	for (j=0;j!=indent;j++) fprintf(fp," ");
	break;
      case TOK_RC :
	indent -= 2;
	fprintf(fp,"\n");
	for (j=0;j!=indent;j++) fprintf(fp," ");
	if (!indent) fprintf(fp,"\n");
	break;
      case TOK_SEM:
	fprintf(fp,"\n");
	for (j=0;j!=indent;j++) fprintf(fp," ");
	break;
      }
    }
  }
  fclose(fp);
}

void dump_score(SA_streaminfo *info, score_file *s) {
  int i,j;
  FILE *fp;

  if (!(fp = fopen(cmd.sco,"w"))) {
    printf("Couldn't write temporary score file.\n");
    exit(1);
  }

  for (i=0;i!=s->num_lines;i++)
    switch (s->lines[i]->type) {
    case 0 :
      if (s->lines[i]->inst.has_label)
        fprintf(fp,"%s: ",info->sym->ref(s->lines[i]->inst.label));
      fprintf(fp,"%lf ",s->lines[i]->time);
      fprintf(fp,"%s ",info->sym->ref(s->lines[i]->inst.iname_sym));
      fprintf(fp,"%lf ",s->lines[i]->inst.dur);
      for (j=0;j!=s->lines[i]->inst.num_pf;j++)
	fprintf(fp,"%lf ",s->lines[i]->inst.pf[j]);
      fprintf(fp,"\n");
      break;
    case 1:
      fprintf(fp,"%lf ",s->lines[i]->time);
      if (s->lines[i]->control.has_label)
	fprintf(fp,"%s ",info->sym->ref(s->lines[i]->control.label));
      fprintf(fp,"control %s ",info->sym->ref(s->lines[i]->control.varsym));
      fprintf(fp,"%lf\n",s->lines[i]->control.value);
      break;
    case 2:
      fprintf(fp,"%lf table ",s->lines[i]->time);
      fprintf(fp,"%s ",info->sym->ref(s->lines[i]->table.tname));
      fprintf(fp,"%s ",tok_str(s->lines[i]->table.tgen));
      for (j=0;j!=s->lines[i]->table.num_pf;j++)
	fprintf(fp,"%lf ",s->lines[i]->table.pf[j]);
      fprintf(fp,"\n");
      break;
    case 3:
      fprintf(fp,"%lf tempo %lf\n",s->lines[i]->time,s->lines[i]->tempo.tempo);
      break;
    case 4:
      fprintf(fp,"%lf end\n",s->lines[i]->time);
      break;
    }
  fclose(fp);
}
	     
	  
	     
	       
void flerror(char *s) { printf("%s",s); exit(1); }
 
int isSample(int sym) {
   int i;

   for (i=0;i!=samp_ct;i++)
     if (samp_table[i] == sym) return 1;
   return 0;
}


void process_bitstream() {
  SA_streaminfo *info;
  Bitstream *in;
  int i;

  info = new SA_streaminfo;
  info->sym = NULL;
  in = new Bitstream(cmd.bit,BS_INPUT);
  
  info->get(*in);

  for (i=0;i!=all.num_orc;i++) 
    dump_orc(info,all.all_orc[i]);

  for (i=0;i!=all.num_sco;i++) 
    dump_score(info,all.all_score[i]);

  delete in;
  delete info;
}
