/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Naoki Iwakami (NTT) on 1997-08-25                                       */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 25-aug-1997  NI  bugfixes */

#include "tf_main.h"
#include "bitstream.h"
#include "common.h"
#include "ntt_conf.h"

void ntt_tf_local_decode(/* Input */
			 ntt_INDEX *index,
			 double    lpc_spectrum[],
			 double    bark_env[],
			 double    pitch_sequence[],
			 double    gain[],
			 double    spectrum_gain,
			 /* Output */
			 double    *reconstructed_spectrum[MAX_TIME_CHANNELS])
{
  /*--- Variables ---*/
  static double flat_spectrum_local[ntt_T_FR_MAX];
  int    n_fr, n_sb, ismp, isb, top;

  /*--- Initialization ---*/
  switch(index->w_type){
  case ONLY_LONG_WINDOW:
  case LONG_MEDIUM_WINDOW:
  case MEDIUM_LONG_WINDOW:
  case LONG_SHORT_WINDOW:
  case SHORT_LONG_WINDOW:
    n_fr = ntt_N_FR;
    n_sb = ntt_N_SUP;
    break;
  case ONLY_MEDIUM_WINDOW:
  case MEDIUM_SHORT_WINDOW:
  case SHORT_MEDIUM_WINDOW:
    n_fr = ntt_N_FR_M;
    n_sb = ntt_N_MID*ntt_N_SUP;
    ntt_zerod(ntt_N_FR*ntt_N_SUP, pitch_sequence);
    break;
  case ONLY_SHORT_WINDOW:
    n_fr = ntt_N_FR_S;
    n_sb = ntt_N_SHRT*ntt_N_SUP;
    ntt_zerod(ntt_N_FR*ntt_N_SUP, pitch_sequence);
    break;
  default:
    CommonExit(1,"ntt_tf_local_decode: window type %d is invalid",
	       index->w_type);
  }

  /*--- Requantize flattened MDCT coefficients ---*/
  ntt_tf_requantize_spectrum(index, flat_spectrum_local);

  /*--- De-flattening ---*/
  for (isb=0; isb<n_sb; isb++){
    top = isb * n_fr;
    for (ismp=0; ismp<n_fr; ismp++){
      reconstructed_spectrum[0][ismp+top] = 
	(gain[isb] * flat_spectrum_local[ismp+top] * bark_env[ismp+top]
	 + pitch_sequence[ismp+top])
	  / lpc_spectrum[ismp+top] * spectrum_gain;
    }
  }
}
