/* sys/wait.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#define INCL_DOSPROCESS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __wait (int *status)
{
  ULONG rc;
  RESULTCODES res;
  PID pid;

  rc = DosWaitChild (DCWA_PROCESS, DCWW_WAIT, &res, &pid, 0);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  switch (res.codeTerminate)
    {
    case TC_EXIT:
      *status = res.codeResult << 8;
      break;
    case TC_HARDERROR:
    case TC_KILLPROCESS:
      *status = SIGTERM;
      break;
    default:
      *status = SIGSEGV;
      break;
    }
  return pid;
}
